/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event;

import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Transaction;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class NationPreTransactionEvent
extends Event
implements Cancellable {
    private final Nation nation;
    private static final HandlerList handlers = new HandlerList();
    private final Transaction transaction;
    private String cancelMessage = "Sorry this event was cancelled.";
    private boolean isCancelled = false;

    public NationPreTransactionEvent(Nation nation, Transaction transaction) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.nation = nation;
        this.transaction = transaction;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Nation getNation() {
        return this.nation;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public String getCancelMessage() {
        return this.cancelMessage;
    }

    public void setCancelMessage(String cancelMessage) {
        this.cancelMessage = cancelMessage;
    }

    public int getNewBalance() {
        try {
            switch (this.transaction.getType()) {
                case DEPOSIT: {
                    return (int)(this.nation.getAccount().getHoldingBalance() + this.transaction.getAmount());
                }
                case WITHDRAW: {
                    return (int)(this.nation.getAccount().getHoldingBalance() - this.transaction.getAmount());
                }
            }
        }
        catch (EconomyException e) {
            BukkitTools.getServer().getLogger().warning(e.getMessage());
        }
        return 0;
    }
}

