/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.object.Transaction;
import org.bukkit.Bukkit;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;

public class TownyPreTransactionEvent
extends Event
implements Cancellable {
    private final Transaction transaction;
    private static final HandlerList handlers = new HandlerList();
    private boolean isCancelled = false;
    private final String cancelMessage = "Sorry this event was cancelled.";

    public TownyPreTransactionEvent(Transaction transaction) {
        super(!Bukkit.getServer().isPrimaryThread());
        this.transaction = transaction;
    }

    public HandlerList getHandlers() {
        return handlers;
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.isCancelled = cancelled;
    }

    public String getCancelMessage() {
        return "Sorry this event was cancelled.";
    }

    public static HandlerList getHandlerList() {
        return handlers;
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public int getNewBalance() {
        switch (this.transaction.getType()) {
            case ADD: {
                return (int)(TownyEconomyHandler.getBalance(this.transaction.getPlayer().getName(), this.transaction.getPlayer().getWorld()) + this.transaction.getAmount());
            }
            case SUBTRACT: {
                return (int)(TownyEconomyHandler.getBalance(this.transaction.getPlayer().getName(), this.transaction.getPlayer().getWorld()) - this.transaction.getAmount());
            }
        }
        return 0;
    }
}

