/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.event.executors;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.actions.TownyActionEvent;
import com.palmergames.bukkit.towny.event.actions.TownyBuildEvent;
import com.palmergames.bukkit.towny.event.actions.TownyBurnEvent;
import com.palmergames.bukkit.towny.event.actions.TownyDestroyEvent;
import com.palmergames.bukkit.towny.event.actions.TownyExplodingBlocksEvent;
import com.palmergames.bukkit.towny.event.actions.TownyExplosionDamagesEntityEvent;
import com.palmergames.bukkit.towny.event.actions.TownyItemuseEvent;
import com.palmergames.bukkit.towny.event.actions.TownySwitchEvent;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.utils.PlayerCacheUtil;
import com.palmergames.bukkit.util.ArraySort;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageEvent;

public class TownyActionEventExecutor {
    private static boolean isAllowedAction(Player player, Location loc, Material mat, TownyPermission.ActionType action, TownyActionEvent event) {
        if (!PlayerCacheUtil.getCachePermission(player, loc, mat, action)) {
            event.setCancelled(true);
            PlayerCache cache = PlayerCacheUtil.getCache(player);
            if (cache.hasBlockErrMsg()) {
                event.setMessage(cache.getBlockErrMsg());
            }
        }
        BukkitTools.getPluginManager().callEvent((Event)event);
        if (event.isCancelled() && event.getMessage() != null) {
            TownyMessaging.sendErrorMsg((Object)player, event.getMessage());
        }
        return !event.isCancelled();
    }

    private static boolean isAllowedExplosion(Location loc) {
        boolean canExplode = false;
        TownyWorld world = TownyAPI.getInstance().getTownyWorld(loc.getWorld().getName());
        if (world == null) {
            canExplode = false;
        } else if (TownyAPI.getInstance().isWilderness(loc)) {
            if (world.isForceExpl() || world.isExpl()) {
                canExplode = true;
            } else if (!world.isExpl()) {
                canExplode = false;
            }
        } else {
            canExplode = TownyAPI.getInstance().getTownBlock((Location)loc).getPermissions().explosion;
        }
        return canExplode;
    }

    private static List<Block> filterExplodingBlockList(List<Block> blocks) {
        ArrayList<Block> approvedBlocks = new ArrayList<Block>();
        for (Block block : blocks) {
            if (!TownyActionEventExecutor.isAllowedExplosion(block.getLocation())) continue;
            approvedBlocks.add(block);
        }
        return approvedBlocks;
    }

    private static Block getBlock(Location loc) {
        return Bukkit.getWorld((String)loc.getWorld().getName()).getBlockAt(loc);
    }

    private static boolean isAllowedBurn(Block block) {
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(block.getWorld().getName());
        return !(TownyAPI.getInstance().isWilderness(block) ? TownyActionEventExecutor.isNotPortal(block) && !townyWorld.isForceFire() && !townyWorld.isFire() : TownyActionEventExecutor.isNotPortal(block) && TownyActionEventExecutor.isNotFireSpreadBypassMat(block) && !townyWorld.isForceFire() && !TownyAPI.getInstance().getTownBlock((Location)block.getLocation()).getPermissions().fire);
    }

    private static boolean isNotPortal(Block block) {
        return block.getRelative(BlockFace.DOWN).getType() != Material.OBSIDIAN;
    }

    private static boolean isNotFireSpreadBypassMat(Block block) {
        switch (block.getType()) {
            case CAMPFIRE: {
                break;
            }
            default: {
                block = block.getRelative(BlockFace.DOWN);
            }
        }
        return !TownySettings.isFireSpreadBypassMaterial(block.getType().name());
    }

    public static boolean canBuild(Player player, Location loc, Material mat) {
        TownyBuildEvent event = new TownyBuildEvent(player, loc, mat, TownyActionEventExecutor.getBlock(loc), TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.BUILD, event);
    }

    public static boolean canDestroy(Player player, Location loc, Material mat) {
        TownyDestroyEvent event = new TownyDestroyEvent(player, loc, mat, TownyActionEventExecutor.getBlock(loc), TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.DESTROY, event);
    }

    public static boolean canSwitch(Player player, Location loc, Material mat) {
        TownySwitchEvent event = new TownySwitchEvent(player, loc, mat, TownyActionEventExecutor.getBlock(loc), TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.SWITCH, event);
    }

    public static boolean canItemuse(Player player, Location loc, Material mat) {
        TownyItemuseEvent event = new TownyItemuseEvent(player, loc, mat, TownyAPI.getInstance().getTownBlock(loc), false);
        return TownyActionEventExecutor.isAllowedAction(player, loc, mat, TownyPermission.ActionType.ITEM_USE, event);
    }

    public static List<Block> filterExplodableBlocks(List<Block> blockList, Material mat, Entity entity) {
        blockList.sort(ArraySort.getInstance());
        List<Block> filteredBlocks = TownyActionEventExecutor.filterExplodingBlockList(blockList);
        TownyExplodingBlocksEvent event = new TownyExplodingBlocksEvent(blockList, filteredBlocks, mat, entity);
        BukkitTools.getPluginManager().callEvent((Event)event);
        if (event.isChanged()) {
            filteredBlocks = event.getBlockList();
        }
        return filteredBlocks;
    }

    public static boolean canExplosionDamageEntities(Location loc, Entity harmedEntity, EntityDamageEvent.DamageCause cause) {
        boolean cancelled = !TownyActionEventExecutor.isAllowedExplosion(loc);
        TownyExplosionDamagesEntityEvent event = new TownyExplosionDamagesEntityEvent(loc, harmedEntity, cause, TownyAPI.getInstance().getTownBlock(loc), cancelled);
        BukkitTools.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public static boolean canBurn(Block block) {
        boolean cancelled = !TownyActionEventExecutor.isAllowedBurn(block);
        TownyBurnEvent event = new TownyBurnEvent(block, block.getLocation(), TownyAPI.getInstance().getTownBlock(block.getLocation()), cancelled);
        BukkitTools.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }
}

