/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.util.BlockUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.Chest;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockIgniteEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;

public class TownyBlockListener
implements Listener {
    private final Towny plugin;

    public TownyBlockListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        if (!TownyAPI.getInstance().isTownyWorld(block.getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), block.getLocation(), block.getType()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Block block = event.getBlock();
        if (!TownyAPI.getInstance().isTownyWorld(block.getWorld())) {
            return;
        }
        if (block.getType() == Material.FIRE && block.getRelative(BlockFace.DOWN).getType() == Material.OBSIDIAN) {
            return;
        }
        if (!TownyActionEventExecutor.canBuild(event.getPlayer(), block.getLocation(), block.getType())) {
            event.setBuild(true);
            event.setCancelled(true);
        }
        if (!event.isCancelled() && block.getType() == Material.CHEST) {
            this.testDoubleChest(event.getPlayer(), event.getBlock(), event);
        }
    }

    private void testDoubleChest(Player player, Block block, BlockPlaceEvent event) {
        ArrayList<Block> blocksToUpdate = new ArrayList<Block>();
        for (BlockFace face : BlockUtil.CARDINAL_BLOCKFACES) {
            Block testBlock = block.getRelative(face);
            if (testBlock.getType() != Material.CHEST) continue;
            Chest data = (Chest)block.getBlockData();
            Chest testData = (Chest)testBlock.getBlockData();
            if (!data.getFacing().equals((Object)testData.getFacing())) continue;
            blocksToUpdate.add(testBlock);
            if (BlockUtil.sameOwner(block, testBlock)) continue;
            data.setType(Chest.Type.SINGLE);
            block.setBlockData((BlockData)data);
            testData.setType(Chest.Type.SINGLE);
            testBlock.setBlockData((BlockData)testData);
        }
        if (!blocksToUpdate.isEmpty()) {
            for (Block b : blocksToUpdate) {
                player.sendBlockChange(b.getLocation(), b.getBlockData());
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBurn(event.getBlock()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onBlockIgnite(BlockIgniteEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBurn(event.getBlock()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonRetract(BlockPistonRetractEvent event) {
        List blocks;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.testBlockMove(event.getBlock(), event.isSticky() ? event.getDirection().getOppositeFace() : event.getDirection())) {
            event.setCancelled(true);
        }
        if (!(blocks = event.getBlocks()).isEmpty()) {
            for (Block block : blocks) {
                if (!this.testBlockMove(block, event.getDirection())) continue;
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onBlockPistonExtend(BlockPistonExtendEvent event) {
        List blocks;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (this.testBlockMove(event.getBlock(), event.getDirection())) {
            event.setCancelled(true);
        }
        if (!(blocks = event.getBlocks()).isEmpty()) {
            for (Block block : blocks) {
                if (!this.testBlockMove(block, event.getDirection())) continue;
                event.setCancelled(true);
            }
        }
    }

    private boolean testBlockMove(Block block, BlockFace direction) {
        Block blockTo = block.getRelative(direction);
        Location loc = block.getLocation();
        Location locTo = blockTo.getLocation();
        TownBlock currentTownBlock = null;
        TownBlock destinationTownBlock = null;
        currentTownBlock = TownyAPI.getInstance().getTownBlock(loc);
        if (currentTownBlock != (destinationTownBlock = TownyAPI.getInstance().getTownBlock(locTo))) {
            if (currentTownBlock == null && destinationTownBlock != null || currentTownBlock != null && destinationTownBlock == null) {
                return true;
            }
            if (!currentTownBlock.hasResident() && !destinationTownBlock.hasResident()) {
                return false;
            }
            try {
                if (!currentTownBlock.hasResident() && destinationTownBlock.hasResident() || currentTownBlock.hasResident() && !destinationTownBlock.hasResident() || currentTownBlock.getResident() != destinationTownBlock.getResident() || currentTownBlock.getPlotPrice() != -1.0 || destinationTownBlock.getPlotPrice() != -1.0) {
                    return true;
                }
            }
            catch (NotRegisteredException e) {
                return true;
            }
        }
        return false;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreateExplosion(BlockExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(event.getBlock().getLocation().getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        Material material = event.getBlock().getType();
        if (material == Material.AIR && townyWorld.hasBedExplosionAtBlock(event.getBlock().getLocation())) {
            material = townyWorld.getBedExplosionMaterial(event.getBlock().getLocation());
        }
        List<Block> blocks = TownyActionEventExecutor.filterExplodableBlocks(event.blockList(), material, null);
        event.blockList().clear();
        event.blockList().addAll(blocks);
        if (event.blockList().isEmpty()) {
            return;
        }
        if (townyWorld.isUsingPlotManagementWildBlockRevert() && townyWorld.isProtectingExplosionBlock(material)) {
            int count = 0;
            for (Block block : blocks) {
                if (!TownyAPI.getInstance().isWilderness(block)) continue;
                event.setCancelled(!TownyRegenAPI.beginProtectionRegenTask(block, ++count, townyWorld));
            }
        }
    }
}

