/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.event.mobs.MobSpawnRemovalEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.tasks.MobRemovalTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ItemLists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.Creature;
import org.bukkit.entity.DragonFireball;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Villager;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.AreaEffectCloudApplyEvent;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityCombustByEntityEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.entity.EntityInteractEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.entity.EntityTargetLivingEntityEvent;
import org.bukkit.event.entity.LingeringPotionSplashEvent;
import org.bukkit.event.entity.PigZapEvent;
import org.bukkit.event.entity.PotionSplashEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.hanging.HangingBreakByEntityEvent;
import org.bukkit.event.hanging.HangingBreakEvent;
import org.bukkit.event.hanging.HangingPlaceEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.projectiles.ProjectileSource;

public class TownyEntityListener
implements Listener {
    private final Towny plugin;

    public TownyEntityListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityDamageByEntity(EntityDamageByEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Entity attacker = event.getDamager();
        Entity defender = event.getEntity();
        if (event.getCause() == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION && !(attacker instanceof Projectile)) {
            boolean cancelExplosiveDamage = false;
            if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defender) && !TownyActionEventExecutor.canExplosionDamageEntities(event.getEntity().getLocation(), event.getEntity(), event.getCause())) {
                cancelExplosiveDamage = true;
            }
            if (defender instanceof Player && EntityTypeUtil.isPVPExplosive(attacker.getType())) {
                try {
                    cancelExplosiveDamage = CombatUtil.preventPvP(TownyUniverse.getInstance().getDataSource().getWorld(defender.getWorld().getName()), TownyAPI.getInstance().getTownBlock(defender.getLocation()));
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            if (cancelExplosiveDamage) {
                event.setDamage(0.0);
                event.setCancelled(true);
                return;
            }
        }
        if (!TownyAPI.getInstance().isWarTime()) {
            if (CombatUtil.preventDamageCall(this.plugin, attacker, defender)) {
                if (attacker instanceof Projectile && !attacker.getType().equals((Object)EntityType.TRIDENT)) {
                    attacker.remove();
                }
                event.setCancelled(true);
            }
        } else {
            try {
                if (attacker instanceof Projectile) {
                    ProjectileSource shooter = ((Projectile)attacker).getShooter();
                    if (shooter instanceof Entity) {
                        attacker = (Entity)shooter;
                    } else {
                        BlockProjectileSource bShooter = (BlockProjectileSource)((Projectile)attacker).getShooter();
                        if (TownyAPI.getInstance().getTownBlock(bShooter.getBlock().getLocation()) != null) {
                            Town bTown = TownyAPI.getInstance().getTownBlock(bShooter.getBlock().getLocation()).getTown();
                            if (!bTown.hasNation() && TownySettings.isWarTimeTownsNeutral()) {
                                event.setCancelled(true);
                                return;
                            }
                            if (bTown.getNation().isNeutral()) {
                                event.setCancelled(true);
                                return;
                            }
                            if (!War.isWarringTown(bTown)) {
                                event.setCancelled(true);
                                return;
                            }
                        }
                    }
                }
                if (!(attacker instanceof Player) || !(defender instanceof Player)) {
                    if (CombatUtil.preventDamageCall(this.plugin, attacker, defender)) {
                        if (attacker instanceof Projectile && !attacker.getType().equals((Object)EntityType.TRIDENT)) {
                            attacker.remove();
                        }
                        event.setCancelled(true);
                    }
                    return;
                }
                TownyUniverse universe = TownyUniverse.getInstance();
                Resident attackerResident = universe.getResident(attacker.getUniqueId());
                Resident defenderResident = universe.getResident(defender.getUniqueId());
                if (attackerResident == null || defenderResident == null) {
                    return;
                }
                TownyWorld world = universe.getDataSource().getWorld(attacker.getLocation().getWorld().getName());
                if (!(attackerResident.hasTown() && defenderResident.hasTown() || !TownySettings.isWarTimeTownsNeutral())) {
                    TownyMessaging.sendMessage((Object)attacker, Translation.of("msg_war_a_player_has_no_town"));
                    event.setCancelled(true);
                    return;
                }
                try {
                    Town attackerTown = attackerResident.getTown();
                    Town defenderTown = defenderResident.getTown();
                    if (!(attackerTown.hasNation() && defenderTown.hasNation() || !TownySettings.isWarTimeTownsNeutral())) {
                        TownyMessaging.sendMessage((Object)attacker, Translation.of("msg_war_a_player_has_no_nation"));
                        event.setCancelled(true);
                        return;
                    }
                    if (attackerTown.getNation().isNeutral() || defenderTown.getNation().isNeutral()) {
                        TownyMessaging.sendMessage((Object)attacker, Translation.of("msg_war_a_player_has_a_neutral_nation"));
                        event.setCancelled(true);
                        return;
                    }
                    if (!War.isWarringTown(defenderTown) || !War.isWarringTown(attackerTown)) {
                        TownyMessaging.sendMessage((Object)attacker, Translation.of("msg_war_a_player_has_been_removed_from_war"));
                        event.setCancelled(true);
                        return;
                    }
                    if ((attackerTown.getNation().hasAlly(defenderTown.getNation()) || defenderTown.getNation().hasAlly(attackerTown.getNation())) && !world.isFriendlyFireEnabled()) {
                        TownyMessaging.sendMessage((Object)attacker, Translation.of("msg_war_a_player_is_an_ally"));
                        event.setCancelled(true);
                        return;
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (CombatUtil.preventFriendlyFire((Player)attacker, (Player)defender, world)) {
                    if (attacker instanceof Projectile) {
                        attacker.remove();
                    }
                    event.setCancelled(true);
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityDeath(EntityDeathEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        LivingEntity entity = event.getEntity();
        if (!TownyAPI.getInstance().isTownyWorld(entity.getWorld()) || TownyAPI.getInstance().isWilderness(entity.getLocation())) {
            return;
        }
        if (entity instanceof Monster && TownyAPI.getInstance().getTownBlock(entity.getLocation()).getType() == TownBlockType.ARENA) {
            event.getDrops().clear();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityTargetLivingEntity(EntityTargetLivingEntityEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getTarget() instanceof Player && event.getReason().equals((Object)EntityTargetEvent.TargetReason.TEMPT)) {
            Location loc = event.getEntity().getLocation();
            if (TownyAPI.getInstance().isWilderness(loc)) {
                return;
            }
            if (!TownyAPI.getInstance().getTownBlock(loc).hasResident()) {
                return;
            }
            event.setCancelled(!TownyActionEventExecutor.canDestroy((Player)event.getTarget(), loc, Material.DIRT));
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onEntityTakesBlockExplosionDamage(EntityDamageEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!(event.getCause() != EntityDamageEvent.DamageCause.BLOCK_EXPLOSION && event.getCause() != EntityDamageEvent.DamageCause.LIGHTNING || TownyActionEventExecutor.canExplosionDamageEntities(event.getEntity().getLocation(), event.getEntity(), event.getCause()))) {
            event.setDamage(0.0);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onDragonFireBallCloudDamage(AreaEffectCloudApplyEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (!event.getEntity().getCustomEffects().stream().anyMatch(effect -> effect.getType().equals((Object)PotionEffectType.HARM))) {
            return;
        }
        if (!(event.getEntity().getSource() instanceof Player) || !(event.getEntity().getSource() instanceof DragonFireball)) {
            return;
        }
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(event.getEntity().getWorld().getName());
        }
        catch (NotRegisteredException e) {
            return;
        }
        TownBlock townBlock = TownyAPI.getInstance().getTownBlock(event.getEntity().getLocation());
        if (CombatUtil.preventPvP(townyWorld, townBlock)) {
            event.setCancelled(true);
            event.getEntity().remove();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onLingeringPotionSplashEvent(LingeringPotionSplashEvent event) {
        ThrownPotion potion = event.getEntity();
        Location loc = potion.getLocation();
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(loc.getWorld().getName());
        }
        catch (NotRegisteredException e) {
            return;
        }
        float radius = event.getAreaEffectCloud().getRadius();
        ArrayList<Block> blocks = new ArrayList<Block>();
        for (double x = loc.getX() - (double)radius; x < loc.getX() + (double)radius; x += 1.0) {
            for (double z = loc.getZ() - (double)radius; z < loc.getZ() + (double)radius; z += 1.0) {
                Location loc2 = new Location(potion.getWorld(), x, loc.getY(), z);
                Block b = loc2.getBlock();
                if (!b.getType().equals((Object)Material.AIR)) continue;
                blocks.add(b);
            }
        }
        List effects = (List)potion.getEffects();
        boolean detrimental = false;
        List<String> prots = TownySettings.getPotionTypes();
        for (PotionEffect effect : effects) {
            if (!prots.contains(effect.getType().getName())) continue;
            detrimental = true;
        }
        ProjectileSource source = potion.getShooter();
        if (!(source instanceof Entity)) {
            return;
        }
        for (Block block : blocks) {
            if (TownyAPI.getInstance().isWilderness(block.getLocation())) continue;
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(block.getLocation());
            if (TownyAPI.getInstance().isWarTime() || !CombatUtil.preventPvP(townyWorld, townBlock) || !detrimental) continue;
            event.setCancelled(true);
            break;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPotionSplashEvent(PotionSplashEvent event) {
        List affectedEntities = (List)event.getAffectedEntities();
        ThrownPotion potion = event.getPotion();
        List effects = (List)potion.getEffects();
        boolean detrimental = false;
        List<String> prots = TownySettings.getPotionTypes();
        for (PotionEffect effect : effects) {
            if (!prots.contains(effect.getType().getName())) continue;
            detrimental = true;
        }
        ProjectileSource source = potion.getShooter();
        if (!(source instanceof Entity)) {
            return;
        }
        Entity attacker = (Entity)source;
        if (!TownyAPI.getInstance().isWarTime()) {
            for (LivingEntity defender : affectedEntities) {
                if (attacker == defender || !CombatUtil.preventDamageCall(this.plugin, attacker, (Entity)defender) || !detrimental) continue;
                event.setIntensity(defender, -1.0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onCreatureSpawn(CreatureSpawnEvent event) throws NotRegisteredException {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (event.getEntity() != null) {
            LivingEntity livingEntity = event.getEntity();
            if (this.plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) {
                return;
            }
            Location loc = event.getLocation();
            TownyWorld townyWorld = null;
            try {
                townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(loc.getWorld().getName());
            }
            catch (NotRegisteredException e) {
                return;
            }
            MobSpawnRemovalEvent mobSpawnRemovalEvent = new MobSpawnRemovalEvent((Entity)event.getEntity());
            this.plugin.getServer().getPluginManager().callEvent((Event)mobSpawnRemovalEvent);
            if (mobSpawnRemovalEvent.isCancelled()) {
                return;
            }
            if (!townyWorld.hasWorldMobs() && MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) {
                event.setCancelled(true);
            }
            if (livingEntity instanceof Villager && !((Villager)livingEntity).isAdult() && TownySettings.isRemovingVillagerBabiesWorld()) {
                event.setCancelled(true);
            }
            if (TownyAPI.getInstance().isWilderness(loc)) {
                if (!townyWorld.hasWildernessMobs() && MobRemovalTimerTask.isRemovingWildernessEntity(livingEntity)) {
                    event.setCancelled(true);
                }
                return;
            }
            TownBlock townBlock = TownyAPI.getInstance().getTownBlock(loc);
            if (!townyWorld.isForceTownMobs() && !townBlock.getPermissions().mobs && MobRemovalTimerTask.isRemovingTownEntity(livingEntity)) {
                event.setCancelled(true);
            }
            if (livingEntity instanceof Villager && !((Villager)livingEntity).isAdult() && TownySettings.isRemovingVillagerBabiesTown()) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityInteract(EntityInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        Block block = event.getBlock();
        Entity entity = event.getEntity();
        List passengers = entity.getPassengers();
        if (passengers != null) {
            for (Entity passenger : passengers) {
                if (!passenger.getType().equals((Object)EntityType.PLAYER)) {
                    return;
                }
                if (!TownySettings.isSwitchMaterial(block.getType().name())) continue;
                event.setCancelled(!TownyActionEventExecutor.canSwitch((Player)passenger, block.getLocation(), block.getType()));
                return;
            }
        }
        if (TownySettings.isCreatureTriggeringPressurePlateDisabled() && block.getType() == Material.STONE_PRESSURE_PLATE && entity instanceof Creature) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityChangeBlockEvent(EntityChangeBlockEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getBlock().getWorld())) {
            return;
        }
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(event.getBlock().getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (event.getBlock().getType().equals((Object)Material.FARMLAND)) {
            if (!event.getEntityType().equals((Object)EntityType.PLAYER) && townyWorld.isDisableCreatureTrample()) {
                event.setCancelled(true);
                return;
            }
            if (event.getEntityType().equals((Object)EntityType.PLAYER) && townyWorld.isDisablePlayerTrample()) {
                event.setCancelled(true);
                return;
            }
        }
        switch (event.getEntity().getType()) {
            case ENDERMAN: {
                if (!townyWorld.isEndermanProtect()) break;
                event.setCancelled(true);
                break;
            }
            case RAVAGER: {
                if (!townyWorld.isDisableCreatureTrample()) break;
                event.setCancelled(true);
                break;
            }
            case WITHER: {
                List<Block> allowed = TownyActionEventExecutor.filterExplodableBlocks(new ArrayList<Block>(Collections.singleton(event.getBlock())), event.getBlock().getType(), event.getEntity());
                event.setCancelled(allowed.isEmpty());
                break;
            }
            case SPLASH_POTION: {
                if (event.getBlock().getType() != Material.CAMPFIRE && ((ThrownPotion)event.getEntity()).getShooter() instanceof Player) {
                    return;
                }
                event.setCancelled(!TownyActionEventExecutor.canDestroy((Player)((ThrownPotion)event.getEntity()).getShooter(), event.getBlock().getLocation(), Material.CAMPFIRE));
                break;
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(event.getLocation().getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        List<Block> blocks = TownyActionEventExecutor.filterExplodableBlocks(event.blockList(), null, event.getEntity());
        event.blockList().clear();
        event.blockList().addAll(blocks);
        if (event.blockList().isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        if (townyWorld.isUsingPlotManagementWildEntityRevert() && entity != null && townyWorld.isProtectingExplosionEntity(entity)) {
            int count = 0;
            for (Block block : blocks) {
                if (!TownyAPI.getInstance().isWilderness(block)) {
                    return;
                }
                event.setCancelled(!TownyRegenAPI.beginProtectionRegenTask(block, ++count, townyWorld));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onEntityCombustByEntityEvent(EntityCombustByEntityEvent event) throws NotRegisteredException {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        Entity combuster = event.getCombuster();
        Entity defender = event.getEntity();
        if (combuster instanceof Projectile) {
            ProjectileSource source = ((Projectile)combuster).getShooter();
            if (!(source instanceof LivingEntity)) {
                return;
            }
            LivingEntity attacker = (LivingEntity)source;
            if (attacker != null && !TownyAPI.getInstance().isWarTime() && CombatUtil.preventDamageCall(this.plugin, (Entity)attacker, defender)) {
                combuster.remove();
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingBreak(HangingBreakEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        Hanging hanging = event.getEntity();
        TownyWorld townyWorld = TownyAPI.getInstance().getTownyWorld(hanging.getWorld().getName());
        if (event.getCause().equals((Object)HangingBreakEvent.RemoveCause.PHYSICS) && hanging.getType().equals((Object)EntityType.ITEM_FRAME)) {
            Location loc = hanging.getLocation().add(hanging.getFacing().getOppositeFace().getDirection());
            Block block = loc.getBlock();
            if (block.isLiquid() || block.isEmpty()) {
                return;
            }
            for (Entity entity : hanging.getNearbyEntities(0.5, 0.5, 0.5)) {
                if (!(entity instanceof Vehicle)) continue;
                event.setCancelled(true);
                return;
            }
        }
        if (event instanceof HangingBreakByEntityEvent) {
            HangingBreakByEntityEvent evt = (HangingBreakByEntityEvent)event;
            Entity remover = evt.getRemover();
            if (remover instanceof Projectile) {
                remover = ((Projectile)remover).getShooter();
            }
            if (remover instanceof Player) {
                Player player = (Player)remover;
                Material mat = null;
                switch (event.getEntity().getType()) {
                    case PAINTING: 
                    case LEASH_HITCH: 
                    case ITEM_FRAME: {
                        mat = EntityTypeUtil.parseEntityToMaterial(event.getEntity().getType());
                        break;
                    }
                    default: {
                        mat = Material.GRASS_BLOCK;
                    }
                }
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, hanging.getLocation(), mat));
            } else if (remover instanceof Monster && !TownyAPI.getInstance().isWilderness(hanging.getLocation())) {
                event.setCancelled(true);
            }
            if (event.getCause() == HangingBreakEvent.RemoveCause.EXPLOSION) {
                if (!TownyActionEventExecutor.canExplosionDamageEntities(hanging.getLocation(), (Entity)event.getEntity(), EntityDamageEvent.DamageCause.ENTITY_EXPLOSION)) {
                    event.setCancelled(true);
                } else {
                    TownBlock tb = TownyAPI.getInstance().getTownBlock(hanging.getLocation());
                    if (tb == null && remover != null && townyWorld.isExpl() && townyWorld.isUsingPlotManagementWildEntityRevert() && townyWorld.isProtectingExplosionEntity(remover)) {
                        event.setCancelled(true);
                    }
                }
            }
        } else {
            switch (event.getCause()) {
                case EXPLOSION: {
                    if (TownyActionEventExecutor.canExplosionDamageEntities(event.getEntity().getLocation(), (Entity)event.getEntity(), EntityDamageEvent.DamageCause.BLOCK_EXPLOSION)) break;
                    event.setCancelled(true);
                    break;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onHangingPlace(HangingPlaceEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getEntity().getLocation(), Material.PAINTING));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPigHitByLightning(PigZapEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld())) {
            return;
        }
        if (TownyActionEventExecutor.canExplosionDamageEntities(event.getEntity().getLocation(), (Entity)event.getEntity(), EntityDamageEvent.DamageCause.LIGHTNING)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHitEventButtonOrPlate(ProjectileHitEvent event) {
        if (this.plugin.isError() || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld()) || event.getHitBlock() == null || !(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        Block block = event.getHitBlock().getRelative(event.getHitBlockFace());
        Material material = block.getType();
        if (ItemLists.PROJECTILE_TRIGGERED_REDSTONE.contains(material.name()) && TownySettings.isSwitchMaterial(material.name()) && !TownyActionEventExecutor.canSwitch((Player)event.getEntity().getShooter(), block.getLocation(), material)) {
            BlockData data = block.getBlockData();
            block.setType(Material.AIR);
            BukkitTools.getScheduler().runTask((Plugin)this.plugin, () -> block.setBlockData(data));
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onProjectileHitEventTarget(ProjectileHitEvent event) {
        if (this.plugin.isError() || !Towny.is116Plus() || !TownyAPI.getInstance().isTownyWorld(event.getEntity().getWorld()) || event.getHitBlock() == null || !(event.getEntity().getShooter() instanceof Player)) {
            return;
        }
        if (event.getHitBlock().getType() == Material.TARGET && TownySettings.isSwitchMaterial(Material.TARGET.name()) && !TownyActionEventExecutor.canSwitch((Player)event.getEntity().getShooter(), event.getHitBlock().getLocation(), Material.TARGET)) {
            BlockData data = event.getHitBlock().getBlockData();
            event.getHitBlock().setType(Material.AIR);
            BukkitTools.getScheduler().runTask((Plugin)this.plugin, () -> event.getHitBlock().setBlockData(data));
        }
    }
}

