/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.BedExplodeEvent;
import com.palmergames.bukkit.towny.event.PlayerChangePlotEvent;
import com.palmergames.bukkit.towny.event.PlayerEnterTownEvent;
import com.palmergames.bukkit.towny.event.PlayerLeaveTownEvent;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.OnPlayerLogin;
import com.palmergames.bukkit.towny.tasks.TeleportWarmupTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.ChatTools;
import com.palmergames.bukkit.util.ItemLists;
import com.palmergames.paperlib.PaperLib;
import com.palmergames.util.StringMgmt;
import com.palmergames.util.TimeMgmt;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.type.Bed;
import org.bukkit.block.data.type.Door;
import org.bukkit.block.data.type.RespawnAnchor;
import org.bukkit.block.data.type.Sign;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerArmorStandManipulateEvent;
import org.bukkit.event.player.PlayerBucketEmptyEvent;
import org.bukkit.event.player.PlayerBucketFillEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTakeLecternBookEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TownyPlayerListener
implements Listener {
    private final Towny plugin;

    public TownyPlayerListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.isError()) {
            player.sendMessage("\u00a7c[Towny Error] Locked in Safe mode!");
            return;
        }
        if (!player.isOnline()) {
            return;
        }
        if (player.getName().contains(" ")) {
            player.kickPlayer("Invalid name!");
            return;
        }
        if (BukkitTools.scheduleSyncDelayedTask(new OnPlayerLogin(Towny.getPlugin(), player), 0L) == -1) {
            TownyMessaging.sendErrorMsg("Could not schedule OnLogin.");
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerQuit(PlayerQuitEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident != null) {
            resident.setLastOnline(System.currentTimeMillis());
            resident.clearModes();
            resident.save();
            if (TownyTimerHandler.isTeleportWarmupRunning()) {
                TownyAPI.getInstance().abortTeleportRequest(resident);
            }
        }
        this.plugin.deleteCache(event.getPlayer());
        TownyPerms.removeAttachment(event.getPlayer().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Player player = event.getPlayer();
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        if (Towny.is116Plus() && event.isAnchorSpawn() && TownySettings.isRespawnAnchorHigherPrecedence()) {
            return;
        }
        Location respawn = TownyAPI.getInstance().getTownSpawnLocation(player);
        if (respawn == null) {
            return;
        }
        if (TownySettings.isTownRespawningInOtherWorlds() && !player.getWorld().equals(respawn.getWorld())) {
            return;
        }
        if (TownySettings.getBedUse() && player.getBedSpawnLocation() != null) {
            event.setRespawnLocation(player.getBedSpawnLocation());
        } else {
            event.setRespawnLocation(respawn);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerJailRespawn(PlayerRespawnEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (!TownySettings.isTownRespawning()) {
            return;
        }
        try {
            Town respawnTown;
            Location respawn = null;
            Resident resident = townyUniverse.getResident(event.getPlayer().getUniqueId());
            if (resident != null && resident.isJailed() && (respawnTown = townyUniverse.getTown(resident.getJailTown())) != null) {
                respawn = respawnTown.getJailSpawn(resident.getJailSpawn());
                event.setRespawnLocation(respawn);
            }
        }
        catch (TownyException townyException) {
            // empty catch block
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketEmpty(PlayerBucketEmptyEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canBuild(event.getPlayer(), event.getBlockClicked().getRelative(event.getBlockFace()).getLocation(), event.getBucket()));
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerBucketFill(PlayerBucketFillEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getBlockClicked().getLocation(), event.getBlockClicked().getType()));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Player player = event.getPlayer();
        Block clickedBlock = event.getClickedBlock();
        if (event.hasItem()) {
            Material item = event.getItem().getType();
            Location loc = null;
            loc = clickedBlock != null ? clickedBlock.getLocation() : player.getLocation();
            if (TownySettings.isItemUseMaterial(item.name())) {
                event.setCancelled(!TownyActionEventExecutor.canItemuse(player, loc, item));
            }
            if (clickedBlock != null) {
                Material clickedMat = clickedBlock.getType();
                if (ItemLists.AXES.contains(item.name()) && Tag.LOGS.isTagged((Keyed)clickedMat) || ItemLists.DYES.contains(item.name()) && Tag.SIGNS.isTagged((Keyed)clickedMat) || item == Material.FLINT_AND_STEEL && clickedMat == Material.TNT || (item == Material.GLASS_BOTTLE || item == Material.SHEARS) && (clickedMat == Material.BEE_NEST || clickedMat == Material.BEEHIVE || clickedMat == Material.PUMPKIN)) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, loc, clickedMat));
                }
                if (item == Material.BONE_MEAL) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, loc, item));
                }
                if (item == Material.ARMOR_STAND || item == Material.END_CRYSTAL) {
                    event.setCancelled(!TownyActionEventExecutor.canBuild(player, clickedBlock.getRelative(event.getBlockFace()).getLocation(), item));
                }
            }
        }
        if (clickedBlock != null) {
            Material clickedMat = clickedBlock.getType();
            if (TownySettings.isSwitchMaterial(clickedMat.name()) || event.getAction() == Action.PHYSICAL) {
                event.setCancelled(!TownyActionEventExecutor.canSwitch(player, clickedBlock.getLocation(), clickedMat));
                return;
            }
            if (ItemLists.POTTED_PLANTS.contains(clickedMat.name()) || ItemLists.REDSTONE_INTERACTABLES.contains(clickedMat.name()) || clickedMat == Material.BEACON || clickedMat == Material.DRAGON_EGG || clickedMat == Material.COMMAND_BLOCK || clickedMat == Material.SWEET_BERRY_BUSH) {
                event.setCancelled(!TownyActionEventExecutor.canDestroy(player, clickedBlock.getLocation(), clickedMat));
                return;
            }
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerBlowsUpBedOrRespawnAnchor(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        Block block = event.getClickedBlock();
        if (event.hasBlock()) {
            if (block.getType().name().equals("RESPAWN_ANCHOR")) {
                RespawnAnchor anchor = (RespawnAnchor)block.getBlockData();
                if (anchor.getCharges() == 4) {
                    BukkitTools.getPluginManager().callEvent((Event)new BedExplodeEvent(event.getPlayer(), block.getLocation(), null, block.getType()));
                }
                return;
            }
            if (Tag.BEDS.isTagged((Keyed)block.getType()) && event.getPlayer().getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                Bed bed = (Bed)block.getBlockData();
                BukkitTools.getPluginManager().callEvent((Event)new BedExplodeEvent(event.getPlayer(), block.getLocation(), block.getRelative(bed.getFacing()).getLocation(), block.getType()));
                return;
            }
            if (Tag.BEDS.isTagged((Keyed)block.getType()) && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (!TownySettings.getBedUse()) {
                    return;
                }
                boolean isOwner = false;
                boolean isInnPlot = false;
                if (!TownyAPI.getInstance().isWilderness(block.getLocation())) {
                    TownBlock townblock = TownyAPI.getInstance().getTownBlock(block.getLocation());
                    Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
                    Town town = null;
                    try {
                        town = townblock.getTown();
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                    if (resident == null || town == null) {
                        return;
                    }
                    isOwner = townblock.isOwner(resident);
                    boolean bl = isInnPlot = townblock.getType() == TownBlockType.INN;
                    if (CombatUtil.isEnemyTownBlock(event.getPlayer(), townblock.getWorldCoord()) || town.hasOutlaw(resident)) {
                        event.setCancelled(true);
                        TownyMessaging.sendErrorMsg((Object)event.getPlayer(), Translation.of("msg_err_no_sleep_in_enemy_inn"));
                        return;
                    }
                }
                if (!isOwner && !isInnPlot) {
                    event.setCancelled(true);
                    TownyMessaging.sendErrorMsg((Object)event.getPlayer(), Translation.of("msg_err_cant_use_bed"));
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractWithArmourStand(PlayerArmorStandManipulateEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getRightClicked().getLocation(), Material.ARMOR_STAND));
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getRightClicked() != null) {
            Player player = event.getPlayer();
            Material mat = null;
            TownyPermission.ActionType actionType = TownyPermission.ActionType.DESTROY;
            switch (event.getRightClicked().getType()) {
                case ITEM_FRAME: 
                case PAINTING: 
                case LEASH_HITCH: 
                case MINECART_COMMAND: 
                case MINECART_TNT: 
                case MINECART_MOB_SPAWNER: {
                    mat = EntityTypeUtil.parseEntityToMaterial(event.getRightClicked().getType());
                    break;
                }
                case SHEEP: 
                case WOLF: {
                    Material dye;
                    if (event.getPlayer().getInventory().getItem(event.getHand()) != null && ItemLists.DYES.contains((dye = event.getPlayer().getInventory().getItem(event.getHand()).getType()).name())) {
                        mat = dye;
                        break;
                    }
                }
                case MINECART_CHEST: 
                case MINECART_FURNACE: 
                case MINECART_HOPPER: {
                    mat = EntityTypeUtil.parseEntityToMaterial(event.getRightClicked().getType());
                    actionType = TownyPermission.ActionType.SWITCH;
                    break;
                }
            }
            if (mat != null) {
                if (actionType == TownyPermission.ActionType.DESTROY) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), mat));
                    return;
                }
                if (TownySettings.isSwitchMaterial(mat.name()) && actionType == TownyPermission.ActionType.SWITCH) {
                    event.setCancelled(!TownyActionEventExecutor.canSwitch(player, event.getRightClicked().getLocation(), mat));
                    return;
                }
            }
            if (event.getPlayer().getInventory().getItem(event.getHand()) != null) {
                Material item = event.getPlayer().getInventory().getItem(event.getHand()).getType();
                if (event.getRightClicked().getType().equals((Object)EntityType.SHEEP) && item == Material.SHEARS) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), item));
                    return;
                }
                if (item == Material.NAME_TAG) {
                    event.setCancelled(!TownyActionEventExecutor.canDestroy(player, event.getRightClicked().getLocation(), item));
                    return;
                }
                if (TownySettings.isItemUseMaterial(item.name())) {
                    event.setCancelled(!TownyActionEventExecutor.canItemuse(player, event.getRightClicked().getLocation(), item));
                    return;
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerMove(PlayerMoveEvent event) {
        Location from;
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (event.getFrom().getBlockX() == event.getTo().getBlockX() && event.getFrom().getBlockZ() == event.getTo().getBlockZ() && event.getFrom().getBlockY() == event.getTo().getBlockY()) {
            return;
        }
        Player player = event.getPlayer();
        Location to = event.getTo();
        PlayerCache cache = this.plugin.getCache(player);
        Resident resident = townyUniverse.getResident(player.getUniqueId());
        if (resident != null && TownyTimerHandler.isTeleportWarmupRunning() && TownySettings.getTeleportWarmupTime() > 0 && TownySettings.isMovementCancellingSpawnWarmup() && !townyUniverse.getPermissionSource().isTownyAdmin(player) && resident.getTeleportRequestTime() > 0L) {
            TeleportWarmupTimerTask.abortTeleportRequest(resident);
            TownyMessaging.sendMsg(resident, ChatColor.RED + Translation.of("msg_err_teleport_cancelled"));
        }
        try {
            from = cache.getLastLocation();
        }
        catch (NullPointerException e) {
            from = event.getFrom();
        }
        if (WorldCoord.cellChanged(from, to)) {
            try {
                TownyWorld fromWorld = townyUniverse.getDataSource().getWorld(from.getWorld().getName());
                WorldCoord fromCoord = new WorldCoord(fromWorld.getName(), Coord.parseCoord(from));
                TownyWorld toWorld = townyUniverse.getDataSource().getWorld(to.getWorld().getName());
                WorldCoord toCoord = new WorldCoord(toWorld.getName(), Coord.parseCoord(to));
                this.onPlayerMoveChunk(player, fromCoord, toCoord, from, to, event);
            }
            catch (NotRegisteredException e) {
                TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
            }
        }
        cache.setLastLocation(to);
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerTeleport(PlayerTeleportEvent event) {
        if (this.plugin.isError()) {
            if (this.plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)event.getPlayer())) {
                return;
            }
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident != null && resident.isJailed()) {
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.COMMAND) {
                TownyMessaging.sendErrorMsg((Object)event.getPlayer(), Translation.of("msg_err_jailed_players_no_teleport"));
                event.setCancelled(true);
                return;
            }
            if (event.getCause() == PlayerTeleportEvent.TeleportCause.PLUGIN) {
                return;
            }
            if (event.getCause() != PlayerTeleportEvent.TeleportCause.ENDER_PEARL || !TownySettings.JailAllowsEnderPearls()) {
                TownyMessaging.sendErrorMsg((Object)event.getPlayer(), Translation.of("msg_err_jailed_players_no_teleport"));
                event.setCancelled(true);
            }
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.CHORUS_FRUIT && TownySettings.isItemUseMaterial(Material.CHORUS_FRUIT.name()) && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getTo(), Material.CHORUS_FRUIT)) {
            event.setCancelled(true);
            return;
        }
        if (event.getCause() == PlayerTeleportEvent.TeleportCause.ENDER_PEARL && TownySettings.isItemUseMaterial(Material.ENDER_PEARL.name()) && !TownyActionEventExecutor.canItemuse(event.getPlayer(), event.getTo(), Material.ENDER_PEARL)) {
            event.setCancelled(true);
            return;
        }
        this.onPlayerMove((PlayerMoveEvent)event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerChangeWorld(PlayerChangedWorldEvent event) {
        if (event.getPlayer().isOnline()) {
            TownyPerms.assignPermissions(null, event.getPlayer());
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerFishEvent(PlayerFishEvent event) {
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getState().equals((Object)PlayerFishEvent.State.CAUGHT_ENTITY)) {
            Player player = event.getPlayer();
            Entity caught = event.getCaught();
            boolean test = false;
            if (caught.getType().equals((Object)EntityType.PLAYER)) {
                TownyWorld world = null;
                try {
                    world = TownyUniverse.getInstance().getDataSource().getWorld(event.getCaught().getWorld().getName());
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                assert (world != null);
                TownBlock tb = TownyAPI.getInstance().getTownBlock(event.getCaught().getLocation());
                test = !CombatUtil.preventPvP(world, tb);
            } else {
                test = TownyActionEventExecutor.canDestroy(player, caught.getLocation(), Material.GRASS);
            }
            if (!test) {
                event.setCancelled(true);
                event.getHook().remove();
            }
        }
    }

    public void onPlayerMoveChunk(Player player, WorldCoord from, WorldCoord to, Location fromLoc, Location toLoc, PlayerMoveEvent moveEvent) {
        this.plugin.getCache(player).setLastLocation(toLoc);
        this.plugin.getCache(player).updateCoord(to);
        PlayerChangePlotEvent event = new PlayerChangePlotEvent(player, from, to, moveEvent);
        Bukkit.getServer().getPluginManager().callEvent((Event)event);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerChangePlotEvent(PlayerChangePlotEvent event) {
        block10: {
            PlayerMoveEvent pme = event.getMoveEvent();
            Player player = event.getPlayer();
            WorldCoord from = event.getFrom();
            WorldCoord to = event.getTo();
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident == null) {
                return;
            }
            try {
                try {
                    to.getTownBlock();
                    if (to.getTownBlock().hasTown()) {
                        try {
                            Town fromTown = from.getTownBlock().getTown();
                            if (!to.getTownBlock().getTown().equals(fromTown)) {
                                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEnterTownEvent(player, to, from, to.getTownBlock().getTown(), pme));
                                Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveTownEvent(player, to, from, from.getTownBlock().getTown(), pme));
                            }
                            break block10;
                        }
                        catch (NotRegisteredException e) {
                            Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerEnterTownEvent(player, to, from, to.getTownBlock().getTown(), pme));
                        }
                        break block10;
                    }
                    if (from.getTownBlock().hasTown() && !to.getTownBlock().hasTown()) {
                        Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveTownEvent(player, to, from, from.getTownBlock().getTown(), pme));
                    }
                }
                catch (NotRegisteredException e) {
                    Bukkit.getServer().getPluginManager().callEvent((Event)new PlayerLeaveTownEvent(player, to, from, from.getTownBlock().getTown(), pme));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onOutlawEnterTown(PlayerEnterTownEvent event) {
        final Resident outlaw = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (outlaw == null) {
            return;
        }
        final Town town = event.getEnteredtown();
        if (town.hasOutlaw(outlaw)) {
            if (TownySettings.doTownsGetWarnedOnOutlaw() && !TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(event.getPlayer())) {
                TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_outlaw_town_notify", outlaw.getFormattedName()));
            }
            if (TownySettings.canOutlawsEnterTowns() || TownyUniverse.getInstance().getPermissionSource().testPermission(outlaw.getPlayer(), PermissionNodes.TOWNY_ADMIN_OUTLAW_TELEPORT_BYPASS.getNode())) {
                TownyMessaging.sendMsg(outlaw, Translation.of("msg_you_are_an_outlaw_in_this_town", town));
            } else {
                if (TownySettings.getOutlawTeleportWarmup() > 0) {
                    TownyMessaging.sendMsg(outlaw, Translation.of("msg_outlaw_kick_cooldown", town, TimeMgmt.formatCountdownTime(TownySettings.getOutlawTeleportWarmup())));
                }
                new BukkitRunnable(){

                    public void run() {
                        if (TownyAPI.getInstance().getTown(outlaw.getPlayer().getLocation()) != null && TownyAPI.getInstance().getTown(outlaw.getPlayer().getLocation()) == town && town.hasOutlaw(outlaw.getPlayer().getName())) {
                            Location spawnLocation = town.getWorld().getSpawnLocation();
                            Player outlawedPlayer = outlaw.getPlayer();
                            if (!TownySettings.getOutlawTeleportWorld().equals("")) {
                                spawnLocation = Objects.requireNonNull(Bukkit.getWorld((String)TownySettings.getOutlawTeleportWorld())).getSpawnLocation();
                            }
                            if (outlawedPlayer.getBedSpawnLocation() != null && TownyAPI.getInstance().getTown(outlawedPlayer.getBedSpawnLocation()) != town) {
                                spawnLocation = outlawedPlayer.getBedSpawnLocation();
                            }
                            if (outlaw.hasTown() && TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer) != null) {
                                spawnLocation = TownyAPI.getInstance().getTownSpawnLocation(outlawedPlayer);
                            }
                            TownyMessaging.sendMsg(outlaw, Translation.of("msg_outlaw_kicked", town));
                            PaperLib.teleportAsync((Entity)outlaw.getPlayer(), spawnLocation, PlayerTeleportEvent.TeleportCause.PLUGIN);
                        }
                    }
                }.runTaskLater((Plugin)this.plugin, (long)(TownySettings.getOutlawTeleportWarmup() * 20));
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerDieInTown(PlayerDeathEvent event) {
        boolean keepInventory = event.getKeepInventory();
        boolean keepLevel = event.getKeepLevel();
        Player player = event.getEntity();
        Location deathloc = player.getLocation();
        TownBlock tb = TownyAPI.getInstance().getTownBlock(deathloc);
        if (tb != null && tb.hasTown()) {
            Resident resident;
            if (TownySettings.getKeepExperienceInTowns() && !keepLevel) {
                event.setKeepLevel(true);
                event.setDroppedExp(0);
            }
            if (TownySettings.getKeepInventoryInTowns() && !keepInventory) {
                event.setKeepInventory(true);
                event.getDrops().clear();
                keepInventory = true;
            }
            if ((resident = TownyUniverse.getInstance().getResident(player.getUniqueId())) != null && resident.hasTown() && !keepInventory) {
                Town town = null;
                Town tbTown = null;
                try {
                    town = resident.getTown();
                    tbTown = tb.getTown();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (TownySettings.getKeepInventoryInOwnTown() && tbTown.equals(town)) {
                    event.setKeepInventory(true);
                    event.getDrops().clear();
                    keepInventory = true;
                }
                if (TownySettings.getKeepInventoryInAlliedTowns() && !keepInventory && tbTown.isAlliedWith(town)) {
                    event.setKeepInventory(true);
                    event.getDrops().clear();
                    keepInventory = true;
                }
            }
            if (TownySettings.getKeepInventoryInArenas() && !keepInventory && tb.getType() == TownBlockType.ARENA) {
                event.setKeepInventory(true);
                event.getDrops().clear();
            }
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerEnterTown(PlayerEnterTownEvent event) {
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        Town town = event.getEnteredtown();
        if (resident != null && town != null && TownySettings.isNotificationUsingTitles()) {
            String title = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesTownTitle());
            String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesTownSubtitle());
            HashMap<String, Object> placeholders = new HashMap<String, Object>();
            placeholders.put("{townname}", StringMgmt.remUnderscore(town.getName()));
            placeholders.put("{town_motd}", town.getBoard());
            placeholders.put("{town_residents}", town.getNumResidents());
            placeholders.put("{town_residents_online}", TownyAPI.getInstance().getOnlinePlayers(town).size());
            for (Map.Entry placeholder : placeholders.entrySet()) {
                title = title.replace((CharSequence)placeholder.getKey(), placeholder.getValue().toString());
                subtitle = subtitle.replace((CharSequence)placeholder.getKey(), placeholder.getValue().toString());
            }
            TownyMessaging.sendTitleMessageToResident(resident, title, subtitle);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerLeaveTown(PlayerLeaveTownEvent event) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident resident = townyUniverse.getResident(event.getPlayer().getUniqueId());
        String worldName = null;
        try {
            worldName = townyUniverse.getDataSource().getWorld(event.getPlayer().getLocation().getWorld().getName()).getUnclaimedZoneName();
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (resident == null || worldName == null) {
            return;
        }
        WorldCoord to = event.getTo();
        if (TownySettings.isNotificationUsingTitles()) {
            try {
                Town town = to.getTownBlock().getTown();
            }
            catch (NotRegisteredException e) {
                String title = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesWildTitle());
                String subtitle = ChatColor.translateAlternateColorCodes((char)'&', (String)TownySettings.getNotificationTitlesWildSubtitle());
                if (title.contains("{wilderness}")) {
                    title = title.replace("{wilderness}", StringMgmt.remUnderscore(worldName));
                }
                if (subtitle.contains("{wilderness}")) {
                    subtitle = subtitle.replace("{wilderness}", StringMgmt.remUnderscore(worldName));
                }
                TownyMessaging.sendTitleMessageToResident(resident, title, subtitle);
            }
        }
        if (resident.isJailed()) {
            resident.freeFromJail(resident.getJailSpawn(), true);
            resident.save();
        }
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onPlayerTakeLecternBookEvent(PlayerTakeLecternBookEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getLectern().getWorld())) {
            return;
        }
        event.setCancelled(!TownyActionEventExecutor.canDestroy(event.getPlayer(), event.getLectern().getLocation(), Material.LECTERN));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onJailedPlayerUsesCommand(PlayerCommandPreprocessEvent event) {
        if (this.plugin.isError()) {
            return;
        }
        Resident resident = TownyUniverse.getInstance().getResident(event.getPlayer().getUniqueId());
        if (resident == null || !resident.isJailed()) {
            return;
        }
        String[] split = event.getMessage().substring(1).split(" ");
        if (TownySettings.getJailBlacklistedCommands().contains(split[0])) {
            TownyMessaging.sendErrorMsg((Object)event.getPlayer(), Translation.of("msg_you_cannot_use_that_command_while_jailed"));
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAdminToolUseOnBlocks(PlayerInteractEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.hasItem() && event.getPlayer().getInventory().getItemInMainHand().getType() == Material.getMaterial((String)TownySettings.getTool()) && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(event.getPlayer()) && event.getClickedBlock() != null) {
            Player player = event.getPlayer();
            Block block = event.getClickedBlock();
            if (Tag.SIGNS.isTagged((Keyed)block.getType())) {
                Sign sign;
                BlockFace facing = null;
                if (block.getBlockData() instanceof Sign) {
                    sign = (Sign)block.getBlockData();
                    facing = sign.getRotation();
                }
                if (block.getBlockData() instanceof WallSign) {
                    sign = (WallSign)block.getBlockData();
                    facing = sign.getFacing();
                }
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Sign Info"), ChatTools.formatCommand("", "Sign Type", "", block.getType().name()), ChatTools.formatCommand("", "Facing", "", facing.toString())));
            } else if (Tag.DOORS.isTagged((Keyed)block.getType())) {
                Door door = (Door)block.getBlockData();
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Door Info"), ChatTools.formatCommand("", "Door Type", "", block.getType().name()), ChatTools.formatCommand("", "hinged on ", "", String.valueOf(door.getHinge())), ChatTools.formatCommand("", "isOpen", "", String.valueOf(door.isOpen())), ChatTools.formatCommand("", "getFacing", "", door.getFacing().name())));
            } else {
                TownyMessaging.sendMessage((Object)player, Arrays.asList(ChatTools.formatTitle("Block Info"), ChatTools.formatCommand("", "Material", "", block.getType().name()), ChatTools.formatCommand("", "MaterialData", "", block.getBlockData().getAsString())));
            }
            event.setUseInteractedBlock(Event.Result.DENY);
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.LOWEST, ignoreCancelled=true)
    public void onAdminToolUseOnEntities(PlayerInteractEntityEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getPlayer().getWorld())) {
            return;
        }
        if (event.getRightClicked() != null && event.getPlayer().getInventory().getItemInMainHand() != null && event.getPlayer().getInventory().getItemInMainHand().getType() == Material.getMaterial((String)TownySettings.getTool()) && TownyUniverse.getInstance().getPermissionSource().isTownyAdmin(event.getPlayer())) {
            if (event.getHand().equals((Object)EquipmentSlot.OFF_HAND)) {
                return;
            }
            Entity entity = event.getRightClicked();
            TownyMessaging.sendMessage((Object)event.getPlayer(), Arrays.asList(ChatTools.formatTitle("Entity Info"), ChatTools.formatCommand("", "Entity Class", "", entity.getType().getEntityClass().getSimpleName())));
            event.setCancelled(true);
        }
    }
}

