/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.listeners;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.weather.LightningStrikeEvent;
import org.bukkit.event.world.PortalCreateEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class TownyWorldListener
implements Listener {
    private final Towny plugin;
    public static List<String> playersMap = new ArrayList<String>();

    public TownyWorldListener(Towny instance) {
        this.plugin = instance;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldLoad(WorldLoadEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onWorldInit(WorldInitEvent event) {
        this.newWorld(event.getWorld().getName());
    }

    private void newWorld(String worldName) {
        boolean dungeonWorld = false;
        if (Bukkit.getServer().getPluginManager().getPlugin("DungeonsXL") != null && worldName.startsWith("DXL_")) {
            dungeonWorld = true;
        }
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        try {
            townyUniverse.getDataSource().newWorld(worldName);
            TownyWorld world = townyUniverse.getDataSource().getWorld(worldName);
            if (dungeonWorld) {
                world.setUsingTowny(false);
            }
            if (world == null) {
                TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            } else if (!dungeonWorld && !townyUniverse.getDataSource().loadWorld(world)) {
                world.save();
            }
        }
        catch (AlreadyRegisteredException world) {
        }
        catch (NotRegisteredException e) {
            TownyMessaging.sendErrorMsg("Could not create data for " + worldName);
            e.printStackTrace();
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onLightningStrike(LightningStrikeEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        TownyWorld townyWorld = null;
        try {
            townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(event.getLightning().getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        if (townyWorld != null && event.getCause().equals((Object)LightningStrikeEvent.Cause.TRIDENT)) {
            event.setCancelled(CombatUtil.preventPvP(townyWorld, TownyAPI.getInstance().getTownBlock(event.getLightning().getLocation())));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onStructureGrow(StructureGrowEvent event) {
        if (this.plugin.isError()) {
            event.setCancelled(true);
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        TownBlock townBlock = null;
        TownBlock otherTownBlock = null;
        Town town = null;
        Town otherTown = null;
        Resident resident = null;
        ArrayList<BlockState> removed = new ArrayList<BlockState>();
        Coord coord = Coord.parseCoord(event.getLocation());
        for (BlockState blockState : event.getBlocks()) {
            Location blockLocation = blockState.getLocation();
            Coord blockCoord = Coord.parseCoord(blockLocation);
            if (TownyAPI.getInstance().isWilderness(blockLocation) || coord.equals(blockCoord)) continue;
            townBlock = TownyAPI.getInstance().getTownBlock(blockLocation);
            if (townBlock.hasResident()) {
                try {
                    resident = townBlock.getResident();
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                otherTownBlock = TownyAPI.getInstance().getTownBlock(blockLocation);
                try {
                    if (otherTownBlock.hasResident() && otherTownBlock.getResident() != resident) {
                        removed.add(blockState);
                        continue;
                    }
                    if (!otherTownBlock.hasResident()) {
                        removed.add(blockState);
                        continue;
                    }
                    if (resident != otherTownBlock.getResident()) continue;
                }
                catch (NotRegisteredException notRegisteredException) {}
                continue;
            }
            try {
                town = townBlock.getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                otherTownBlock = TownyAPI.getInstance().getTownBlock(blockLocation);
                otherTown = otherTownBlock.getTown();
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            if (town != otherTown) {
                removed.add(blockState);
                continue;
            }
            if (otherTownBlock.hasResident()) {
                removed.add(blockState);
                continue;
            }
            if (town != otherTown) continue;
        }
        if (!removed.isEmpty()) {
            event.getBlocks().removeAll(removed);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onPortalCreate(PortalCreateEvent event) {
        if (event.getReason() != PortalCreateEvent.CreateReason.NETHER_PAIR) {
            return;
        }
        if (!TownyAPI.getInstance().isTownyWorld(event.getWorld())) {
            return;
        }
        if (!event.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        for (BlockState block : event.getBlocks()) {
            if (TownyActionEventExecutor.canBuild((Player)event.getEntity(), block.getLocation(), Material.NETHER_PORTAL)) continue;
            TownyMessaging.sendErrorMsg((Object)event.getEntity(), Translation.of("msg_err_you_are_not_allowed_to_create_the_other_side_of_this_portal"));
            event.setCancelled(true);
            break;
        }
    }
}

