/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.ObjectGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownyPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;

public class PlotGroup
extends ObjectGroup
implements TownBlockOwner,
Savable {
    private Resident resident = null;
    private List<TownBlock> townBlocks;
    private double price = -1.0;
    private Town town;
    private TownyPermission permissions;

    public PlotGroup(UUID id, String name, Town town) {
        super(id, name);
        this.town = town;
    }

    @Override
    public String toString() {
        return super.toString() + "," + this.getTown().toString() + "," + this.getPrice();
    }

    @Override
    public void setName(String name) {
        if (this.getName() == null) {
            super.setName(name);
        } else {
            String oldName = this.getName();
            super.setName(name);
            this.town.renamePlotGroup(oldName, this);
        }
    }

    public void setTown(Town town) {
        this.town = town;
        try {
            town.addPlotGroup(this);
        }
        catch (Exception e) {
            TownyMessaging.sendErrorMsg(e.getMessage());
        }
    }

    public Town getTown() {
        return this.town;
    }

    public String toModeString() {
        return "Group{" + this.toString() + "}";
    }

    public double getPrice() {
        return this.price;
    }

    public void setResident(Resident resident) {
        if (this.hasResident()) {
            this.resident = resident;
        }
    }

    public Resident getResident() throws NotRegisteredException {
        if (!this.hasResident()) {
            throw new NotRegisteredException("The Group " + this.toString() + "is not registered to a resident.");
        }
        return this.resident;
    }

    public boolean hasResident() {
        return this.resident != null;
    }

    @Override
    public void addTownBlock(TownBlock townBlock) {
        if (this.townBlocks == null) {
            this.townBlocks = new ArrayList<TownBlock>();
        }
        this.townBlocks.add(townBlock);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        if (this.townBlocks != null) {
            this.townBlocks.remove(townBlock);
        }
    }

    public void setTownblocks(List<TownBlock> townBlocks) {
        this.townBlocks = townBlocks;
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks);
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.townBlocks.contains(townBlock);
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public void addPlotPrice(double pPrice) {
        if (this.getPrice() == -1.0) {
            this.price = pPrice;
            return;
        }
        this.price += pPrice;
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public void setPermissions(TownyPermission permissions) {
        this.permissions = permissions;
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().savePlotGroup(this);
    }
}

