/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.BaseCommand;
import com.palmergames.bukkit.towny.confirmations.Confirmation;
import com.palmergames.bukkit.towny.event.TownAddResidentEvent;
import com.palmergames.bukkit.towny.event.TownAddResidentRankEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentEvent;
import com.palmergames.bukkit.towny.event.TownRemoveResidentRankEvent;
import com.palmergames.bukkit.towny.event.resident.ResidentJailEvent;
import com.palmergames.bukkit.towny.event.resident.ResidentUnjailEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.invites.Invite;
import com.palmergames.bukkit.towny.invites.InviteHandler;
import com.palmergames.bukkit.towny.invites.InviteReceiver;
import com.palmergames.bukkit.towny.invites.exceptions.TooManyInvitesException;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Identifiable;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class Resident
extends TownyObject
implements InviteReceiver,
EconomyHandler,
TownBlockOwner,
Identifiable {
    private List<Resident> friends = new ArrayList<Resident>();
    private UUID uuid = null;
    private Town town = null;
    private long lastOnline;
    private long registered;
    private boolean isNPC = false;
    private boolean isJailed = false;
    private int jailSpawn;
    private int jailDays;
    private String jailTown = "";
    private String title = "";
    private String surname = "";
    private long teleportRequestTime = -1L;
    private Location teleportDestination;
    private double teleportCost = 0.0;
    private final List<String> modes = new ArrayList<String>();
    private transient Confirmation confirmation;
    private final transient List<Invite> receivedInvites = new ArrayList<Invite>();
    private transient EconomyAccount account = new EconomyAccount(this.getName());
    private final List<String> townRanks = new ArrayList<String>();
    private final List<String> nationRanks = new ArrayList<String>();
    private List<TownBlock> townBlocks = new ArrayList<TownBlock>();
    private final TownyPermission permissions = new TownyPermission();
    private TownyInventory guiInventory;

    public Resident(String name) {
        super(name);
        this.permissions.loadDefault(this);
    }

    public void setLastOnline(long lastOnline) {
        this.lastOnline = lastOnline;
    }

    public long getLastOnline() {
        return this.lastOnline;
    }

    public void setNPC(boolean isNPC) {
        this.isNPC = isNPC;
    }

    public boolean isNPC() {
        return this.isNPC;
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    public boolean hasUUID() {
        return this.uuid != null;
    }

    public void setJailed(boolean isJailed) {
        this.isJailed = isJailed;
        if (isJailed) {
            TownyUniverse.getInstance().getJailedResidentMap().add(this);
        } else {
            TownyUniverse.getInstance().getJailedResidentMap().remove(this);
        }
    }

    public void sendToJail(int index, Town town) {
        this.setJailed(true);
        this.setJailSpawn(index);
        this.setJailTown(town.getName());
        Bukkit.getPluginManager().callEvent((Event)new ResidentJailEvent(this));
        TownyMessaging.sendMsg(this, Translation.of("msg_you_have_been_sent_to_jail"));
        TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_player_has_been_sent_to_jail_number", this.getName(), index));
    }

    public void freeFromJail(int index, boolean escaped) {
        if (!escaped) {
            TownyMessaging.sendMsg(this, Translation.of("msg_you_have_been_freed_from_jail"));
            TownyMessaging.sendPrefixedTownMessage(this.town, Translation.of("msg_player_has_been_freed_from_jail_number", this.getName(), index));
        } else {
            try {
                if (this.hasTown()) {
                    TownyMessaging.sendPrefixedTownMessage(this.getTown(), Translation.of("msg_player_escaped_jail_into_wilderness", this.getName(), TownyUniverse.getInstance().getDataSource().getWorld(this.getPlayer().getLocation().getWorld().getName()).getUnclaimedZoneName()));
                } else {
                    TownyMessaging.sendMsg(this, Translation.of("msg_you_have_been_freed_from_jail"));
                }
                Town jailTown = TownyUniverse.getInstance().getTown(this.getJailTown());
                if (jailTown != null) {
                    TownyMessaging.sendPrefixedTownMessage(jailTown, Translation.of("msg_player_escaped_jail_into_wilderness", this.getName(), TownyUniverse.getInstance().getDataSource().getWorld(this.getPlayer().getLocation().getWorld().getName()).getUnclaimedZoneName()));
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.setJailed(false);
        this.removeJailSpawn();
        this.setJailTown(" ");
        Bukkit.getPluginManager().callEvent((Event)new ResidentUnjailEvent(this));
    }

    public void setJailedByMayor(int index, Town town, Integer days) {
        if (this.isJailed) {
            try {
                Location loc = this.getTown().getSpawn();
                TownyMessaging.sendMsg(this, Translation.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
                if (BukkitTools.isOnline(this.getName())) {
                    TownyAPI.getInstance().jailTeleport(this.getPlayer(), loc);
                }
                this.freeFromJail(index, false);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Location loc = town.getJailSpawn(index);
                TownyMessaging.sendMsg(this, Translation.of("msg_town_spawn_warmup", TownySettings.getTeleportWarmupTime()));
                TownyAPI.getInstance().jailTeleport(this.getPlayer(), loc);
                this.sendToJail(index, town);
                if (days > 0) {
                    if (days > 10000) {
                        days = 10000;
                    }
                    this.setJailDays(days);
                    TownyMessaging.sendMsg(this, Translation.of("msg_you've_been_jailed_for_x_days", days));
                }
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
        this.save();
    }

    public void setJailed(Integer index, Town town) {
        Player player = null;
        if (BukkitTools.isOnline(this.getName())) {
            player = this.getPlayer();
        }
        if (this.isJailed) {
            try {
                if (player != null) {
                    Location loc = this.hasTown() ? this.getTown().getSpawn() : player.getWorld().getSpawnLocation();
                    player.teleport(loc);
                }
                this.freeFromJail(index, false);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (player != null) {
                    Location loc = town.getJailSpawn(index);
                    player.teleport(loc);
                    this.sendToJail(index, town);
                }
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
        this.save();
    }

    public boolean isJailed() {
        return this.isJailed;
    }

    public boolean hasJailSpawn() {
        return this.jailSpawn > 0;
    }

    public int getJailSpawn() {
        return this.jailSpawn;
    }

    public void setJailSpawn(int index) {
        this.jailSpawn = index;
    }

    public void removeJailSpawn() {
        this.jailSpawn = 0;
    }

    public String getJailTown() {
        return this.jailTown;
    }

    public void setJailTown(String jailTown) {
        if (jailTown == null) {
            this.jailTown = "";
            return;
        }
        this.jailTown = jailTown.trim();
    }

    public boolean hasJailTown(String jailtown) {
        return this.jailTown.equalsIgnoreCase(jailtown);
    }

    public int getJailDays() {
        return this.jailDays;
    }

    public void setJailDays(Integer days) {
        this.jailDays = days;
    }

    public boolean hasJailDays() {
        return this.jailDays > 0;
    }

    public void setTitle(String title) {
        this.title = title.trim();
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasTitle() {
        return !this.title.isEmpty();
    }

    public void setSurname(String surname) {
        this.surname = surname.trim();
    }

    public String getSurname() {
        return this.surname;
    }

    public boolean hasSurname() {
        return !this.surname.isEmpty();
    }

    public boolean isKing() {
        try {
            return this.getTown().getNation().isKing(this);
        }
        catch (TownyException e) {
            return false;
        }
    }

    public boolean isMayor() {
        return this.hasTown() && this.town.isMayor(this);
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public boolean hasNation() {
        return this.hasTown() && this.town.hasNation();
    }

    public Town getTown() throws NotRegisteredException {
        if (this.hasTown()) {
            return this.town;
        }
        throw new NotRegisteredException(Translation.of("msg_err_resident_doesnt_belong_to_any_town"));
    }

    public void setTown(Town town) throws AlreadyRegisteredException {
        if (this.town == town) {
            return;
        }
        Towny.getPlugin().deleteCache(this.getName());
        this.setTitle("");
        this.setSurname("");
        if (town == null) {
            this.town = null;
            this.updatePerms();
            return;
        }
        if (this.hasTown()) {
            throw new AlreadyRegisteredException();
        }
        this.town = town;
        this.updatePerms();
        town.addResident(this);
        BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentEvent(this, town));
    }

    public void removeTown() {
        if (!this.hasTown()) {
            return;
        }
        Town town = this.town;
        BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentEvent(this, town));
        try {
            town.removeResident(this);
        }
        catch (NotRegisteredException e1) {
            e1.printStackTrace();
        }
        catch (EmptyTownException e1) {
            // empty catch block
        }
        Iterator<TownBlock> townBlockIterator = this.townBlocks.iterator();
        while (townBlockIterator.hasNext()) {
            TownBlock townBlock = townBlockIterator.next();
            if (townBlock.getType() == TownBlockType.EMBASSY) continue;
            townBlockIterator.remove();
            townBlock.setResident(null);
            try {
                townBlock.setPlotPrice(townBlock.getTown().getPlotPrice());
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
            townBlock.save();
            townBlock.setType(townBlock.getType());
        }
        try {
            this.setTown(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.save();
    }

    public void setFriends(List<Resident> newFriends) {
        this.friends = newFriends;
    }

    public List<Resident> getFriends() {
        return Collections.unmodifiableList(this.friends);
    }

    public void removeFriend(Resident resident) {
        if (this.hasFriend(resident)) {
            this.friends.remove(resident);
        }
    }

    public boolean hasFriend(Resident resident) {
        return this.friends.contains(resident);
    }

    public void addFriend(Resident resident) throws AlreadyRegisteredException {
        if (this.hasFriend(resident)) {
            throw new AlreadyRegisteredException();
        }
        this.friends.add(resident);
    }

    public void removeAllFriends() {
        this.friends.clear();
    }

    public void updatePerms() {
        this.townRanks.clear();
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void updatePermsForNationRemoval() {
        this.nationRanks.clear();
        TownyPerms.assignPermissions(this, null);
    }

    public void setRegistered(long registered) {
        this.registered = registered;
    }

    public long getRegistered() {
        return this.registered;
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Resident (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Registered: " + this.getRegistered());
        out.add(this.getTreeDepth(depth + 1) + "Last Online: " + this.getLastOnline());
        if (this.getFriends().size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Friends (" + this.getFriends().size() + "): " + Arrays.toString(this.getFriends().toArray(new Resident[0])));
        }
        return out;
    }

    public void clearTeleportRequest() {
        this.teleportRequestTime = -1L;
    }

    public void setTeleportRequestTime() {
        this.teleportRequestTime = System.currentTimeMillis();
    }

    public long getTeleportRequestTime() {
        return this.teleportRequestTime;
    }

    public void setTeleportDestination(Location spawnLoc) {
        this.teleportDestination = spawnLoc;
    }

    public Location getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean hasRequestedTeleport() {
        return this.teleportRequestTime != -1L;
    }

    public void setTeleportCost(double cost) {
        this.teleportCost = cost;
    }

    public double getTeleportCost() {
        return this.teleportCost;
    }

    public List<String> getModes() {
        return Collections.unmodifiableList(this.modes);
    }

    public boolean hasMode(String mode) {
        return this.modes.contains(mode.toLowerCase());
    }

    public void toggleMode(String[] newModes, boolean notify) {
        for (int i = 0; i < newModes.length; ++i) {
            boolean modeEnabled;
            String bool;
            String mode = newModes[i].toLowerCase();
            Optional<Boolean> choice = Optional.empty();
            if (i + 1 < newModes.length && BaseCommand.setOnOffCompletes.contains(bool = newModes[i + 1].toLowerCase())) {
                choice = Optional.of(bool.equals("on"));
                ++i;
            }
            if (choice.orElse(!(modeEnabled = this.modes.contains(mode))).booleanValue()) {
                if (modeEnabled) continue;
                this.modes.add(mode);
                continue;
            }
            this.modes.remove(mode);
        }
        if (this.modes.isEmpty()) {
            this.clearModes();
            return;
        }
        if (notify) {
            TownyMessaging.sendMsg(this, Translation.of("msg_modes_set") + StringMgmt.join(this.getModes(), ","));
        }
    }

    public void setModes(String[] modes, boolean notify) {
        this.modes.clear();
        this.toggleMode(modes, false);
        if (notify) {
            TownyMessaging.sendMsg(this, Translation.of("msg_modes_set") + StringMgmt.join(this.getModes(), ","));
        }
    }

    public void clearModes() {
        this.modes.clear();
        TownyMessaging.sendMsg(this, Translation.of("msg_modes_set"));
        if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.getName(), true), 1L) == -1) {
            TownyMessaging.sendErrorMsg(Translation.of("msg_err_could_not_set_default_modes_for") + this.getName() + ".");
        }
    }

    public void resetModes(String[] modes, boolean notify) {
        if (modes.length > 0) {
            this.toggleMode(modes, false);
        }
        if (notify) {
            TownyMessaging.sendMsg(this, Translation.of("msg_modes_set") + StringMgmt.join(this.getModes(), ","));
        }
    }

    public Player getPlayer() {
        return BukkitTools.getPlayer(this.getName());
    }

    public boolean addTownRank(String rank) throws AlreadyRegisteredException {
        if (this.hasTown()) {
            if (this.hasTownRank(rank)) {
                throw new AlreadyRegisteredException();
            }
            this.townRanks.add(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            BukkitTools.getPluginManager().callEvent((Event)new TownAddResidentRankEvent(this, rank, this.town));
            return true;
        }
        return false;
    }

    public void setTownRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchTownRank(rank)) == null || this.hasTownRank(rank)) continue;
            this.townRanks.add(rank);
        }
    }

    public boolean hasTownRank(String rank) {
        if ((rank = TownyPerms.matchTownRank(rank)) != null) {
            for (String ownedRank : this.townRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTownRanks() {
        return Collections.unmodifiableList(this.townRanks);
    }

    public boolean removeTownRank(String rank) throws NotRegisteredException {
        if (this.hasTownRank(rank)) {
            this.townRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            BukkitTools.getPluginManager().callEvent((Event)new TownRemoveResidentRankEvent(this, rank, this.town));
            return true;
        }
        throw new NotRegisteredException();
    }

    public boolean addNationRank(String rank) throws AlreadyRegisteredException {
        if (this.hasNation()) {
            if (this.hasNationRank(rank)) {
                throw new AlreadyRegisteredException();
            }
            this.nationRanks.add(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        return false;
    }

    public void setNationRanks(List<String> ranks) {
        for (String rank : ranks) {
            if ((rank = TownyPerms.matchNationRank(rank)) == null || this.hasNationRank(rank)) continue;
            this.nationRanks.add(rank);
        }
    }

    public boolean hasNationRank(String rank) {
        if ((rank = TownyPerms.matchNationRank(rank)) != null) {
            for (String ownedRank : this.nationRanks) {
                if (!ownedRank.equalsIgnoreCase(rank)) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getNationRanks() {
        return Collections.unmodifiableList(this.nationRanks);
    }

    public boolean removeNationRank(String rank) throws NotRegisteredException {
        if (this.hasNationRank(rank)) {
            this.nationRanks.remove(rank);
            if (BukkitTools.isOnline(this.getName())) {
                TownyPerms.assignPermissions(this, null);
            }
            return true;
        }
        throw new NotRegisteredException();
    }

    public boolean isAlliedWith(Resident otherresident) {
        if (this.hasNation() && this.hasTown() && otherresident.hasTown() && otherresident.hasNation()) {
            try {
                if (this.getTown().getNation().hasAlly(otherresident.getTown().getNation())) {
                    return true;
                }
                return this.getTown().getNation().equals(otherresident.getTown().getNation());
            }
            catch (NotRegisteredException e) {
                return false;
            }
        }
        return false;
    }

    public List<Invite> getReceivedInvites() {
        return Collections.unmodifiableList(this.receivedInvites);
    }

    @Override
    public void newReceivedInvite(Invite invite) throws TooManyInvitesException {
        if (this.receivedInvites.size() > InviteHandler.getReceivedInvitesMaxAmount(this) - 1) {
            throw new TooManyInvitesException(Translation.of("msg_err_player_has_too_many_invites", this.getName()));
        }
        this.receivedInvites.add(invite);
    }

    @Override
    public void deleteReceivedInvite(Invite invite) {
        this.receivedInvites.remove(invite);
    }

    @Override
    public void addMetaData(CustomDataField<?> md) {
        super.addMetaData(md);
        this.save();
    }

    @Override
    public void removeMetaData(CustomDataField<?> md) {
        super.removeMetaData(md);
        this.save();
    }

    @Override
    public Account getAccount() {
        if (this.account == null) {
            String accountName = StringMgmt.trimMaxLength(this.getName(), 32);
            Player player = this.getPlayer();
            World world = player != null ? player.getWorld() : BukkitTools.getWorlds().get(0);
            this.account = new EconomyAccount(accountName, world);
        }
        return this.account;
    }

    @Override
    public String getFormattedName() {
        if (this.isKing()) {
            return Colors.translateColorCodes(this.hasTitle() ? this.getTitle() + " " : TownySettings.getKingPrefix(this)) + this.getName() + (this.hasSurname() ? " " + this.getSurname() : TownySettings.getKingPostfix(this));
        }
        if (this.isMayor()) {
            return Colors.translateColorCodes(this.hasTitle() ? this.getTitle() + " " : TownySettings.getMayorPrefix(this)) + this.getName() + (this.hasSurname() ? " " + this.getSurname() : TownySettings.getMayorPostfix(this));
        }
        return Colors.translateColorCodes(this.hasTitle() ? this.getTitle() + " " : "") + this.getName() + (this.hasSurname() ? " " + this.getSurname() : "");
    }

    public String getNamePrefix() {
        if (this.isKing()) {
            return TownySettings.getKingPrefix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPrefix(this);
        }
        return "";
    }

    public String getNamePostfix() {
        if (this.isKing()) {
            return TownySettings.getKingPostfix(this);
        }
        if (this.isMayor()) {
            return TownySettings.getMayorPostfix(this);
        }
        return "";
    }

    public String getFormattedTitleName() {
        if (!this.hasTitle()) {
            return this.getFormattedName();
        }
        return this.getTitle() + " " + this.getName();
    }

    public void setTownblocks(Collection<TownBlock> townBlocks) {
        this.townBlocks = new ArrayList<TownBlock>(townBlocks);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks);
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.townBlocks.contains(townBlock);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.add(townBlock);
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) throws NotRegisteredException {
        if (!this.townBlocks.remove(townBlock)) {
            throw new NotRegisteredException();
        }
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    @Deprecated
    public World getBukkitWorld() {
        Player player = this.getPlayer();
        if (player != null) {
            return player.getWorld();
        }
        return BukkitTools.getWorlds().get(0);
    }

    public Confirmation getConfirmation() {
        return this.confirmation;
    }

    public void setConfirmation(Confirmation confirmation) {
        this.confirmation = confirmation;
    }

    public TownyInventory getGUIInventory() {
        return this.guiInventory;
    }

    public void setGUIInventory(TownyInventory inventory) {
        this.guiInventory = inventory;
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveResident(this);
    }
}

