/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.NationAddTownEvent;
import com.palmergames.bukkit.towny.event.NationRemoveTownEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.EmptyNationException;
import com.palmergames.bukkit.towny.exceptions.EmptyTownException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.EconomyAccount;
import com.palmergames.bukkit.towny.object.Government;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.StringMgmt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.event.Event;

public class Town
extends Government
implements TownBlockOwner {
    private static final String ECONOMY_ACCOUNT_PREFIX = TownySettings.getTownAccountPrefix();
    private final List<Resident> residents = new ArrayList<Resident>();
    private final List<Resident> outlaws = new ArrayList<Resident>();
    private List<Location> outpostSpawns = new ArrayList<Location>();
    private final List<Location> jailSpawns = new ArrayList<Location>();
    private HashMap<String, PlotGroup> plotGroups = null;
    private Resident mayor;
    private int bonusBlocks = 0;
    private int purchasedBlocks = 0;
    private double plotTax = TownySettings.getTownDefaultPlotTax();
    private double commercialPlotTax = TownySettings.getTownDefaultShopTax();
    private double plotPrice = 0.0;
    private double embassyPlotTax = TownySettings.getTownDefaultEmbassyTax();
    private double maxPercentTaxAmount = TownySettings.getMaxTownTaxPercentAmount();
    private double commercialPlotPrice;
    private double embassyPlotPrice;
    private double debtBalance = 0.0;
    private Nation nation;
    private boolean hasUpkeep = true;
    private boolean isTaxPercentage = TownySettings.getTownDefaultTaxPercentage();
    private TownBlock homeBlock;
    private TownyWorld world;
    private boolean adminDisabledPVP = false;
    private boolean adminEnabledPVP = false;
    private boolean isConquered = false;
    private int conqueredDays;
    private final ConcurrentHashMap<WorldCoord, TownBlock> townBlocks = new ConcurrentHashMap();
    private final TownyPermission permissions = new TownyPermission();
    private boolean ruined = false;
    private long ruinedTime;

    public Town(String name) {
        super(name);
        this.permissions.loadDefault(this);
        this.setTaxes(TownySettings.getTownDefaultTax());
        this.setOpen(TownySettings.getTownDefaultOpen());
        this.setBoard(TownySettings.getTownDefaultBoard());
        this.setNeutral(TownySettings.getTownDefaultNeutral());
    }

    public Town(String name, UUID uuid) {
        this(name);
        this.setUUID(uuid);
    }

    @Override
    public Collection<TownBlock> getTownBlocks() {
        return Collections.unmodifiableCollection(this.townBlocks.values());
    }

    @Override
    public boolean hasTownBlock(TownBlock townBlock) {
        return this.hasTownBlock(townBlock.getWorldCoord());
    }

    public boolean hasTownBlock(WorldCoord worldCoord) {
        return this.townBlocks.containsKey(worldCoord);
    }

    @Override
    public void addTownBlock(TownBlock townBlock) throws AlreadyRegisteredException {
        if (this.hasTownBlock(townBlock)) {
            throw new AlreadyRegisteredException();
        }
        this.townBlocks.put(townBlock.getWorldCoord(), townBlock);
        if (this.townBlocks.size() < 2 && !this.hasHomeBlock()) {
            try {
                this.setHomeBlock(townBlock);
            }
            catch (TownyException e) {
                e.printStackTrace();
            }
        }
    }

    public TownBlock getTownBlock(WorldCoord worldCoord) {
        if (this.hasTownBlock(worldCoord)) {
            return this.townBlocks.get(worldCoord);
        }
        return null;
    }

    public ConcurrentHashMap<WorldCoord, TownBlock> getTownBlockMap() {
        return this.townBlocks;
    }

    public Resident getMayor() {
        return this.mayor;
    }

    @Override
    public void setTaxes(double taxes) {
        this.taxes = Math.min(taxes, this.isTaxPercentage ? TownySettings.getMaxTownTaxPercent() : TownySettings.getMaxTownTax());
        if (this.taxes < 0.0) {
            this.taxes = TownySettings.getTownDefaultTax();
        }
    }

    public void forceSetMayor(Resident mayor) throws TownyException {
        if (!this.hasResident(mayor)) {
            throw new TownyException(Translation.of("msg_err_mayor_doesnt_belong_to_town"));
        }
        this.setMayor(mayor);
    }

    public void setMayor(Resident mayor) {
        if (!this.hasResident(mayor)) {
            return;
        }
        this.mayor = mayor;
        TownyPerms.assignPermissions(mayor, null);
    }

    public Nation getNation() throws NotRegisteredException {
        if (this.hasNation()) {
            return this.nation;
        }
        throw new NotRegisteredException(Translation.of("msg_err_town_doesnt_belong_to_any_nation"));
    }

    public void removeNation() {
        if (!this.hasNation()) {
            return;
        }
        Nation nation = this.nation;
        for (Resident res : this.getResidents()) {
            if (res.hasTitle() || res.hasSurname()) {
                res.setTitle("");
                res.setSurname("");
            }
            res.updatePermsForNationRemoval();
            res.save();
        }
        try {
            nation.removeTown(this);
        }
        catch (EmptyNationException e) {
            TownyUniverse.getInstance().getDataSource().removeNation(nation);
            TownyMessaging.sendGlobalMessage(Translation.of("msg_del_nation", e.getNation().getName()));
        }
        try {
            this.setNation(null);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
        this.isConquered = false;
        this.conqueredDays = 0;
        this.save();
        BukkitTools.getPluginManager().callEvent((Event)new NationRemoveTownEvent(this, nation));
    }

    public void setNation(Nation nation) throws AlreadyRegisteredException {
        if (this.nation == nation) {
            return;
        }
        if (nation == null) {
            this.nation = null;
            return;
        }
        if (this.hasNation()) {
            throw new AlreadyRegisteredException();
        }
        this.nation = nation;
        nation.addTown(this);
        TownyPerms.updateTownPerms(this);
        BukkitTools.getPluginManager().callEvent((Event)new NationAddTownEvent(this, nation));
    }

    public List<Resident> getResidents() {
        return Collections.unmodifiableList(this.residents);
    }

    @Deprecated
    public List<Resident> getAssistants() {
        return this.getRank("assistant");
    }

    public List<Resident> getRank(String rank) {
        ArrayList<Resident> residentsWithRank = new ArrayList<Resident>();
        for (Resident resident : this.residents) {
            if (!resident.hasTownRank(rank)) continue;
            residentsWithRank.add(resident);
        }
        return Collections.unmodifiableList(residentsWithRank);
    }

    @Override
    public boolean hasResident(String name) {
        for (Resident resident : this.residents) {
            if (!resident.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasResident(Resident resident) {
        return this.residents.contains(resident);
    }

    @Deprecated
    public boolean hasAssistant(Resident resident) {
        return resident.hasTownRank("assistant");
    }

    public boolean hasResidentWithRank(Resident resident, String rank) {
        return this.hasResident(resident) && resident.hasTownRank(rank);
    }

    void addResident(Resident resident) throws AlreadyRegisteredException {
        this.addResidentCheck(resident);
        this.residents.add(resident);
    }

    public void addResidentCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasResident(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), this.getFormattedName()));
        }
        if (resident.hasTown()) {
            try {
                if (!resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(Translation.of("msg_err_already_in_town", resident.getName(), resident.getTown().getFormattedName()));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isMayor(Resident resident) {
        return resident == this.mayor;
    }

    public boolean hasNation() {
        return this.nation != null;
    }

    public int getNumResidents() {
        return this.residents.size();
    }

    public boolean isCapital() {
        return this.hasNation() && this.nation.isCapital(this);
    }

    public void setHasUpkeep(boolean hasUpkeep) {
        this.hasUpkeep = hasUpkeep;
    }

    public boolean hasUpkeep() {
        return this.hasUpkeep;
    }

    public void setHasMobs(boolean hasMobs) {
        this.permissions.mobs = hasMobs;
    }

    public boolean hasMobs() {
        return this.permissions.mobs;
    }

    public void setPVP(boolean isPVP) {
        this.permissions.pvp = isPVP;
    }

    public void setAdminDisabledPVP(boolean isPVPDisabled) {
        this.adminDisabledPVP = isPVPDisabled;
    }

    public void setAdminEnabledPVP(boolean isPVPEnabled) {
        this.adminEnabledPVP = isPVPEnabled;
    }

    public boolean isPVP() {
        if (this.isAdminEnabledPVP()) {
            return true;
        }
        if (this.isAdminDisabledPVP()) {
            return false;
        }
        return this.permissions.pvp;
    }

    public boolean isAdminDisabledPVP() {
        return this.adminDisabledPVP;
    }

    public boolean isAdminEnabledPVP() {
        return this.adminEnabledPVP;
    }

    public void setBANG(boolean isBANG) {
        this.permissions.explosion = isBANG;
    }

    public boolean isBANG() {
        return this.permissions.explosion;
    }

    public void setTaxPercentage(boolean isPercentage) {
        this.isTaxPercentage = isPercentage;
        if (this.getTaxes() > 100.0) {
            this.setTaxes(0.0);
        }
    }

    public boolean isTaxPercentage() {
        return this.isTaxPercentage;
    }

    public void setFire(boolean isFire) {
        this.permissions.fire = isFire;
    }

    public boolean isFire() {
        return this.permissions.fire;
    }

    public void setBonusBlocks(int bonusBlocks) {
        this.bonusBlocks = bonusBlocks;
    }

    public int getTotalBlocks() {
        return TownySettings.getMaxTownBlocks(this);
    }

    public int getBonusBlocks() {
        return this.bonusBlocks;
    }

    public double getBonusBlockCost() {
        double price = Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), this.getPurchasedBlocks()) * TownySettings.getPurchasedBonusBlocksCost();
        double maxprice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        return maxprice == -1.0 ? price : Math.min(price, maxprice);
    }

    public double getTownBlockCost() {
        double price = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), this.getTownBlocks().size()) * TownySettings.getClaimPrice());
        double maxprice = TownySettings.getMaxClaimPrice();
        return maxprice == -1.0 ? price : Math.min(price, maxprice);
    }

    public double getTownBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        if (inputN == 0) {
            return inputN;
        }
        double nextprice = this.getTownBlockCost();
        double cost = nextprice;
        boolean hasmaxprice = TownySettings.getMaxClaimPrice() != -1.0;
        double maxprice = TownySettings.getMaxClaimPrice();
        for (int i = 1; i < inputN; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getClaimPriceIncreaseValue(), (double)this.getTownBlocks().size() + (double)i) * TownySettings.getClaimPrice());
            if (hasmaxprice && nextprice > maxprice) {
                cost += maxprice * (double)(inputN - i);
                break;
            }
            cost += nextprice;
        }
        cost = Math.round(cost);
        return cost;
    }

    public double getBonusBlockCostN(int inputN) throws TownyException {
        if (inputN < 0) {
            throw new TownyException(Translation.of("msg_err_negative"));
        }
        int current = this.getPurchasedBlocks();
        int n = current + inputN > TownySettings.getMaxPurchasedBlocks(this) ? TownySettings.getMaxPurchasedBlocks(this) - current : inputN;
        if (n == 0) {
            return n;
        }
        double nextprice = this.getBonusBlockCost();
        double cost = nextprice;
        boolean hasmaxprice = TownySettings.getPurchasedBonusBlocksMaxPrice() != -1.0;
        double maxprice = TownySettings.getPurchasedBonusBlocksMaxPrice();
        for (int i = 1; i < n; ++i) {
            nextprice = Math.round(Math.pow(TownySettings.getPurchasedBonusBlocksIncreaseValue(), (double)this.getPurchasedBlocks() + (double)i) * TownySettings.getPurchasedBonusBlocksCost());
            if (hasmaxprice && nextprice > maxprice) {
                cost += maxprice * (double)(inputN - i);
                break;
            }
            cost += nextprice;
        }
        cost = Math.round(cost);
        return cost;
    }

    public void addBonusBlocks(int bonusBlocks) {
        this.bonusBlocks += bonusBlocks;
    }

    public void setPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks = purchasedBlocks;
    }

    public int getPurchasedBlocks() {
        return this.purchasedBlocks;
    }

    public void addPurchasedBlocks(int purchasedBlocks) {
        this.purchasedBlocks += purchasedBlocks;
    }

    public boolean setHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            return false;
        }
        if (!this.hasTownBlock(homeBlock)) {
            throw new TownyException(Translation.of("msg_err_town_has_no_claim_over_this_town_block"));
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            if (this.world != null && this.world.hasTown(this)) {
                this.world.removeTown(this);
            }
            this.setWorld(homeBlock.getWorld());
        }
        try {
            this.setSpawn(this.spawn);
        }
        catch (TownyException e) {
            this.spawn = null;
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (this.hasNation() && TownySettings.getNationRequiresProximity() > 0.0 && !this.getNation().getCapital().equals(this)) {
            double distance;
            Nation nation = this.getNation();
            Coord capitalCoord = nation.getCapital().getHomeBlock().getCoord();
            Coord townCoord = this.getHomeBlock().getCoord();
            if (!nation.getCapital().getHomeBlock().getWorld().getName().equals(this.getHomeBlock().getWorld().getName())) {
                TownyMessaging.sendNationMessagePrefixed(nation, Translation.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
                this.removeNation();
            }
            if ((distance = Math.sqrt(Math.pow((double)capitalCoord.getX() - (double)townCoord.getX(), 2.0) + Math.pow((double)capitalCoord.getZ() - (double)townCoord.getZ(), 2.0))) > TownySettings.getNationRequiresProximity()) {
                TownyMessaging.sendNationMessagePrefixed(nation, Translation.of("msg_nation_town_moved_their_homeblock_too_far", this.getName()));
                this.removeNation();
            }
        }
        return true;
    }

    public void forceSetHomeBlock(TownBlock homeBlock) throws TownyException {
        if (homeBlock == null) {
            this.homeBlock = null;
            TownyMessaging.sendErrorMsg("town.forceSetHomeblock() is returning null.");
            return;
        }
        this.homeBlock = homeBlock;
        if (this.world != homeBlock.getWorld()) {
            if (this.world != null && this.world.hasTown(this)) {
                this.world.removeTown(this);
            }
            this.setWorld(homeBlock.getWorld());
        }
    }

    public TownBlock getHomeBlock() throws TownyException {
        if (this.hasHomeBlock()) {
            return this.homeBlock;
        }
        throw new TownyException(this.getName() + " has not set a home block.");
    }

    public void setWorld(TownyWorld world) {
        if (world == null) {
            this.world = null;
            return;
        }
        if (this.world == world) {
            return;
        }
        if (this.hasWorld()) {
            try {
                world.removeTown(this);
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        this.world = world;
        try {
            this.world.addTown(this);
        }
        catch (AlreadyRegisteredException alreadyRegisteredException) {
            // empty catch block
        }
    }

    public TownyWorld getHomeblockWorld() {
        if (this.world != null) {
            return this.world;
        }
        return TownyUniverse.getInstance().getDataSource().getTownWorld(this.getName());
    }

    public boolean hasMayor() {
        return this.mayor != null;
    }

    public void removeResident(Resident resident) throws EmptyTownException, NotRegisteredException {
        if (!this.hasResident(resident)) {
            throw new NotRegisteredException();
        }
        this.remove(resident);
        if (this.getNumResidents() == 0) {
            throw new EmptyTownException(this);
        }
    }

    private void remove(Resident resident) {
        if (this.isMayor(resident) && this.residents.size() > 1) {
            this.findNewMayor();
            this.save();
        }
        this.residents.remove(resident);
    }

    public void findNewMayor() {
        for (String rank : TownySettings.getOrderOfMayoralSuccession()) {
            if (!this.findNewMayor(rank)) continue;
            return;
        }
        this.findNewMayorCatchAll();
    }

    private boolean findNewMayor(String rank) {
        boolean found = false;
        for (Resident newMayor : this.getRank(rank)) {
            if (newMayor == this.mayor || !newMayor.hasTownRank(rank)) continue;
            this.setMayor(newMayor);
            found = true;
            break;
        }
        return found;
    }

    private boolean findNewMayorCatchAll() {
        boolean found = false;
        for (Resident newMayor : this.getResidents()) {
            if (newMayor == this.mayor) continue;
            this.setMayor(newMayor);
            found = true;
            break;
        }
        return found;
    }

    @Override
    public void setSpawn(Location spawn) throws TownyException {
        if (!this.hasHomeBlock()) {
            throw new TownyException(Translation.of("msg_err_homeblock_has_not_been_set"));
        }
        Coord spawnBlock = Coord.parseCoord(spawn);
        if (this.homeBlock.getX() != spawnBlock.getX() || this.homeBlock.getZ() != spawnBlock.getZ()) {
            throw new TownyException(Translation.of("msg_err_spawn_not_within_homeblock"));
        }
        this.spawn = spawn;
    }

    public void forceSetSpawn(Location spawn) {
        this.spawn = spawn;
    }

    @Override
    public Location getSpawn() throws TownyException {
        if (this.hasHomeBlock() && this.spawn != null) {
            return this.spawn;
        }
        this.spawn = null;
        throw new TownyException(Translation.of("msg_err_town_has_not_set_a_spawn_location"));
    }

    public boolean hasHomeBlock() {
        return this.homeBlock != null;
    }

    public boolean hasWorld() {
        return this.world != null;
    }

    @Override
    public void removeTownBlock(TownBlock townBlock) {
        if (this.hasTownBlock(townBlock)) {
            if (townBlock.isOutpost()) {
                this.removeOutpostSpawn(townBlock.getCoord());
            }
            if (townBlock.isJail()) {
                this.removeJailSpawn(townBlock.getCoord());
            }
            try {
                if (this.getHomeBlock() == townBlock) {
                    this.setHomeBlock(null);
                }
            }
            catch (TownyException townyException) {
                // empty catch block
            }
            this.townBlocks.remove(townBlock.getWorldCoord());
            this.save();
        }
    }

    @Override
    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    @Override
    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public void addOutpostSpawn(Location spawn) throws TownyException {
        this.removeOutpostSpawn(Coord.parseCoord(spawn));
        try {
            TownBlock outpost = TownyAPI.getInstance().getTownBlock(spawn);
            if (!outpost.isOutpost()) {
                throw new TownyException(Translation.of("msg_err_location_is_not_within_an_outpost_plot"));
            }
            this.outpostSpawns.add(spawn);
            this.save();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translation.of("msg_err_location_is_not_within_a_town"));
        }
    }

    public void forceAddOutpostSpawn(Location spawn) {
        this.outpostSpawns.add(spawn);
    }

    public Location getOutpostSpawn(Integer index) throws TownyException {
        if (this.getMaxOutpostSpawn() == 0 && TownySettings.isOutpostsLimitedByLevels()) {
            throw new TownyException(Translation.of("msg_err_town_has_no_outpost_spawns_set"));
        }
        return this.outpostSpawns.get(Math.min(this.getMaxOutpostSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxOutpostSpawn() {
        return this.outpostSpawns.size();
    }

    public boolean hasOutpostSpawn() {
        return this.outpostSpawns.size() > 0;
    }

    public List<Location> getAllOutpostSpawns() {
        return this.outpostSpawns;
    }

    public void removeOutpostSpawn(Coord coord) {
        for (Location spawn : new ArrayList<Location>(this.outpostSpawns)) {
            Coord spawnBlock = Coord.parseCoord(spawn);
            if (coord.getX() != spawnBlock.getX() || coord.getZ() != spawnBlock.getZ()) continue;
            this.outpostSpawns.remove(spawn);
            this.save();
        }
    }

    public void setPlotPrice(double plotPrice) {
        this.plotPrice = Math.min(plotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public double getPlotTypePrice(TownBlockType type) {
        double plotPrice;
        switch (type.ordinal()) {
            case 1: {
                plotPrice = this.getCommercialPlotPrice();
                break;
            }
            case 3: {
                plotPrice = this.getEmbassyPlotPrice();
                break;
            }
            default: {
                plotPrice = this.getPlotPrice();
            }
        }
        if (plotPrice < 0.0) {
            plotPrice = 0.0;
        }
        return plotPrice;
    }

    public void setCommercialPlotPrice(double commercialPlotPrice) {
        this.commercialPlotPrice = Math.min(commercialPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getCommercialPlotPrice() {
        return this.commercialPlotPrice;
    }

    public void setEmbassyPlotPrice(double embassyPlotPrice) {
        this.embassyPlotPrice = Math.min(embassyPlotPrice, TownySettings.getMaxPlotPrice());
    }

    public double getEmbassyPlotPrice() {
        return this.embassyPlotPrice;
    }

    public boolean isHomeBlock(TownBlock townBlock) {
        return this.hasHomeBlock() && townBlock == this.homeBlock;
    }

    public void setPlotTax(double plotTax) {
        this.plotTax = Math.min(plotTax, TownySettings.getMaxPlotTax());
    }

    public double getPlotTax() {
        return this.plotTax;
    }

    public void setCommercialPlotTax(double commercialTax) {
        this.commercialPlotTax = Math.min(commercialTax, TownySettings.getMaxPlotTax());
    }

    public double getCommercialPlotTax() {
        return this.commercialPlotTax;
    }

    public void setEmbassyPlotTax(double embassyPlotTax) {
        this.embassyPlotTax = Math.min(embassyPlotTax, TownySettings.getMaxPlotTax());
    }

    public double getEmbassyPlotTax() {
        return this.embassyPlotTax;
    }

    public void collect(double amount) throws EconomyException {
        if (TownyEconomyHandler.isActive()) {
            double bankcap = TownySettings.getTownBankCap();
            if (bankcap > 0.0 && amount + this.getAccount().getHoldingBalance() > bankcap) {
                TownyMessaging.sendPrefixedTownMessage(this, Translation.of("msg_err_deposit_capped", bankcap));
                return;
            }
            this.getAccount().deposit(amount, null);
        }
    }

    @Override
    public List<String> getTreeString(int depth) {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.getTreeDepth(depth) + "Town (" + this.getName() + ")");
        out.add(this.getTreeDepth(depth + 1) + "Mayor: " + (this.hasMayor() ? this.getMayor().getName() : "None"));
        out.add(this.getTreeDepth(depth + 1) + "Home: " + this.homeBlock);
        out.add(this.getTreeDepth(depth + 1) + "Bonus: " + this.bonusBlocks);
        out.add(this.getTreeDepth(depth + 1) + "TownBlocks (" + this.getTownBlocks().size() + "): ");
        List<Resident> assistants = this.getAssistants();
        if (assistants.size() > 0) {
            out.add(this.getTreeDepth(depth + 1) + "Assistants (" + assistants.size() + "): " + Arrays.toString(assistants.toArray(new Resident[0])));
        }
        out.add(this.getTreeDepth(depth + 1) + "Residents (" + this.getResidents().size() + "):");
        for (Resident resident : this.getResidents()) {
            out.addAll(resident.getTreeString(depth + 2));
        }
        return out;
    }

    public List<Location> getJailSpawns() {
        return this.jailSpawns;
    }

    public void addJailSpawn(Location spawn) throws TownyException {
        if (TownyAPI.getInstance().isWilderness(spawn)) {
            throw new TownyException(Translation.of("msg_err_location_is_not_within_a_town"));
        }
        this.removeJailSpawn(Coord.parseCoord(spawn));
        try {
            TownBlock jail = TownyAPI.getInstance().getTownBlock(spawn);
            if (!jail.isJail()) {
                throw new TownyException(Translation.of("msg_err_location_is_not_within_a_jail_plot"));
            }
            this.jailSpawns.add(spawn);
            this.save();
        }
        catch (NotRegisteredException e) {
            throw new TownyException(Translation.of("msg_err_location_is_not_within_a_town"));
        }
    }

    public void removeJailSpawn(Coord coord) {
        for (Location spawn : new ArrayList<Location>(this.jailSpawns)) {
            Coord spawnBlock = Coord.parseCoord(spawn);
            if (coord.getX() != spawnBlock.getX() || coord.getZ() != spawnBlock.getZ()) continue;
            this.jailSpawns.remove(spawn);
            this.save();
        }
    }

    public void forceAddJailSpawn(Location spawn) {
        this.jailSpawns.add(spawn);
    }

    public Location getJailSpawn(Integer index) throws TownyException {
        if (this.getMaxJailSpawn() == 0) {
            throw new TownyException(Translation.of("msg_err_town_has_no_jail_spawns_set"));
        }
        return this.jailSpawns.get(Math.min(this.getMaxJailSpawn() - 1, Math.max(0, index - 1)));
    }

    public int getMaxJailSpawn() {
        return this.jailSpawns.size();
    }

    public boolean hasJailSpawn() {
        return this.jailSpawns.size() > 0;
    }

    public List<Location> getAllJailSpawns() {
        return Collections.unmodifiableList(this.jailSpawns);
    }

    @Override
    public Collection<Resident> getOutlaws() {
        return Collections.unmodifiableList(this.outlaws);
    }

    public boolean hasOutlaw(String name) {
        for (Resident outlaw : this.outlaws) {
            if (!outlaw.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOutlaw(Resident outlaw) {
        return this.outlaws.contains(outlaw);
    }

    public void addOutlaw(Resident resident) throws AlreadyRegisteredException {
        this.addOutlawCheck(resident);
        this.outlaws.add(resident);
    }

    public void addOutlawCheck(Resident resident) throws AlreadyRegisteredException {
        if (this.hasOutlaw(resident)) {
            throw new AlreadyRegisteredException(Translation.of("msg_err_resident_already_an_outlaw"));
        }
        if (resident.hasTown()) {
            try {
                if (resident.getTown().equals(this)) {
                    throw new AlreadyRegisteredException(Translation.of("msg_err_not_outlaw_in_your_town"));
                }
            }
            catch (NotRegisteredException e) {
                e.printStackTrace();
            }
        }
    }

    public void removeOutlaw(Resident resident) {
        if (this.hasOutlaw(resident)) {
            this.outlaws.remove(resident);
        }
    }

    @Deprecated
    public UUID getUuid() {
        return this.getUUID();
    }

    public boolean hasValidUUID() {
        return this.uuid != null;
    }

    public void setOutpostSpawns(List<Location> outpostSpawns) {
        this.outpostSpawns = outpostSpawns;
    }

    public boolean isAlliedWith(Town othertown) {
        if (this.hasNation() && othertown.hasNation()) {
            try {
                if (this.getNation().hasAlly(othertown.getNation())) {
                    return true;
                }
                return this.getNation().equals(othertown.getNation());
            }
            catch (NotRegisteredException e) {
                return false;
            }
        }
        return false;
    }

    public int getOutpostLimit() {
        return TownySettings.getMaxOutposts(this);
    }

    public boolean isOverOutpostLimit() {
        return this.getMaxOutpostSpawn() > this.getOutpostLimit();
    }

    public boolean isOverClaimed() {
        return this.getTownBlocks().size() > TownySettings.getMaxTownBlocks(this);
    }

    @Override
    public void addMetaData(CustomDataField<?> md) {
        super.addMetaData(md);
        this.save();
    }

    @Override
    public void removeMetaData(CustomDataField<?> md) {
        super.removeMetaData(md);
        this.save();
    }

    public void setConquered(boolean conquered) {
        this.isConquered = conquered;
    }

    public boolean isConquered() {
        return this.isConquered;
    }

    public void setConqueredDays(int conqueredDays) {
        this.conqueredDays = conqueredDays;
    }

    public int getConqueredDays() {
        return this.conqueredDays;
    }

    public List<TownBlock> getTownBlocksForPlotGroup(PlotGroup group) {
        ArrayList<TownBlock> retVal = new ArrayList<TownBlock>();
        TownyMessaging.sendErrorMsg(group.toString());
        for (TownBlock townBlock : this.getTownBlocks()) {
            if (!townBlock.hasPlotObjectGroup() || !townBlock.getPlotObjectGroup().equals(group)) continue;
            retVal.add(townBlock);
        }
        return retVal;
    }

    public void renamePlotGroup(String oldName, PlotGroup group) {
        this.plotGroups.remove(oldName);
        this.plotGroups.put(group.getName(), group);
    }

    public void addPlotGroup(PlotGroup group) {
        if (!this.hasPlotGroups()) {
            this.plotGroups = new HashMap();
        }
        this.plotGroups.put(group.getName(), group);
    }

    public void removePlotGroup(PlotGroup plotGroup) {
        if (this.hasPlotGroups() && this.plotGroups.remove(plotGroup.getName()) != null) {
            for (TownBlock tb : this.getTownBlocks()) {
                if (!tb.hasPlotObjectGroup() || !tb.getPlotObjectGroup().equals(plotGroup)) continue;
                tb.getPlotObjectGroup().setID(null);
                tb.save();
            }
        }
    }

    public Collection<PlotGroup> getPlotGroups() {
        if (this.plotGroups == null) {
            return null;
        }
        return Collections.unmodifiableCollection(this.plotGroups.values());
    }

    public PlotGroup getObjectGroupFromID(UUID ID) {
        if (this.hasPlotGroups()) {
            for (PlotGroup pg : this.getPlotGroups()) {
                if (!pg.getID().equals(ID)) continue;
                return pg;
            }
        }
        return null;
    }

    public boolean hasPlotGroups() {
        return this.plotGroups != null;
    }

    public boolean hasPlotGroupName(String name) {
        return this.hasPlotGroups() && this.plotGroups.containsKey(name);
    }

    public PlotGroup getPlotObjectGroupFromName(String name) {
        if (this.hasPlotGroups()) {
            return this.plotGroups.get(name);
        }
        return null;
    }

    public PlotGroup getPlotObjectGroupFromID(UUID ID) {
        return this.getObjectGroupFromID(ID);
    }

    public Collection<PlotGroup> getPlotObjectGroups() {
        return this.getPlotGroups();
    }

    @Override
    public double getBankCap() {
        return TownySettings.getTownBankCap();
    }

    @Override
    public World getWorld() {
        return this.hasWorld() ? BukkitTools.getWorld(this.getHomeblockWorld().getName()) : BukkitTools.getWorlds().get(0);
    }

    @Override
    public String getBankAccountPrefix() {
        return ECONOMY_ACCOUNT_PREFIX;
    }

    @Override
    public String getFormattedName() {
        if (this.isCapital()) {
            return TownySettings.getCapitalPrefix(this) + this.getName().replaceAll("_", " ") + TownySettings.getCapitalPostfix(this);
        }
        return TownySettings.getTownPrefix(this) + this.getName().replaceAll("_", " ") + TownySettings.getTownPostfix(this);
    }

    public String getPrefix() {
        return TownySettings.getTownPrefix(this);
    }

    public String getPostfix() {
        return TownySettings.getTownPostfix(this);
    }

    public double getMaxPercentTaxAmount() {
        return this.maxPercentTaxAmount;
    }

    public void setMaxPercentTaxAmount(double maxPercentTaxAmount) {
        this.maxPercentTaxAmount = Math.min(maxPercentTaxAmount, TownySettings.getMaxTownTaxPercentAmount());
    }

    public boolean isBankrupt() {
        return TownyEconomyHandler.isActive() && this.debtBalance > 0.0;
    }

    public double getDebtBalance() {
        return this.debtBalance;
    }

    public void setDebtBalance(double balance) {
        this.debtBalance = balance;
    }

    public boolean isRuined() {
        if (!this.ruined && this.residents.size() == 0) {
            this.ruined = true;
        }
        return this.ruined;
    }

    public void setRuined(boolean b) {
        this.ruined = b;
    }

    public void setRuinedTime(long time) {
        this.ruinedTime = time;
    }

    public long getRuinedTime() {
        return this.ruinedTime;
    }

    @Deprecated
    public World getBukkitWorld() {
        if (this.hasWorld()) {
            return BukkitTools.getWorld(this.getHomeblockWorld().getName());
        }
        return BukkitTools.getWorlds().get(0);
    }

    @Deprecated
    public String getEconomyName() {
        return StringMgmt.trimMaxLength(ECONOMY_ACCOUNT_PREFIX + this.getName(), 32);
    }

    @Deprecated
    public double getHoldingBalance() throws EconomyException {
        try {
            return this.getAccount().getHoldingBalance();
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new EconomyException("Economy error getting holdings for " + this.getEconomyName());
        }
    }

    @Deprecated
    public boolean pay(double amount, String reason) throws EconomyException {
        if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
            return this.getAccount().payTo(amount, EconomyAccount.SERVER_ACCOUNT, reason);
        }
        return this.getAccount().withdraw(amount, null);
    }

    @Deprecated
    public boolean collect(double amount, String reason) throws EconomyException {
        return this.getAccount().deposit(amount, reason);
    }

    @Deprecated
    public String getTownBoard() {
        return this.getBoard();
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTown(this);
    }
}

