/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.PlotChangeOwnerEvent;
import com.palmergames.bukkit.towny.event.PlotChangeTypeEvent;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.PlotGroup;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlockOwner;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyObject;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.tasks.CooldownTimerTask;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TownBlock
extends TownyObject {
    private TownyWorld world;
    private Town town = null;
    private Resident resident = null;
    private TownBlockType type = TownBlockType.RESIDENTIAL;
    private int x;
    private int z;
    private double plotPrice = -1.0;
    private boolean locked = false;
    private boolean outpost = false;
    private PlotGroup plotGroup;
    protected TownyPermission permissions = new TownyPermission();
    protected boolean isChanged = false;

    public TownBlock(int x, int z, TownyWorld world) {
        super("");
        this.x = x;
        this.z = z;
        this.setWorld(world);
    }

    public void setTown(Town town) {
        if (this.hasTown()) {
            this.town.removeTownBlock(this);
        }
        this.town = town;
        try {
            TownyUniverse.getInstance().addTownBlock(this);
            town.addTownBlock(this);
        }
        catch (AlreadyRegisteredException | NullPointerException exception) {
            // empty catch block
        }
    }

    public Town getTown() throws NotRegisteredException {
        if (!this.hasTown()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a town.", this.world.getName(), this.x, this.z));
        }
        return this.town;
    }

    public boolean hasTown() {
        return this.town != null;
    }

    public void setResident(Resident resident) {
        boolean successful;
        try {
            if (this.hasResident()) {
                this.resident.removeTownBlock(this);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        this.resident = resident;
        try {
            resident.addTownBlock(this);
            successful = true;
        }
        catch (AlreadyRegisteredException | NullPointerException e) {
            successful = false;
        }
        if (successful) {
            Bukkit.getPluginManager().callEvent((Event)new PlotChangeOwnerEvent(this.resident, resident, this));
        }
        this.resident = resident;
    }

    public Resident getResident() throws NotRegisteredException {
        if (!this.hasResident()) {
            throw new NotRegisteredException(String.format("The TownBlock at (%s, %d, %d) is not registered to a resident.", this.world.getName(), this.x, this.z));
        }
        return this.resident;
    }

    public boolean hasResident() {
        return this.resident != null;
    }

    public boolean isOwner(TownBlockOwner owner) {
        try {
            if (owner == this.getTown()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        try {
            if (owner == this.getResident()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public void setPlotPrice(double ForSale) {
        this.plotPrice = ForSale;
    }

    public double getPlotPrice() {
        return this.plotPrice;
    }

    public boolean isForSale() {
        return this.getPlotPrice() != -1.0;
    }

    public void setPermissions(String line) {
        this.permissions.load(line);
    }

    public TownyPermission getPermissions() {
        return this.permissions;
    }

    public boolean isChanged() {
        return this.isChanged;
    }

    public void setChanged(boolean isChanged) {
        this.isChanged = isChanged;
    }

    public boolean isOutpost() {
        return this.outpost;
    }

    public void setOutpost(boolean outpost) {
        this.outpost = outpost;
    }

    public TownBlockType getType() {
        return this.type;
    }

    public void setType(TownBlockType type) {
        if (type != this.type) {
            this.permissions.reset();
        }
        if (type != null) {
            Bukkit.getPluginManager().callEvent((Event)new PlotChangeTypeEvent(this.type, type, this));
        }
        this.type = type;
        switch (type) {
            case RESIDENTIAL: 
            case COMMERCIAL: 
            case EMBASSY: 
            case BANK: {
                if (this.hasResident()) {
                    this.setPermissions(this.resident.getPermissions().toString());
                    break;
                }
                this.setPermissions(this.town.getPermissions().toString());
                break;
            }
            case ARENA: {
                this.setPermissions("pvp");
                break;
            }
            case SPLEEF: 
            case JAIL: {
                this.setPermissions("denyAll");
                break;
            }
            case INN: {
                this.setPermissions("residentSwitch,nationSwitch,allySwitch,outsiderSwitch");
                break;
            }
            case FARM: 
            case WILDS: {
                this.setPermissions("residentBuild,residentDestroy");
            }
        }
        this.setChanged(false);
    }

    public void setType(int typeId) {
        this.setType(TownBlockType.lookup(typeId));
    }

    public void setType(TownBlockType type, Resident resident) throws TownyException {
        if (this.isJail()) {
            this.getTown().removeJailSpawn(this.getCoord());
        }
        if ((this.getType().equals((Object)TownBlockType.ARENA) || type.equals((Object)TownBlockType.ARENA)) && TownySettings.getPVPCoolDownTime() > 0 && !TownyUniverse.getInstance().getPermissionSource().testPermission(resident.getPlayer(), PermissionNodes.TOWNY_ADMIN.getNode())) {
            if (CooldownTimerTask.hasCooldown(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)) {
                throw new TownyException(Translation.of("msg_err_cannot_toggle_pvp_x_seconds_remaining", CooldownTimerTask.getCooldownRemaining(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP)));
            }
            this.setType(type);
            CooldownTimerTask.addCooldownTimer(this.getWorldCoord().toString(), CooldownTimerTask.CooldownType.PVP);
        } else {
            this.setType(type);
        }
        if (this.isJail()) {
            Player p = TownyAPI.getInstance().getPlayer(resident);
            if (p == null) {
                throw new TownyException(Translation.of("msg_err_not_part_town"));
            }
            this.getTown().addJailSpawn(p.getLocation());
        }
        this.save();
    }

    public boolean isHomeBlock() {
        try {
            return this.getTown().isHomeBlock(this);
        }
        catch (NotRegisteredException e) {
            return false;
        }
    }

    @Override
    public void setName(String newName) {
        super.setName(newName.replace("_", " "));
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getX() {
        return this.x;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public int getZ() {
        return this.z;
    }

    public Coord getCoord() {
        return new Coord(this.x, this.z);
    }

    public WorldCoord getWorldCoord() {
        return new WorldCoord(this.world.getName(), this.x, this.z);
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void setWorld(TownyWorld world) {
        this.world = world;
    }

    public TownyWorld getWorld() {
        return this.world;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TownBlock townBlock = (TownBlock)o;
        return this.x == townBlock.x && this.z == townBlock.z && this.world.equals(townBlock.world);
    }

    public int hashCode() {
        return Objects.hash(this.world, this.x, this.z);
    }

    public void clear() {
        this.setTown(null);
        this.setResident(null);
        this.setWorld(null);
    }

    @Override
    public String toString() {
        return this.getWorld().getName() + " (" + this.getCoord() + ")";
    }

    public boolean isWarZone() {
        return this.getWorld().isWarZone(this.getCoord());
    }

    public boolean isJail() {
        return this.getType() == TownBlockType.JAIL;
    }

    @Override
    public void addMetaData(CustomDataField<?> md) {
        super.addMetaData(md);
        this.save();
    }

    @Override
    public void removeMetaData(CustomDataField<?> md) {
        super.removeMetaData(md);
        this.save();
    }

    public boolean hasPlotObjectGroup() {
        return this.plotGroup != null;
    }

    public PlotGroup getPlotObjectGroup() {
        return this.plotGroup;
    }

    public void removePlotObjectGroup() {
        this.plotGroup = null;
    }

    public void setPlotObjectGroup(PlotGroup group) {
        this.plotGroup = group;
        try {
            group.addTownBlock(this);
        }
        catch (NullPointerException e) {
            TownyMessaging.sendErrorMsg("Townblock failed to setPlotObjectGroup(group), group is null. " + group);
        }
    }

    @Override
    public void save() {
        TownyUniverse.getInstance().getDataSource().saveTownBlock(this);
    }
}

