/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.Savable;
import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class TownyObject
implements Nameable,
Savable {
    private String name;
    private Map<String, CustomDataField<?>> metadata = null;

    protected TownyObject(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public List<String> getTreeString(int depth) {
        return new ArrayList<String>();
    }

    public String getTreeDepth(int depth) {
        char[] fill = new char[depth * 4];
        Arrays.fill(fill, ' ');
        if (depth > 0) {
            fill[0] = 124;
            int offset = (depth - 1) * 4;
            fill[offset] = 43;
            fill[offset + 1] = 45;
            fill[offset + 2] = 45;
        }
        return new String(fill);
    }

    public String toString() {
        return this.getName();
    }

    public void addMetaData(CustomDataField<?> md) {
        if (this.metadata == null) {
            this.metadata = new HashMap();
        }
        this.metadata.put(md.getKey(), md);
    }

    public void removeMetaData(CustomDataField<?> md) {
        if (!this.hasMeta()) {
            return;
        }
        this.metadata.remove(md.getKey());
        if (this.metadata.isEmpty()) {
            this.metadata = null;
        }
    }

    public Collection<CustomDataField<?>> getMetadata() {
        if (this.metadata == null || this.metadata.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableCollection(this.metadata.values());
    }

    public CustomDataField<?> getMetadata(String key) {
        if (this.metadata != null) {
            return this.metadata.get(key);
        }
        return null;
    }

    public boolean hasMeta() {
        return this.metadata != null;
    }

    public boolean hasMeta(String key) {
        if (this.metadata != null) {
            return this.metadata.containsKey(key);
        }
        return false;
    }

    public void setMetadata(String str) {
        String[] objects = str.split(";");
        if (this.metadata == null) {
            this.metadata = new HashMap(objects.length);
        }
        for (String object : objects) {
            CustomDataField<?> cdf = CustomDataField.load(object);
            this.metadata.put(cdf.getKey(), cdf);
        }
    }
}

