/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.command.HelpMenu;
import com.palmergames.bukkit.util.Colors;
import com.palmergames.util.FileMgmt;
import com.palmergames.util.StringMgmt;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.InvalidConfigurationException;

public final class Translation {
    public static CommentedConfiguration language;

    public static void loadLanguage(String filepath, String defaultRes) throws IOException {
        String res = TownySettings.getString(ConfigNodes.LANGUAGE.getRoot(), defaultRes);
        String fullPath = filepath + File.separator + res;
        File file = FileMgmt.unpackResourceFile(fullPath, res, defaultRes);
        language = new CommentedConfiguration(file);
        language.load();
        HelpMenu.loadMenus();
        CommentedConfiguration newLanguage = new CommentedConfiguration(file);
        try {
            newLanguage.loadFromString(FileMgmt.convertStreamToString("/" + res));
        }
        catch (IOException e) {
            System.out.println("[Towny] Lang: Custom language file detected, not updating.");
            System.out.println("[Towny] Lang: " + res + " v" + Translation.of("version") + " loaded.");
            return;
        }
        catch (InvalidConfigurationException e) {
            TownyMessaging.sendMsg("Invalid Configuration in language file detected.");
        }
        String resVersion = newLanguage.getString("version");
        String langVersion = Translation.of("version");
        if (!langVersion.equalsIgnoreCase(resVersion)) {
            language = newLanguage;
            System.out.println("[Towny] Lang: Language file replaced with updated version.");
            FileMgmt.stringToFile(FileMgmt.convertStreamToString("/" + res), file);
        }
        System.out.println("[Towny] Lang: " + res + " v" + Translation.of("version") + " loaded.");
    }

    private static String parseSingleLineString(String str) {
        return Colors.translateColorCodes(str);
    }

    public static String of(String key) {
        String data = language.getString(key.toLowerCase());
        if (data == null) {
            TownySettings.sendError(key.toLowerCase() + " from " + TownySettings.getString(ConfigNodes.LANGUAGE));
            return "";
        }
        return StringMgmt.translateHexColors(Translation.parseSingleLineString(data));
    }

    public static String of(String key, Object ... args) {
        return String.format(Translation.of(key), args);
    }

    private Translation() {
    }
}

