/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.config.ConfigNodes;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.EconomyHandler;
import com.palmergames.bukkit.towny.object.Nameable;
import com.palmergames.bukkit.towny.object.economy.AccountAuditor;
import com.palmergames.bukkit.towny.object.economy.AccountObserver;
import com.palmergames.bukkit.towny.object.economy.GlobalAccountObserver;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bukkit.World;

public abstract class Account
implements Nameable {
    private static final AccountObserver GLOBAL_OBSERVER = new GlobalAccountObserver();
    private final List<AccountObserver> observers = new ArrayList<AccountObserver>();
    private AccountAuditor auditor;
    String name;
    World world;

    public Account(String name) {
        this.name = name;
        this.observers.add(GLOBAL_OBSERVER);
    }

    public Account(String name, World world) {
        this.name = name;
        this.world = world;
        this.observers.add(GLOBAL_OBSERVER);
    }

    protected abstract boolean addMoney(double var1);

    protected abstract boolean subtractMoney(double var1);

    public boolean deposit(double amount, String reason) throws EconomyException {
        if (this.addMoney(amount)) {
            this.notifyObserversDeposit(this, amount, reason);
            if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
                return this.payFromServer(amount, reason);
            }
            return true;
        }
        return false;
    }

    public boolean withdraw(double amount, String reason) throws EconomyException {
        if (this.subtractMoney(amount)) {
            this.notifyObserversWithdraw(this, amount, reason);
            if (TownySettings.getBoolean(ConfigNodes.ECO_CLOSED_ECONOMY_ENABLED)) {
                return this.payToServer(amount, reason);
            }
            return true;
        }
        return false;
    }

    public boolean payTo(double amount, EconomyHandler collector, String reason) throws EconomyException {
        return this.payTo(amount, collector.getAccount(), reason);
    }

    protected boolean payToServer(double amount, String reason) throws EconomyException {
        return TownyEconomyHandler.addToServer(amount, this.getBukkitWorld());
    }

    protected boolean payFromServer(double amount, String reason) throws EconomyException {
        return TownyEconomyHandler.subtractFromServer(amount, this.getBukkitWorld());
    }

    public boolean payTo(double amount, Account collector, String reason) throws EconomyException {
        if (amount > this.getHoldingBalance()) {
            return false;
        }
        return this.withdraw(amount, reason) && collector.deposit(amount, reason);
    }

    public World getBukkitWorld() {
        return BukkitTools.getWorlds().get(0);
    }

    public boolean setBalance(double amount, String reason) throws EconomyException {
        double balance = this.getHoldingBalance();
        double diff = amount - balance;
        if (diff > 0.0) {
            return this.deposit(diff, reason);
        }
        if (balance > amount) {
            diff = -diff;
            return this.withdraw(diff, reason);
        }
        return true;
    }

    public double getHoldingBalance() throws EconomyException {
        try {
            return TownyEconomyHandler.getBalance(this.getName(), this.getBukkitWorld());
        }
        catch (NoClassDefFoundError e) {
            e.printStackTrace();
            throw new EconomyException("Economy error getting holdings for " + this.getName());
        }
    }

    public boolean canPayFromHoldings(double amount) throws EconomyException {
        return TownyEconomyHandler.hasEnough(this.getName(), amount, this.getBukkitWorld());
    }

    public String getHoldingFormattedBalance() {
        try {
            return TownyEconomyHandler.getFormattedBalance(this.getHoldingBalance());
        }
        catch (EconomyException e) {
            return "Error Accessing Bank Account";
        }
    }

    public void removeAccount() {
        TownyEconomyHandler.removeAccount(this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<AccountObserver> getObservers() {
        return Collections.unmodifiableList(this.observers);
    }

    private void notifyObserversDeposit(Account account, double amount, String reason) {
        for (AccountObserver observer : this.getObservers()) {
            observer.deposited(account, amount, reason);
        }
    }

    private void notifyObserversWithdraw(Account account, double amount, String reason) {
        for (AccountObserver observer : this.getObservers()) {
            observer.withdrew(account, amount, reason);
        }
    }

    public final void addObserver(AccountObserver observer) {
        this.observers.add(observer);
    }

    public final void removeObserver(AccountObserver observer) {
        this.observers.remove(observer);
    }

    public final AccountAuditor getAuditor() {
        return this.auditor;
    }

    public final void setAuditor(AccountAuditor auditor) {
        this.auditor = auditor;
        this.addObserver(auditor);
    }

    @Deprecated
    public boolean collect(double amount, String reason) throws EconomyException {
        return this.deposit(amount, reason);
    }

    @Deprecated
    public boolean pay(double amount, String reason) throws EconomyException {
        return this.withdraw(amount, reason);
    }
}

