/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.economy;

import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.object.TransactionType;
import com.palmergames.bukkit.towny.object.economy.Account;
import com.palmergames.bukkit.towny.object.economy.AccountAuditor;
import com.palmergames.bukkit.towny.object.economy.BankTransaction;
import java.util.ArrayList;
import java.util.List;

public class GovernmentAccountAuditor
implements AccountAuditor {
    private List<BankTransaction> transactions = new ArrayList<BankTransaction>();

    @Override
    public void withdrew(Account account, double amount, String reason) {
        try {
            this.transactions.add(new BankTransaction(TransactionType.WITHDRAW, System.currentTimeMillis(), account, amount, account.getHoldingBalance(), reason));
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
    }

    @Override
    public void deposited(Account account, double amount, String reason) {
        try {
            this.transactions.add(new BankTransaction(TransactionType.DEPOSIT, System.currentTimeMillis(), account, amount, account.getHoldingBalance(), reason));
        }
        catch (EconomyException economyException) {
            // empty catch block
        }
    }

    @Override
    public List<String> getAuditHistory() {
        ArrayList<String> history = new ArrayList<String>(this.transactions.size());
        for (BankTransaction transaction : this.transactions) {
            String line = transaction.getTime() + "\n\n";
            line = line + transaction.getType().getName() + " of " + TownyEconomyHandler.getFormattedBalance(transaction.getAmount());
            line = line + (transaction.getType() == TransactionType.DEPOSIT ? " to " : " from ") + transaction.getAccount().getName() + "\n\n";
            line = line + "Reason: " + transaction.getReason() + "\n\n";
            line = line + "Balance: " + TownyEconomyHandler.getFormattedBalance(transaction.getBalance());
            history.add(line);
        }
        return history;
    }
}

