/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.exceptions.InvalidMetadataTypeException;
import com.palmergames.bukkit.towny.object.metadata.BooleanDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataFieldType;
import com.palmergames.bukkit.towny.object.metadata.DecimalDataField;
import com.palmergames.bukkit.towny.object.metadata.IntegerDataField;
import com.palmergames.bukkit.towny.object.metadata.LongDataField;
import com.palmergames.bukkit.towny.object.metadata.StringDataField;

public abstract class CustomDataField<T>
implements Cloneable {
    private final CustomDataFieldType type;
    private T value;
    private final String key;
    protected String label;

    public CustomDataField(String key, CustomDataFieldType type, T value, String label) {
        this.type = type;
        this.setValue(value);
        this.key = key;
        this.label = label;
    }

    public CustomDataField(String key, CustomDataFieldType type, T value) {
        this(key, type, value, null);
    }

    public CustomDataField(String key, CustomDataFieldType type, String label) {
        this(key, type, null, label);
    }

    public CustomDataField(String key, CustomDataFieldType type) {
        this(key, type, null, null);
    }

    public CustomDataFieldType getType() {
        return this.type;
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        this.value = value;
    }

    public abstract void setValueFromString(String var1);

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        if (this.hasLabel()) {
            return this.label;
        }
        return "nil";
    }

    public boolean hasLabel() {
        return this.label != null;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        String out = "";
        out = out + this.type.getValue().toString();
        out = out + "," + this.getKey();
        out = out + "," + this.getValue();
        out = out + "," + this.getLabel();
        return out;
    }

    public static CustomDataField<?> load(String str) {
        String[] tokens = str.split(",");
        CustomDataFieldType type = CustomDataFieldType.fromValue(Integer.parseInt(tokens[0]));
        String key = tokens[1];
        CustomDataField field = null;
        switch (type) {
            case IntegerField: {
                field = new IntegerDataField(key);
                break;
            }
            case StringField: {
                field = new StringDataField(key);
                break;
            }
            case BooleanField: {
                field = new BooleanDataField(key);
                break;
            }
            case DecimalField: {
                field = new DecimalDataField(key);
                break;
            }
            case LongField: {
                field = new LongDataField(key);
            }
        }
        if (field.canParseFromString(tokens[2])) {
            field.setValueFromString(tokens[2]);
        }
        String label = tokens[3] == null || tokens[3].equalsIgnoreCase("nil") ? null : tokens[3];
        field.setLabel(label);
        return field;
    }

    protected boolean canParseFromString(String strValue) {
        return true;
    }

    public final void isValidType(String str) throws InvalidMetadataTypeException {
        if (!this.canParseFromString(str)) {
            throw new InvalidMetadataTypeException(this.type);
        }
    }

    public abstract String displayFormattedValue();

    public boolean equals(Object rhs) {
        if (rhs instanceof CustomDataField) {
            return ((CustomDataField)rhs).getKey().equals(this.getKey());
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public abstract CustomDataField<T> clone();

    @Deprecated
    public CustomDataField<T> newCopy() {
        return this.clone();
    }
}

