/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataFieldType;

public class DecimalDataField
extends CustomDataField<Double> {
    public DecimalDataField(String key, Double value) {
        super(key, CustomDataFieldType.DecimalField, value);
    }

    public DecimalDataField(String key, Double value, String label) {
        super(key, CustomDataFieldType.DecimalField, value, label);
    }

    public DecimalDataField(String key) {
        super(key, CustomDataFieldType.DecimalField, 0.0);
    }

    @Override
    public void setValueFromString(String strValue) {
        this.setValue(Double.parseDouble(strValue));
    }

    @Override
    public boolean canParseFromString(String str) {
        try {
            Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public String displayFormattedValue() {
        double val = (Double)this.getValue();
        return (val <= 0.0 ? "\u00a74" : "\u00a7a") + val;
    }

    @Override
    public CustomDataField<Double> clone() {
        return new DecimalDataField(this.getKey(), (Double)this.getValue(), this.getLabel());
    }
}

