/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.object.metadata;

import com.palmergames.bukkit.towny.object.metadata.CustomDataField;
import com.palmergames.bukkit.towny.object.metadata.CustomDataFieldType;

public class LongDataField
extends CustomDataField<Long> {
    public LongDataField(String key, Long value) {
        super(key, CustomDataFieldType.LongField, value);
    }

    public LongDataField(String key, Long value, String label) {
        super(key, CustomDataFieldType.LongField, value, label);
    }

    public LongDataField(String key) {
        this(key, 0L);
    }

    @Override
    public void setValueFromString(String strValue) {
        this.setValue(Long.parseLong(strValue));
    }

    @Override
    public boolean canParseFromString(String str) {
        try {
            Long.parseLong(str);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    @Override
    public String displayFormattedValue() {
        long lval = (Long)this.getValue();
        return (lval <= 0L ? "\u00a74" : "\u00a7a") + lval;
    }

    @Override
    public CustomDataField<Long> clone() {
        return new LongDataField(this.getKey(), (Long)this.getValue(), this.label);
    }
}

