/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.permissions;

import com.palmergames.bukkit.config.CommentedConfiguration;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.util.BukkitTools;
import com.palmergames.util.FileMgmt;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.bukkit.configuration.MemorySection;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionAttachment;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.Nullable;

public class TownyPerms {
    protected static LinkedHashMap<String, Permission> registeredPermissions = new LinkedHashMap();
    protected static HashMap<String, PermissionAttachment> attachments = new HashMap();
    private static CommentedConfiguration perms;
    private static Towny plugin;
    private static Field permissions;

    public static void initialize(Towny plugin) {
        TownyPerms.plugin = plugin;
    }

    public static void loadPerms(String filepath, String defaultRes) throws TownyException {
        String fullPath = filepath + File.separator + defaultRes;
        File file = FileMgmt.unpackResourceFile(fullPath, defaultRes, defaultRes);
        if (file != null && !(perms = new CommentedConfiguration(file)).load()) {
            throw new TownyException("Could not read Townyperms.yml");
        }
        TownyPerms.collectPermissions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assignPermissions(Resident resident, Player player) {
        PermissionAttachment playersAttachment;
        TownyWorld World2;
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        if (resident == null) {
            if (player != null) {
                resident = townyUniverse.getResident(player.getUniqueId());
            }
            if (resident == null) {
                return;
            }
        } else {
            player = BukkitTools.getPlayer(resident.getName());
        }
        if (player == null || !player.isOnline()) {
            attachments.remove(resident.getName());
            return;
        }
        try {
            World2 = townyUniverse.getDataSource().getWorld(player.getLocation().getWorld().getName());
        }
        catch (NotRegisteredException e) {
            e.printStackTrace();
            return;
        }
        if (attachments.containsKey(resident.getName())) {
            playersAttachment = attachments.get(resident.getName());
        } else {
            try {
                playersAttachment = BukkitTools.getPlayer(resident.getName()).addAttachment((Plugin)plugin);
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            PermissionAttachment e = playersAttachment;
            synchronized (e) {
                Map orig = (Map)permissions.get(playersAttachment);
                orig.clear();
                if (World2.isUsingTowny()) {
                    orig.putAll(TownyPerms.getResidentPerms(resident));
                }
                playersAttachment.getPermissible().recalculatePermissions();
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        attachments.put(resident.getName(), playersAttachment);
    }

    public static void removeAttachment(String name) {
        attachments.remove(name);
    }

    public static void updateOnlinePerms() {
        for (Player player : BukkitTools.getOnlinePlayers()) {
            TownyPerms.assignPermissions(null, player);
        }
    }

    public static void updateTownPerms(Town town) {
        for (Resident resident : town.getResidents()) {
            TownyPerms.assignPermissions(resident, null);
        }
    }

    public static void updateNationPerms(Nation nation) {
        for (Town town : nation.getTowns()) {
            TownyPerms.updateTownPerms(town);
        }
    }

    private static List<String> getList(String path) {
        if (perms.contains(path)) {
            return perms.getStringList(path);
        }
        return null;
    }

    public static LinkedHashMap<String, Boolean> getResidentPerms(Resident resident) {
        HashSet<String> permList = new HashSet<String>(TownyPerms.getDefault());
        if (resident.hasTown()) {
            try {
                permList.addAll(TownyPerms.getTownDefault(resident.getTown()));
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            if (resident.isMayor()) {
                permList.addAll(TownyPerms.getTownMayor());
            }
            for (String rank : resident.getTownRanks()) {
                permList.addAll(TownyPerms.getTownRank(rank));
            }
            if (resident.hasNation()) {
                permList.addAll(TownyPerms.getNationDefault());
                if (resident.isKing()) {
                    permList.addAll(TownyPerms.getNationKing());
                }
                for (String rank : resident.getNationRanks()) {
                    permList.addAll(TownyPerms.getNationRank(rank));
                }
            }
        }
        List<String> playerPermArray = TownyPerms.sort(new ArrayList<String>(permList));
        LinkedHashMap<String, Boolean> newPerms = new LinkedHashMap<String, Boolean>();
        Boolean value = false;
        for (String permission : playerPermArray) {
            String placeholderPerm2;
            if (permission.contains("{townname}")) {
                if (!resident.hasTown()) continue;
                try {
                    placeholderPerm2 = permission.replace("{townname}", resident.getTown().getName().toLowerCase());
                    newPerms.put(placeholderPerm2, true);
                }
                catch (NotRegisteredException placeholderPerm2) {}
                continue;
            }
            if (permission.contains("{nationname}")) {
                if (!resident.hasNation()) continue;
                try {
                    placeholderPerm2 = permission.replace("{nationname}", resident.getTown().getNation().getName().toLowerCase());
                    newPerms.put(placeholderPerm2, true);
                }
                catch (NotRegisteredException notRegisteredException) {}
                continue;
            }
            value = !permission.startsWith("-");
            newPerms.put(value != false ? permission : permission.substring(1), value);
        }
        return newPerms;
    }

    public static void registerPermissionNodes() {
        plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

            @Override
            public void run() {
                Permission perm;
                for (String rank : TownyPerms.getTownRanks()) {
                    perm = new Permission(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(rank), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                    perm.addParent(PermissionNodes.TOWNY_COMMAND_TOWN_RANK.getNode(), true);
                }
                for (String rank : TownyPerms.getNationRanks()) {
                    perm = new Permission(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(rank), "User can grant this town rank to others..", PermissionDefault.FALSE, null);
                    perm.addParent(PermissionNodes.TOWNY_COMMAND_NATION_RANK.getNode(), true);
                }
            }
        }, 1L);
    }

    public static List<String> getDefault() {
        ArrayList permsList = TownyPerms.getList("nomad");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getTownRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("towns.ranks")).getKeys(false));
    }

    public static List<String> getTownDefault(Town town) {
        List<String> permsList = TownyPerms.getList("towns.default");
        if (permsList == null) {
            ArrayList<String> emptyPermsList = new ArrayList<String>();
            emptyPermsList.add("towny.town." + town.getName().toLowerCase());
            return emptyPermsList;
        }
        permsList.add("towny.town." + town.getName().toLowerCase());
        return permsList;
    }

    public static List<String> getTownMayor() {
        ArrayList permsList = TownyPerms.getList("towns.mayor");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getTownRank(String rank) {
        ArrayList permsList = TownyPerms.getList("towns.ranks." + rank);
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getNationRanks() {
        return new ArrayList<String>(((MemorySection)perms.get("nations.ranks")).getKeys(false));
    }

    public static List<String> getNationDefault() {
        ArrayList permsList = TownyPerms.getList("nations.default");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getNationKing() {
        ArrayList permsList = TownyPerms.getList("nations.king");
        return permsList == null ? new ArrayList() : permsList;
    }

    public static List<String> getNationRank(String rank) {
        ArrayList permsList = TownyPerms.getList("nations.ranks." + rank);
        return permsList == null ? new ArrayList() : permsList;
    }

    @Nullable
    public static String matchNationRank(String rank) {
        for (String nationRank : TownyPerms.getNationRanks()) {
            if (!nationRank.equalsIgnoreCase(rank)) continue;
            return nationRank;
        }
        return null;
    }

    @Nullable
    public static String matchTownRank(String rank) {
        for (String townRank : TownyPerms.getTownRanks()) {
            if (!townRank.equalsIgnoreCase(rank)) continue;
            return townRank;
        }
        return null;
    }

    public static void collectPermissions() {
        registeredPermissions.clear();
        for (Permission perm : BukkitTools.getPluginManager().getPermissions()) {
            registeredPermissions.put(perm.getName().toLowerCase(), perm);
        }
    }

    private static List<String> sort(List<String> permList) {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : permList) {
            String a = key.charAt(0) == '-' ? key.substring(1) : key;
            Map<String, Boolean> allchildren = TownyPerms.getAllChildren(a, new HashSet<String>());
            if (allchildren != null) {
                ListIterator<String> itr = result.listIterator();
                while (itr.hasNext()) {
                    String node = (String)itr.next();
                    String b = node.charAt(0) == '-' ? node.substring(1) : node;
                    if (!allchildren.containsKey(b)) continue;
                    itr.set(key);
                    itr.add(node);
                    break;
                }
            }
            if (result.contains(key)) continue;
            result.add(key);
        }
        return result;
    }

    public List<String> getAllRegisteredPermissions(boolean includeChildren) {
        ArrayList<String> perms = new ArrayList<String>();
        for (String key : registeredPermissions.keySet()) {
            Map<String, Boolean> children;
            if (perms.contains(key)) continue;
            perms.add(key);
            if (!includeChildren || (children = TownyPerms.getAllChildren(key, new HashSet<String>())) == null) continue;
            for (String node : children.keySet()) {
                if (perms.contains(node)) continue;
                perms.add(node);
            }
        }
        return perms;
    }

    public static Map<String, Boolean> getAllChildren(String node, Set<String> playerPermArray) {
        LinkedList<String> stack = new LinkedList<String>();
        HashMap<String, Boolean> alreadyVisited = new HashMap<String, Boolean>();
        stack.push(node);
        alreadyVisited.put(node, true);
        while (!stack.isEmpty()) {
            String now = (String)stack.pop();
            Map<String, Boolean> children = TownyPerms.getChildren(now);
            if (children == null || playerPermArray.contains("-" + now)) continue;
            for (String childName : children.keySet()) {
                if (alreadyVisited.containsKey(childName)) continue;
                stack.push(childName);
                alreadyVisited.put(childName, children.get(childName));
            }
        }
        alreadyVisited.remove(node);
        if (!alreadyVisited.isEmpty()) {
            return alreadyVisited;
        }
        return null;
    }

    public static Map<String, Boolean> getChildren(String node) {
        Permission perm = registeredPermissions.get(node.toLowerCase());
        if (perm == null) {
            return null;
        }
        return perm.getChildren();
    }

    static {
        try {
            permissions = PermissionAttachment.class.getDeclaredField("permissions");
            permissions.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            e.printStackTrace();
        }
    }
}

