/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.event.NewDayEvent;
import com.palmergames.bukkit.towny.event.PreNewDayEvent;
import com.palmergames.bukkit.towny.event.time.dailytaxes.PreTownPaysNationTaxEvent;
import com.palmergames.bukkit.towny.event.town.TownUnconquerEvent;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.ResidentPurge;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.MoneyUtil;
import com.palmergames.bukkit.util.ChatTools;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DailyTimerTask
extends TownyTimerTask {
    private double totalTownUpkeep = 0.0;
    private double totalNationUpkeep = 0.0;
    private final List<String> bankruptedTowns = new ArrayList<String>();
    private final List<String> removedTowns = new ArrayList<String>();
    private final List<String> removedNations = new ArrayList<String>();

    public DailyTimerTask(Towny plugin) {
        super(plugin);
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        this.totalTownUpkeep = 0.0;
        this.totalNationUpkeep = 0.0;
        this.bankruptedTowns.clear();
        this.removedTowns.clear();
        this.removedNations.clear();
        Bukkit.getPluginManager().callEvent((Event)new PreNewDayEvent());
        TownyMessaging.sendDebugMsg("New Day");
        if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
            TownyMessaging.sendGlobalMessage(Translation.of("msg_new_day_tax"));
            try {
                TownyMessaging.sendDebugMsg("Collecting Town Taxes");
                this.collectTownTaxes();
                TownyMessaging.sendDebugMsg("Collecting Nation Taxes");
                this.collectNationTaxes();
                TownyMessaging.sendDebugMsg("Collecting Town Costs");
                this.collectTownCosts();
                TownyMessaging.sendDebugMsg("Collecting Nation Costs");
                this.collectNationCosts();
                Bukkit.getServer().getPluginManager().callEvent((Event)new NewDayEvent(this.bankruptedTowns, this.removedTowns, this.removedNations, this.totalTownUpkeep, this.totalNationUpkeep, start));
            }
            catch (EconomyException ex) {
                TownyMessaging.sendErrorMsg("Economy Exception");
                ex.printStackTrace();
            }
        } else {
            TownyMessaging.sendGlobalMessage(Translation.of("msg_new_day"));
        }
        if (TownySettings.isDeletingOldResidents()) {
            new ResidentPurge(this.plugin, null, TownySettings.getDeleteTime() * 1000L, TownySettings.isDeleteTownlessOnly()).start();
        }
        if (TownySettings.isNewDayDeleting0PlotTowns()) {
            ArrayList<String> deletedTowns = new ArrayList<String>();
            for (Town town : this.universe.getTowns()) {
                if (town.getTownBlocks().size() != 0) continue;
                deletedTowns.add(town.getName());
                this.universe.getDataSource().removeTown(town);
            }
            if (!deletedTowns.isEmpty()) {
                TownyMessaging.sendGlobalMessage(Translation.of("msg_the_following_towns_were_deleted_for_having_0_claims", String.join((CharSequence)", ", deletedTowns)));
            }
        }
        if (!this.universe.getJailedResidentMap().isEmpty()) {
            for (final Resident resident : this.universe.getJailedResidentMap()) {
                if (resident.hasJailDays()) {
                    if (resident.getJailDays() == 1) {
                        resident.setJailDays(0);
                        new BukkitRunnable(){

                            public void run() {
                                Town jailTown = DailyTimerTask.this.universe.getTown(resident.getJailTown());
                                if (jailTown != null) {
                                    int index = resident.getJailSpawn();
                                    resident.setJailed(index, jailTown);
                                }
                            }
                        }.runTaskLater((Plugin)this.plugin, 20L);
                    } else {
                        resident.setJailDays(resident.getJailDays() - 1);
                    }
                }
                resident.save();
            }
        }
        for (Town town : this.universe.getDataSource().getTowns()) {
            if (!town.isConquered()) continue;
            if (town.getConqueredDays() == 1) {
                TownUnconquerEvent event = new TownUnconquerEvent(town);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    return;
                }
                town.setConquered(false);
                town.setConqueredDays(0);
                continue;
            }
            town.setConqueredDays(town.getConqueredDays() - 1);
        }
        if (TownySettings.isBackingUpDaily()) {
            this.universe.performCleanupAndBackup();
        }
        TownyMessaging.sendDebugMsg("Finished New Day Code");
        TownyMessaging.sendDebugMsg("Universe Stats:");
        TownyMessaging.sendDebugMsg("    Residents: " + this.universe.getNumResidents());
        TownyMessaging.sendDebugMsg("    Towns: " + this.universe.getDataSource().getTowns().size());
        TownyMessaging.sendDebugMsg("    Nations: " + this.universe.getNumNations());
        for (TownyWorld world : this.universe.getDataSource().getWorlds()) {
            TownyMessaging.sendDebugMsg("    " + world.getName() + " (townblocks): " + this.universe.getTownBlocks().size());
        }
        TownyMessaging.sendDebugMsg("Memory (Java Heap):");
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (max)", Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (total)", Runtime.getRuntime().totalMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (free)", Runtime.getRuntime().freeMemory() / 1024L / 1024L));
        TownyMessaging.sendDebugMsg(String.format("%8d Mb (used=total-free)", (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L));
        Towny.getPlugin().getLogger().info("Towny DailyTimerTask took " + (System.currentTimeMillis() - start) + "ms to process.");
    }

    public void collectNationTaxes() throws EconomyException {
        ArrayList<Nation> nations = new ArrayList<Nation>(this.universe.getNations());
        ListIterator nationItr = nations.listIterator();
        while (nationItr.hasNext()) {
            Nation nation = (Nation)nationItr.next();
            if (!this.universe.hasNation(nation.getName())) continue;
            this.collectNationTaxes(nation);
        }
    }

    protected void collectNationTaxes(Nation nation) throws EconomyException {
        if (nation.getTaxes() > 0.0) {
            double taxAmount = nation.getTaxes();
            ArrayList<String> localNewlyDelinquentTowns = new ArrayList<String>();
            ArrayList<String> localTownsDestroyed = new ArrayList<String>();
            ArrayList<Town> towns = new ArrayList<Town>(nation.getTowns());
            ListIterator townItr = towns.listIterator();
            while (townItr.hasNext()) {
                Town town = (Town)townItr.next();
                if (!this.universe.getDataSource().hasTown(town.getName()) || town.isCapital() || !town.hasUpkeep() || town.isRuined()) continue;
                PreTownPaysNationTaxEvent event = new PreTownPaysNationTaxEvent(town, nation, taxAmount);
                Bukkit.getPluginManager().callEvent((Event)event);
                if (event.isCancelled()) {
                    TownyMessaging.sendPrefixedTownMessage(town, event.getCancellationMessage());
                    continue;
                }
                taxAmount = event.getTax();
                if (town.getAccount().canPayFromHoldings(taxAmount)) {
                    town.getAccount().payTo(taxAmount, nation, "Nation Tax to " + nation.getName());
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_payed_nation_tax", TownyEconomyHandler.getFormattedBalance(taxAmount)));
                    continue;
                }
                if (!TownySettings.isTownBankruptcyEnabled() || !TownySettings.doBankruptTownsPayNationTax()) {
                    if (TownySettings.doesNationTaxDeleteConqueredTownsWhichCannotPay() && town.isConquered()) {
                        this.universe.getDataSource().removeTown(town);
                        localTownsDestroyed.add(town.getName());
                        continue;
                    }
                    localNewlyDelinquentTowns.add(town.getName());
                    town.removeNation();
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_your_town_couldnt_pay_the_nation_tax_of", TownyEconomyHandler.getFormattedBalance(taxAmount)));
                    continue;
                }
                boolean townWasBankrupt = town.isBankrupt();
                town.getAccount().setDebtCap(MoneyUtil.getEstimatedValueOfTown(town));
                if (town.getAccount().getHoldingBalance() - taxAmount < town.getAccount().getDebtCap() * -1.0) {
                    if (TownySettings.isNationTaxKickingTownsThatReachDebtCap()) {
                        localNewlyDelinquentTowns.add(town.getName());
                        town.removeNation();
                        TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_your_town_couldnt_pay_the_nation_tax_of", TownyEconomyHandler.getFormattedBalance(nation.getTaxes())));
                        continue;
                    }
                    taxAmount = town.getAccount().getDebtCap() - Math.abs(town.getAccount().getHoldingBalance());
                }
                town.getAccount().withdraw(taxAmount, "Nation Tax to " + nation.getName());
                nation.getAccount().deposit(taxAmount, "Nation Tax from " + town.getName());
                TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_payed_nation_tax_with_debt", TownyEconomyHandler.getFormattedBalance(taxAmount)));
                if (townWasBankrupt) continue;
                town.setOpen(false);
                town.save();
                localNewlyDelinquentTowns.add(town.getName());
            }
            String msg1 = "msg_couldnt_pay_tax";
            String msg2 = "msg_couldnt_pay_nation_tax_multiple";
            if (TownySettings.isTownBankruptcyEnabled() && TownySettings.doBankruptTownsPayNationTax()) {
                msg1 = "msg_town_bankrupt_by_nation_tax";
                msg2 = "msg_town_bankrupt_by_nation_tax_multiple";
            }
            if (!localNewlyDelinquentTowns.isEmpty()) {
                if (localNewlyDelinquentTowns.size() == 1) {
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of(msg1, localNewlyDelinquentTowns.get(0), Translation.of("nation_sing")));
                } else {
                    TownyMessaging.sendPrefixedNationMessage(nation, ChatTools.list(localNewlyDelinquentTowns, msg2));
                }
            }
            if (!localTownsDestroyed.isEmpty()) {
                if (localTownsDestroyed.size() == 1) {
                    TownyMessaging.sendNationMessagePrefixed(nation, Translation.of("msg_town_destroyed_by_nation_tax", ChatTools.list(localTownsDestroyed)));
                } else {
                    TownyMessaging.sendNationMessagePrefixed(nation, ChatTools.list(localTownsDestroyed, Translation.of("msg_town_destroyed_by_nation_tax_multiple")));
                }
            }
        }
    }

    public void collectTownTaxes() throws EconomyException {
        ArrayList<Town> towns = new ArrayList<Town>(this.universe.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!this.universe.getDataSource().hasTown(town.getName()) || town.isRuined()) continue;
            this.collectTownTaxes(town);
        }
    }

    protected void collectTownTaxes(Town town) throws EconomyException {
        if (town.getTaxes() > 0.0) {
            ArrayList residents = new ArrayList(town.getResidents());
            ListIterator residentItr = residents.listIterator();
            ArrayList<String> removedResidents = new ArrayList<String>();
            while (residentItr.hasNext()) {
                Resident resident = (Resident)residentItr.next();
                double tax = town.getTaxes();
                if (!this.universe.hasResident(resident.getName())) continue;
                if (TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt") || resident.isNPC() || resident.isMayor()) {
                    try {
                        TownyMessaging.sendResidentMessage(resident, Translation.of("MSG_TAX_EXEMPT"));
                    }
                    catch (TownyException townyException) {}
                    continue;
                }
                if (town.isTaxPercentage()) {
                    tax = resident.getAccount().getHoldingBalance() * tax / 100.0;
                    tax = Math.min(tax, town.getMaxPercentTaxAmount());
                    if (TownySettings.getTownBankCap() != 0.0 && tax + town.getAccount().getHoldingBalance() > TownySettings.getTownBankCap()) {
                        tax = town.getAccount().getBalanceCap() - town.getAccount().getHoldingBalance();
                    }
                    resident.getAccount().payTo(tax, town, "Town Tax (Percentage)");
                    continue;
                }
                if (TownySettings.getTownBankCap() != 0.0 && tax + town.getAccount().getHoldingBalance() > TownySettings.getTownBankCap()) {
                    tax = town.getAccount().getBalanceCap() - town.getAccount().getHoldingBalance();
                }
                if (resident.getAccount().canPayFromHoldings(tax)) {
                    resident.getAccount().payTo(tax, town, "Town tax (FlatRate)");
                    continue;
                }
                removedResidents.add(resident.getName());
                resident.removeTown();
            }
            if (removedResidents != null) {
                if (removedResidents.size() == 1) {
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_couldnt_pay_tax", removedResidents.get(0), "town"));
                } else {
                    TownyMessaging.sendPrefixedTownMessage(town, ChatTools.list(removedResidents, Translation.of("msg_couldnt_pay_town_tax_multiple")));
                }
            }
        }
        if (town.getPlotTax() > 0.0 || town.getCommercialPlotTax() > 0.0 || town.getEmbassyPlotTax() > 0.0) {
            ArrayList<TownBlock> townBlocks = new ArrayList<TownBlock>(town.getTownBlocks());
            ArrayList<String> lostPlots = new ArrayList<String>();
            ListIterator townBlockItr = townBlocks.listIterator();
            while (townBlockItr.hasNext()) {
                TownBlock townBlock = (TownBlock)townBlockItr.next();
                if (!townBlock.hasResident()) continue;
                try {
                    Resident resident = townBlock.getResident();
                    if (!this.universe.hasResident(resident.getName()) || resident.hasTown() && resident.getTown() == townBlock.getTown() && (TownyPerms.getResidentPerms(resident).containsKey("towny.tax_exempt") || resident.isNPC())) continue;
                    double tax = townBlock.getType().getTax(town);
                    if (TownySettings.getTownBankCap() != 0.0 && tax + town.getAccount().getHoldingBalance() > TownySettings.getTownBankCap()) {
                        tax = town.getAccount().getBalanceCap() - town.getAccount().getHoldingBalance();
                    }
                    if (resident.getAccount().payTo(tax, town, String.format("Plot Tax (%s)", new Object[]{townBlock.getType()}))) continue;
                    if (!lostPlots.contains(resident.getName())) {
                        lostPlots.add(resident.getName());
                    }
                    townBlock.setResident(null);
                    townBlock.setPlotPrice(-1.0);
                    townBlock.setType(townBlock.getType());
                    townBlock.save();
                }
                catch (NotRegisteredException notRegisteredException) {}
            }
            if (lostPlots != null) {
                if (lostPlots.size() == 1) {
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_couldnt_pay_plot_taxes", lostPlots.get(0)));
                } else {
                    TownyMessaging.sendPrefixedTownMessage(town, ChatTools.list(lostPlots, Translation.of("msg_couldnt_pay_plot_taxes_multiple")));
                }
            }
        }
    }

    public void collectTownCosts() throws EconomyException {
        ArrayList<Town> towns = new ArrayList<Town>(this.universe.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!this.universe.getDataSource().hasTown(town.getName()) || !town.hasUpkeep() || town.isRuined()) continue;
            double upkeep = TownySettings.getTownUpkeepCost(town);
            double upkeepPenalty = TownySettings.getTownPenaltyUpkeepCost(town);
            if (upkeepPenalty > 0.0 && upkeep > 0.0) {
                upkeep += upkeepPenalty;
            }
            this.totalTownUpkeep += upkeep;
            if (upkeep > 0.0) {
                if (town.getAccount().canPayFromHoldings(upkeep)) {
                    town.getAccount().withdraw(upkeep, "Town Upkeep");
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_your_town_payed_upkeep", TownyEconomyHandler.getFormattedBalance(upkeep)));
                    continue;
                }
                if (!TownySettings.isTownBankruptcyEnabled()) {
                    TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_your_town_couldnt_pay_upkeep", TownyEconomyHandler.getFormattedBalance(upkeep)));
                    this.universe.getDataSource().removeTown(town);
                    this.removedTowns.add(town.getName());
                    continue;
                }
                boolean townWasBankrupt = town.isBankrupt();
                town.getAccount().setDebtCap(MoneyUtil.getEstimatedValueOfTown(town));
                if (town.getAccount().getHoldingBalance() - upkeep < town.getAccount().getDebtCap() * -1.0) {
                    if (TownySettings.isUpkeepDeletingTownsThatReachDebtCap()) {
                        TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_your_town_couldnt_pay_upkeep", TownyEconomyHandler.getFormattedBalance(upkeep)));
                        this.universe.getDataSource().removeTown(town);
                        this.removedTowns.add(town.getName());
                        continue;
                    }
                    upkeep = town.getAccount().getDebtCap() - Math.abs(town.getAccount().getHoldingBalance());
                }
                town.getAccount().withdraw(upkeep, "Town Upkeep");
                TownyMessaging.sendPrefixedTownMessage(town, Translation.of("msg_your_town_payed_upkeep_with_debt", TownyEconomyHandler.getFormattedBalance(upkeep)));
                if (townWasBankrupt) continue;
                town.setOpen(false);
                town.save();
                this.bankruptedTowns.add(town.getName());
                continue;
            }
            if (!(upkeep < 0.0)) continue;
            if (TownySettings.isUpkeepPayingPlots()) {
                ArrayList<TownBlock> plots = new ArrayList<TownBlock>(town.getTownBlocks());
                for (TownBlock townBlock : plots) {
                    if (townBlock.hasResident()) {
                        Resident resident = null;
                        try {
                            resident = townBlock.getResident();
                        }
                        catch (NotRegisteredException notRegisteredException) {
                            // empty catch block
                        }
                        if (resident == null) continue;
                        resident.getAccount().withdraw(upkeep / (double)plots.size(), "Negative Town Upkeep - Plot income");
                        continue;
                    }
                    town.getAccount().withdraw(upkeep / (double)plots.size(), "Negative Town Upkeep - Plot income");
                }
                continue;
            }
            town.getAccount().withdraw(upkeep, "Negative Town Upkeep");
        }
        String msg1 = Translation.of("msg_bankrupt_town2");
        String msg2 = Translation.of("msg_bankrupt_town_multiple");
        if (TownySettings.isTownBankruptcyEnabled() && TownySettings.isUpkeepDeletingTownsThatReachDebtCap()) {
            this.plugin.resetCache();
            msg1 = Translation.of("msg_town_reached_debtcap_and_is_disbanded");
            msg2 = Translation.of("msg_town_reached_debtcap_and_is_disbanded_multiple");
        }
        if (this.bankruptedTowns != null) {
            if (this.bankruptedTowns.size() == 1) {
                TownyMessaging.sendGlobalMessage(String.format(Translation.of("msg_town_bankrupt_by_upkeep"), this.bankruptedTowns.get(0)));
            } else {
                TownyMessaging.sendGlobalMessage(ChatTools.list(this.bankruptedTowns, Translation.of("msg_town_bankrupt_by_upkeep_multiple")));
            }
        }
        if (this.removedTowns != null) {
            if (this.removedTowns.size() == 1) {
                TownyMessaging.sendGlobalMessage(String.format(msg1, this.removedTowns.get(0)));
            } else {
                TownyMessaging.sendGlobalMessage(ChatTools.list(this.removedTowns, msg2));
            }
        }
    }

    public void collectNationCosts() throws EconomyException {
        ArrayList<Nation> nations = new ArrayList<Nation>(this.universe.getNations());
        ListIterator nationItr = nations.listIterator();
        while (nationItr.hasNext()) {
            Nation nation = (Nation)nationItr.next();
            System.out.println("nation UUID " + nation.getUUID());
            System.out.println("hasNation   " + this.universe.hasNation(nation.getUUID()));
            if (!this.universe.hasNation(nation.getUUID()) || !nation.getCapital().hasUpkeep()) continue;
            double upkeep = TownySettings.getNationUpkeepCost(nation);
            this.totalNationUpkeep += upkeep;
            if (upkeep > 0.0) {
                if (nation.getAccount().canPayFromHoldings(upkeep)) {
                    nation.getAccount().withdraw(upkeep, "Nation Upkeep");
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_your_nation_payed_upkeep", TownyEconomyHandler.getFormattedBalance(upkeep)));
                } else {
                    TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_your_nation_couldnt_pay_upkeep", TownyEconomyHandler.getFormattedBalance(upkeep)));
                    this.universe.getDataSource().removeNation(nation);
                    this.removedNations.add(nation.getName());
                }
                if (!nation.isNeutral() || nation.getAccount().withdraw(TownySettings.getNationNeutralityCost(), "Nation Peace Upkeep")) continue;
                nation.setNeutral(false);
                nation.save();
                TownyMessaging.sendPrefixedNationMessage(nation, Translation.of("msg_nation_not_peaceful"));
                continue;
            }
            if (!(upkeep < 0.0)) continue;
            nation.getAccount().withdraw(upkeep, "Negative Nation Upkeep");
        }
        if (this.removedNations != null && !this.removedNations.isEmpty()) {
            if (this.removedNations.size() == 1) {
                TownyMessaging.sendGlobalMessage(Translation.of("msg_bankrupt_nation2", this.removedNations.get(0)));
            } else {
                TownyMessaging.sendGlobalMessage(ChatTools.list(this.removedNations, Translation.of("msg_bankrupt_nation_multiple")));
            }
        }
    }
}

