/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityRegainHealthEvent;

public class HealthRegenTimerTask
extends TownyTimerTask {
    private final Server server;

    public HealthRegenTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
    }

    @Override
    public void run() {
        if (TownyAPI.getInstance().isWarTime()) {
            return;
        }
        for (Player player : this.server.getOnlinePlayers()) {
            if (player.getHealth() <= 0.0 || TownyAPI.getInstance().isWilderness(player.getLocation())) continue;
            try {
                TownBlock townBlock = TownyUniverse.getInstance().getTownBlock(WorldCoord.parseWorldCoord(player.getLocation()));
                Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
                if (resident == null || !resident.hasTown() || !CombatUtil.isAlly(townBlock.getTown(), resident.getTown()) || townBlock.getType().equals((Object)TownBlockType.ARENA)) continue;
                this.incHealth(player);
            }
            catch (TownyException townyException) {}
        }
    }

    public void incHealth(Player player) {
        double maxHP;
        double currentHP;
        if (player.getSaturation() == 0.0f) {
            player.setSaturation(1.0f);
        }
        if ((currentHP = player.getHealth()) < (maxHP = player.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue())) {
            player.setHealth(Math.min(maxHP, currentHP += 1.0));
            Bukkit.getServer().getPluginManager().callEvent((Event)new EntityRegainHealthEvent((Entity)player, currentHP, EntityRegainHealthEvent.RegainReason.REGEN));
        }
    }
}

