/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.MobRemovalEvent;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.tasks.TownyTimerTask;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Rabbit;
import org.bukkit.event.Event;

public class MobRemovalTimerTask
extends TownyTimerTask {
    private final Server server;
    public static List<Class<?>> classesOfWorldMobsToRemove = new ArrayList();
    public static List<Class<?>> classesOfWildernessMobsToRemove = new ArrayList();
    public static List<Class<?>> classesOfTownMobsToRemove = new ArrayList();
    private final boolean isRemovingKillerBunny;

    public MobRemovalTimerTask(Towny plugin, Server server) {
        super(plugin);
        this.server = server;
        classesOfWorldMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWorldMobRemovalEntities(), "WorldMob: ");
        classesOfWildernessMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getWildernessMobRemovalEntities(), "WildernessMob: ");
        classesOfTownMobsToRemove = EntityTypeUtil.parseLivingEntityClassNames(TownySettings.getTownMobRemovalEntities(), "TownMob: ");
        this.isRemovingKillerBunny = TownySettings.isRemovingKillerBunny();
    }

    public static boolean isRemovingWorldEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfWorldMobsToRemove, livingEntity);
    }

    public static boolean isRemovingWildernessEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfWildernessMobsToRemove, livingEntity);
    }

    public static boolean isRemovingTownEntity(LivingEntity livingEntity) {
        return EntityTypeUtil.isInstanceOfAny(classesOfTownMobsToRemove, livingEntity);
    }

    @Override
    public void run() {
        ArrayList<LivingEntity> livingEntitiesToRemove = new ArrayList<LivingEntity>();
        for (World world : this.server.getWorlds()) {
            TownyWorld townyWorld;
            try {
                townyWorld = TownyUniverse.getInstance().getDataSource().getWorld(world.getName());
            }
            catch (NotRegisteredException | NullPointerException e) {
                continue;
            }
            if (!townyWorld.isUsingTowny() || townyWorld.isForceTownMobs() && townyWorld.hasWorldMobs()) continue;
            for (LivingEntity livingEntity : world.getLivingEntities()) {
                Location livingEntityLoc = livingEntity.getLocation();
                if (!world.isChunkLoaded(livingEntityLoc.getBlockX() >> 4, livingEntityLoc.getBlockZ() >> 4) || this.plugin.isCitizens2() && CitizensAPI.getNPCRegistry().isNPC((Entity)livingEntity)) continue;
                if (!townyWorld.hasWorldMobs() && MobRemovalTimerTask.isRemovingWorldEntity(livingEntity)) {
                    livingEntitiesToRemove.add(livingEntity);
                    continue;
                }
                if (TownyAPI.getInstance().isWilderness(livingEntityLoc)) {
                    if (townyWorld.hasWildernessMobs() || !MobRemovalTimerTask.isRemovingWildernessEntity(livingEntity)) continue;
                    livingEntitiesToRemove.add(livingEntity);
                    continue;
                }
                TownBlock townBlock = TownyAPI.getInstance().getTownBlock(livingEntityLoc);
                if (townyWorld.isForceTownMobs() || townBlock.getPermissions().mobs || !MobRemovalTimerTask.isRemovingTownEntity(livingEntity) || TownySettings.isSkippingRemovalOfNamedMobs() && livingEntity.getCustomName() != null) continue;
                if (livingEntity.getType().equals((Object)EntityType.RABBIT) && this.isRemovingKillerBunny && ((Rabbit)livingEntity).getRabbitType().equals((Object)Rabbit.Type.THE_KILLER_BUNNY)) {
                    livingEntitiesToRemove.add(livingEntity);
                    continue;
                }
                livingEntitiesToRemove.add(livingEntity);
            }
        }
        for (LivingEntity livingEntity : livingEntitiesToRemove) {
            MobRemovalEvent mobRemovalEvent = new MobRemovalEvent((Entity)livingEntity);
            this.plugin.getServer().getPluginManager().callEvent((Event)mobRemovalEvent);
            if (mobRemovalEvent.isCancelled()) continue;
            livingEntity.remove();
        }
    }
}

