/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.earth2me.essentials.Essentials;
import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyTimerHandler;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.AlreadyRegisteredException;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.permissions.TownyPerms;
import com.palmergames.bukkit.towny.tasks.GatherResidentUUIDTask;
import com.palmergames.bukkit.towny.tasks.SetDefaultModes;
import com.palmergames.bukkit.towny.war.common.townruin.TownRuinSettings;
import com.palmergames.bukkit.towny.war.common.townruin.TownRuinUtil;
import com.palmergames.bukkit.util.BukkitTools;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class OnPlayerLogin
implements Runnable {
    Towny plugin;
    TownyUniverse universe;
    volatile Player player;

    public OnPlayerLogin(Towny plugin, Player player) {
        this.plugin = plugin;
        this.universe = TownyUniverse.getInstance();
        this.player = player;
    }

    @Override
    public void run() {
        Town town;
        Resident resident = null;
        if (TownyTimerHandler.isGatherResidentUUIDTaskRunning() && this.player.getUniqueId().version() == 3) {
            GatherResidentUUIDTask.markOfflineMode();
        }
        if (!this.universe.hasResident(this.player.getUniqueId())) {
            resident = this.universe.getResident(this.player.getName());
            if (resident != null && !resident.hasUUID()) {
                this.loginExistingResident(resident);
            } else if (resident != null && !resident.getUUID().equals(this.player.getUniqueId())) {
                try {
                    this.universe.unregisterResident(resident);
                    resident.setUUID(this.player.getUniqueId());
                    this.universe.registerResident(resident);
                }
                catch (AlreadyRegisteredException | NotRegisteredException townyException) {
                    // empty catch block
                }
                this.loginExistingResident(resident);
            } else {
                try {
                    this.universe.getDataSource().newResident(this.player.getName(), this.player.getUniqueId());
                    TownySettings.incrementUUIDCount();
                    resident = this.universe.getResident(this.player.getUniqueId());
                    if (TownySettings.isShowingRegistrationMessage()) {
                        TownyMessaging.sendMessage((Object)this.player, Translation.of("msg_registration", this.player.getName()));
                    }
                    resident.setRegistered(System.currentTimeMillis());
                    resident.setLastOnline(System.currentTimeMillis());
                    if (!TownySettings.getDefaultTownName().equals("") && (town = TownyUniverse.getInstance().getTown(TownySettings.getDefaultTownName())) != null) {
                        try {
                            resident.setTown(town);
                            town.save();
                        }
                        catch (AlreadyRegisteredException alreadyRegisteredException) {
                            // empty catch block
                        }
                    }
                    resident.save();
                }
                catch (AlreadyRegisteredException | NotRegisteredException town2) {}
            }
        } else {
            resident = this.universe.getResident(this.player.getUniqueId());
            if (!resident.getName().equals(this.player.getName())) {
                try {
                    this.universe.getDataSource().renamePlayer(resident, this.player.getName());
                }
                catch (AlreadyRegisteredException e) {
                    e.printStackTrace();
                }
                catch (NotRegisteredException e) {
                    e.printStackTrace();
                }
            }
            resident = this.universe.getResident(this.player.getUniqueId());
            this.loginExistingResident(resident);
        }
        if (resident != null) {
            TownyPerms.assignPermissions(resident, this.player);
            if (resident.hasTown()) {
                town = null;
                Nation nation = null;
                try {
                    town = resident.getTown();
                    if (town.hasNation()) {
                        nation = town.getNation();
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
                if (TownySettings.getShowTownBoardOnLogin() && !town.getBoard().isEmpty()) {
                    TownyMessaging.sendTownBoard(this.player, town);
                }
                if (TownySettings.getShowNationBoardOnLogin() && nation != null && !nation.getBoard().isEmpty()) {
                    TownyMessaging.sendNationBoard(this.player, nation);
                }
                if (TownyEconomyHandler.isActive() && TownySettings.isTaxingDaily()) {
                    this.warningMessage(resident, town, nation);
                }
                if (town != null && town.isRuined()) {
                    TownyMessaging.sendMsg(resident, Translation.of("msg_warning_your_town_is_ruined_for_x_more_hours", TownRuinSettings.getTownRuinsMaxDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
                }
            }
            if (TownyAPI.getInstance().isWarTime()) {
                this.universe.getWarEvent().sendScores(this.player, 3);
            }
            if (BukkitTools.scheduleSyncDelayedTask(new SetDefaultModes(this.player.getName(), false), 1L) == -1) {
                TownyMessaging.sendErrorMsg("Could not set default modes for " + this.player.getName() + ".");
            }
        }
    }

    private void loginExistingResident(Resident resident) {
        if (TownySettings.isUsingEssentials()) {
            Essentials ess = (Essentials)Bukkit.getPluginManager().getPlugin("Essentials");
            if (!ess.getUser(this.player).isVanished()) {
                resident.setLastOnline(System.currentTimeMillis());
            }
        } else {
            resident.setLastOnline(System.currentTimeMillis());
        }
        if (!resident.hasUUID()) {
            resident.setUUID(this.player.getUniqueId());
            try {
                TownyUniverse.getInstance().registerResidentUUID(resident);
            }
            catch (AlreadyRegisteredException e) {
                e.printStackTrace();
            }
            TownySettings.incrementUUIDCount();
        }
        resident.save();
    }

    private void warningMessage(Resident resident, Town town, Nation nation) {
        double upkeep;
        if (town.hasUpkeep()) {
            upkeep = TownySettings.getTownUpkeepCost(town);
            try {
                if (upkeep > 0.0 && !town.getAccount().canPayFromHoldings(upkeep)) {
                    if (TownySettings.isTownBankruptcyEnabled()) {
                        if (!town.isBankrupt()) {
                            TownyMessaging.sendMsg(resident, Translation.of("msg_warning_bankrupt", town.getName()));
                        }
                    } else {
                        TownyMessaging.sendMsg(resident, Translation.of("msg_warning_delete", town.getName()));
                    }
                }
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
        if (nation != null) {
            upkeep = TownySettings.getNationUpkeepCost(nation);
            try {
                if (upkeep > 0.0 && !nation.getAccount().canPayFromHoldings(upkeep)) {
                    TownyMessaging.sendMsg(resident, Translation.of("msg_warning_delete", nation.getName()));
                }
            }
            catch (EconomyException economyException) {
                // empty catch block
            }
        }
    }
}

