/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.tasks;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;

public class ResidentPurge
extends Thread {
    final Towny plugin;
    private final CommandSender sender;
    final long deleteTime;
    final boolean townless;

    public ResidentPurge(Towny plugin, CommandSender sender, long deleteTime, boolean townless) {
        this.plugin = plugin;
        this.deleteTime = deleteTime;
        this.setPriority(5);
        this.townless = townless;
        this.sender = sender;
    }

    @Override
    public void run() {
        int count = 0;
        this.message("Scanning for old residents...");
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        for (Resident resident : new ArrayList<Resident>(townyUniverse.getResidents())) {
            if (resident.isNPC() || System.currentTimeMillis() - resident.getLastOnline() <= this.deleteTime || BukkitTools.isOnline(resident.getName()) || this.townless && resident.hasTown()) continue;
            ++count;
            this.message("Deleting resident: " + resident.getName());
            townyUniverse.getDataSource().removeResident(resident);
        }
        this.message("Resident purge complete: " + count + " deleted.");
    }

    private void message(String msg) {
        if (this.sender != null) {
            TownyMessaging.sendMessage((Object)this.sender, msg);
        } else {
            TownyMessaging.sendMsg(msg);
        }
    }
}

