/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.DisallowedPVPEvent;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyWorld;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.utils.EntityTypeUtil;
import com.palmergames.bukkit.towny.war.common.WarZoneConfig;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.projectiles.ProjectileSource;

public class CombatUtil {
    public static boolean preventDamageCall(Towny plugin, Entity attacker, Entity defender) {
        try {
            TownyWorld world = TownyUniverse.getInstance().getDataSource().getWorld(defender.getWorld().getName());
            if (!world.isUsingTowny()) {
                return false;
            }
            Player a = null;
            Player b = null;
            if (attacker instanceof Projectile) {
                Projectile projectile = (Projectile)attacker;
                ProjectileSource source = projectile.getShooter();
                if (source instanceof Entity) {
                    attacker = (Entity)source;
                } else {
                    return false;
                }
            }
            if (attacker instanceof Player) {
                a = (Player)attacker;
            }
            if (defender instanceof Player) {
                b = (Player)defender;
            }
            if (a == b) {
                return false;
            }
            return CombatUtil.preventDamageCall(plugin, world, attacker, defender, a, b);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean preventDamageCall(Towny plugin, TownyWorld world, Entity attackingEntity, Entity defendingEntity, Player attackingPlayer, Player defendingPlayer) throws NotRegisteredException {
        if (!world.isUsingTowny()) {
            return false;
        }
        Coord coord = Coord.parseCoord(defendingEntity);
        TownBlock defenderTB = TownyAPI.getInstance().getTownBlock(defendingEntity.getLocation());
        TownBlock attackerTB = TownyAPI.getInstance().getTownBlock(attackingEntity.getLocation());
        if (attackingPlayer != null) {
            if (defendingPlayer != null || defenderTB != null && defendingEntity instanceof Wolf && ((Wolf)defendingEntity).isTamed() && !((Wolf)defendingEntity).getOwner().equals(attackingEntity)) {
                if (world.isWarZone(coord) && !CombatUtil.preventFriendlyFire(attackingPlayer, defendingPlayer, world)) {
                    return false;
                }
                if (CombatUtil.isPvPPlot(attackingPlayer, defendingPlayer)) {
                    return false;
                }
                if (CombatUtil.preventFriendlyFire(attackingPlayer, defendingPlayer, world) || CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB)) {
                    DisallowedPVPEvent event = new DisallowedPVPEvent(attackingPlayer, defendingPlayer);
                    plugin.getServer().getPluginManager().callEvent((Event)event);
                    return !event.isCancelled();
                }
            } else {
                if (defenderTB != null) {
                    if (defenderTB.getType() == TownBlockType.FARM && TownySettings.getFarmAnimals().contains(defendingEntity.getType().toString())) {
                        return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), Material.WHEAT);
                    }
                    if (EntityTypeUtil.isInstanceOfAny(TownySettings.getProtectedEntityTypes(), defendingEntity)) {
                        return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), Material.DIRT);
                    }
                }
                Material material = null;
                switch (defendingEntity.getType()) {
                    case ITEM_FRAME: 
                    case PAINTING: 
                    case ARMOR_STAND: 
                    case ENDER_CRYSTAL: 
                    case MINECART: 
                    case MINECART_CHEST: 
                    case MINECART_FURNACE: 
                    case MINECART_COMMAND: 
                    case MINECART_HOPPER: {
                        material = EntityTypeUtil.parseEntityToMaterial(defendingEntity.getType());
                        break;
                    }
                }
                if (material != null) {
                    return !TownyActionEventExecutor.canDestroy(attackingPlayer, defendingEntity.getLocation(), material);
                }
            }
        } else if (defendingPlayer != null) {
            if (attackingEntity instanceof Wolf && ((Wolf)attackingEntity).isTamed() && (CombatUtil.preventPvP(world, attackerTB) || CombatUtil.preventPvP(world, defenderTB))) {
                ((Wolf)attackingEntity).setTarget(null);
                return true;
            }
            if (TownyAPI.getInstance().isWarTime() && !WarZoneConfig.isAllowingExplosionsInWarZone() && attackingEntity.getType() == EntityType.PRIMED_TNT) {
                return true;
            }
        } else if (attackingEntity instanceof Projectile) {
            return true;
        }
        return false;
    }

    public static boolean preventPvP(TownyWorld world, TownBlock townBlock) {
        block8: {
            if (townBlock != null) {
                try {
                    if (townBlock.getTown().isAdminDisabledPVP()) {
                        return true;
                    }
                    if (!(townBlock.getPermissions().pvp || townBlock.getTown().isPVP() || world.isForcePVP())) {
                        return true;
                    }
                    if (townBlock.isHomeBlock() && world.isForcePVP() && TownySettings.isForcePvpNotAffectingHomeblocks()) {
                        return true;
                    }
                    break block8;
                }
                catch (NotRegisteredException ex) {
                    if (!CombatUtil.isWorldPvP(world)) {
                        return true;
                    }
                    break block8;
                }
            }
            if (!CombatUtil.isWorldPvP(world)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isWorldPvP(TownyWorld world) {
        return world.isForcePVP() || world.isPVP();
    }

    @Deprecated
    public static boolean preventFriendlyFire(Player attacker, Player defender) {
        TownyWorld world = null;
        try {
            world = TownyUniverse.getInstance().getDataSource().getWorld(attacker.getLocation().getWorld().getName());
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return CombatUtil.preventFriendlyFire(attacker, defender, world);
    }

    public static boolean preventFriendlyFire(Player attacker, Player defender, TownyWorld world) {
        if (attacker == defender) {
            return false;
        }
        if (attacker != null && defender != null && !world.isFriendlyFireEnabled() && CombatUtil.isAlly(attacker.getName(), defender.getName())) {
            try {
                TownBlock townBlock = new WorldCoord(defender.getWorld().getName(), Coord.parseCoord((Entity)defender)).getTownBlock();
                if (!townBlock.getType().equals((Object)TownBlockType.ARENA)) {
                    TownyMessaging.sendErrorMsg((Object)attacker, Translation.of("msg_err_friendly_fire_disable"));
                }
                return true;
            }
            catch (TownyException x) {
                TownyMessaging.sendErrorMsg((Object)attacker, Translation.of("msg_err_friendly_fire_disable"));
                return true;
            }
        }
        return false;
    }

    public static boolean isPvPPlot(Player attacker, Player defender) {
        if (attacker != null && defender != null) {
            try {
                TownBlock attackerTB = new WorldCoord(attacker.getWorld().getName(), Coord.parseCoord((Entity)attacker)).getTownBlock();
                TownBlock defenderTB = new WorldCoord(defender.getWorld().getName(), Coord.parseCoord((Entity)defender)).getTownBlock();
                if (defenderTB.getType().equals((Object)TownBlockType.ARENA) && attackerTB.getType().equals((Object)TownBlockType.ARENA)) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }

    public static boolean isAlly(String attackingResident, String defendingResident) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident residentA = townyUniverse.getResident(attackingResident);
        Resident residentB = townyUniverse.getResident(defendingResident);
        if (residentA == null || residentB == null || !residentA.hasTown() || !residentB.hasTown()) {
            return false;
        }
        try {
            if (residentA.getTown().equals(residentB.getTown())) {
                return true;
            }
            if (residentA.getTown().getNation().equals(residentB.getTown().getNation())) {
                return true;
            }
            if (residentA.getTown().getNation().hasAlly(residentB.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAlly(Town a, Town b) {
        try {
            if (a == b) {
                return true;
            }
            if (a.getNation() == b.getNation()) {
                return true;
            }
            if (a.getNation().hasAlly(b.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isSameNation(Town a, Town b) {
        try {
            if (a == b) {
                return true;
            }
            if (a.getNation() == b.getNation()) {
                return true;
            }
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return false;
    }

    public static boolean isSameTown(Town a, Town b) {
        return a == b;
    }

    public static boolean isSameNation(Resident a, Resident b) {
        if (!a.hasTown() || !b.hasTown()) {
            return false;
        }
        Town townA = null;
        Town townB = null;
        try {
            townA = a.getTown();
            townB = b.getTown();
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return CombatUtil.isSameNation(townA, townB);
    }

    public static boolean isSameTown(Resident a, Resident b) {
        if (!a.hasTown() || !b.hasTown()) {
            return false;
        }
        Town townA = null;
        Town townB = null;
        try {
            townA = a.getTown();
            townB = b.getTown();
        }
        catch (NotRegisteredException e) {
            return false;
        }
        return CombatUtil.isSameTown(townA, townB);
    }

    public static boolean canAttackEnemy(String a, String b) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident residentA = townyUniverse.getResident(a);
        Resident residentB = townyUniverse.getResident(b);
        if (residentA == null || residentB == null || !residentA.hasTown() || !residentB.hasTown()) {
            return false;
        }
        try {
            if (residentA.getTown().equals(residentB.getTown())) {
                return false;
            }
            if (residentA.getTown().getNation().equals(residentB.getTown().getNation())) {
                return false;
            }
            Nation nationA = residentA.getTown().getNation();
            Nation nationB = residentB.getTown().getNation();
            if (nationA.isNeutral() || nationB.isNeutral()) {
                return false;
            }
            if (nationA.hasEnemy(nationB)) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static boolean areAllAllies(List<Nation> possibleAllies) {
        if (possibleAllies.size() <= 1) {
            return true;
        }
        for (int i = 0; i < possibleAllies.size() - 1; ++i) {
            if (possibleAllies.get(i).hasAlly(possibleAllies.get(i + 1))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEnemy(String a, String b) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        Resident residentA = townyUniverse.getResident(a);
        Resident residentB = townyUniverse.getResident(b);
        if (residentA == null || residentB == null || !residentA.hasNation() || !residentB.hasNation()) {
            return false;
        }
        try {
            if (residentA.getTown().equals(residentB.getTown())) {
                return false;
            }
            if (residentA.getTown().getNation().equals(residentB.getTown().getNation())) {
                return false;
            }
            if (residentA.getTown().getNation().hasEnemy(residentB.getTown().getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isEnemy(Town a, Town b) {
        try {
            if (a == b) {
                return false;
            }
            if (a.getNation() == b.getNation()) {
                return false;
            }
            if (a.getNation().hasEnemy(b.getNation())) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isEnemyTownBlock(Player player, WorldCoord worldCoord) {
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        try {
            if (resident != null && resident.hasTown()) {
                return CombatUtil.isEnemy(resident.getTown(), worldCoord.getTownBlock().getTown());
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }
}

