/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownySettings;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Coord;
import com.palmergames.bukkit.towny.object.Nation;
import com.palmergames.bukkit.towny.object.PlayerCache;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import com.palmergames.bukkit.towny.object.TownyPermission;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.object.WorldCoord;
import com.palmergames.bukkit.towny.permissions.PermissionNodes;
import com.palmergames.bukkit.towny.regen.TownyRegenAPI;
import com.palmergames.bukkit.towny.utils.CombatUtil;
import com.palmergames.bukkit.towny.war.eventwar.War;
import net.citizensnpcs.api.CitizensAPI;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class PlayerCacheUtil {
    static Towny plugin = null;

    public static void initialize(Towny plugin) {
        PlayerCacheUtil.plugin = plugin;
    }

    public static PlayerCache getCache(Player player) {
        return plugin.getCache(player);
    }

    public static boolean getCachePermission(Player player, Location location, Material material, TownyPermission.ActionType action) {
        try {
            WorldCoord worldCoord = location.getWorld().equals(player.getWorld()) ? new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location)) : new WorldCoord(location.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("Cache permissions for " + action.toString() + " : " + cache.getCachePermission(material, action));
            return cache.getCachePermission(material, action);
        }
        catch (NullPointerException e) {
            WorldCoord worldCoord = location.getWorld().equals(player.getWorld()) ? new WorldCoord(player.getWorld().getName(), Coord.parseCoord(location)) : new WorldCoord(location.getWorld().getName(), Coord.parseCoord(location));
            PlayerCache.TownBlockStatus status = PlayerCacheUtil.cacheStatus(player, worldCoord, PlayerCacheUtil.getTownBlockStatus(player, worldCoord));
            PlayerCacheUtil.triggerCacheCreate(player, location, worldCoord, status, material, action);
            PlayerCache cache = plugin.getCache(player);
            cache.updateCoord(worldCoord);
            TownyMessaging.sendDebugMsg("New Cache Created and updated!");
            TownyMessaging.sendDebugMsg("New Cache permissions for " + material + ":" + action.toString() + ":" + status.name() + " = " + cache.getCachePermission(material, action));
            return cache.getCachePermission(material, action);
        }
    }

    private static void triggerCacheCreate(Player player, Location location, WorldCoord worldCoord, PlayerCache.TownBlockStatus status, Material material, TownyPermission.ActionType action) {
        switch (action) {
            case BUILD: {
                PlayerCacheUtil.cacheBuild(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
            case DESTROY: {
                PlayerCacheUtil.cacheDestroy(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
            case SWITCH: {
                PlayerCacheUtil.cacheSwitch(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
            case ITEM_USE: {
                PlayerCacheUtil.cacheItemUse(player, worldCoord, material, PlayerCacheUtil.getPermission(player, status, worldCoord, material, action));
                return;
            }
        }
    }

    public static PlayerCache.TownBlockStatus cacheStatus(Player player, WorldCoord worldCoord, PlayerCache.TownBlockStatus townBlockStatus) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setStatus(townBlockStatus);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Status: " + (Object)((Object)townBlockStatus));
        return townBlockStatus;
    }

    private static void cacheBuild(Player player, WorldCoord worldCoord, Material material, Boolean buildRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setBuildPermission(material, buildRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Build: " + buildRight);
    }

    private static void cacheDestroy(Player player, WorldCoord worldCoord, Material material, Boolean destroyRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setDestroyPermission(material, destroyRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Destroy: " + destroyRight);
    }

    private static void cacheSwitch(Player player, WorldCoord worldCoord, Material material, Boolean switchRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setSwitchPermission(material, switchRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Switch: " + switchRight);
    }

    private static void cacheItemUse(Player player, WorldCoord worldCoord, Material material, Boolean itemUseRight) {
        PlayerCache cache = plugin.getCache(player);
        cache.updateCoord(worldCoord);
        cache.setItemUsePermission(material, itemUseRight);
        TownyMessaging.sendDebugMsg(player.getName() + " (" + worldCoord.toString() + ") Cached Item Use: " + itemUseRight);
    }

    public static void cacheBlockErrMsg(Player player, String msg) {
        PlayerCache cache = plugin.getCache(player);
        cache.setBlockErrMsg(msg);
    }

    public static PlayerCache.TownBlockStatus getTownBlockStatus(Player player, WorldCoord worldCoord) {
        try {
            if (!worldCoord.getTownyWorld().isUsingTowny()) {
                return PlayerCache.TownBlockStatus.OFF_WORLD;
            }
        }
        catch (NotRegisteredException ex) {
            return PlayerCache.TownBlockStatus.NOT_REGISTERED;
        }
        if (!worldCoord.hasTownBlock()) {
            if (!(!TownySettings.getNationZonesEnabled() || TownySettings.getNationZonesWarDisables() && TownyAPI.getInstance().isWarTime())) {
                return TownyAPI.getInstance().hasNationZone(worldCoord);
            }
            return PlayerCache.TownBlockStatus.UNCLAIMED_ZONE;
        }
        TownBlock townBlock = null;
        Town town = null;
        try {
            townBlock = worldCoord.getTownBlock();
            town = townBlock.getTown();
            if (townBlock.isLocked()) {
                if (townBlock.getWorld().isUsingPlotManagementRevert() && TownySettings.getPlotManagementSpeed() > 0L) {
                    TownyRegenAPI.addWorldCoord(townBlock.getWorldCoord());
                    return PlayerCache.TownBlockStatus.LOCKED;
                }
                townBlock.setLocked(false);
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
        if (resident == null) {
            if (plugin.isCitizens2()) {
                if (CitizensAPI.getNPCRegistry().isNPC((Entity)player)) {
                    return PlayerCache.TownBlockStatus.NOT_REGISTERED;
                }
            } else {
                System.out.print("[Towny] Failed to fetch resident: " + player.getName());
                return PlayerCache.TownBlockStatus.NOT_REGISTERED;
            }
        }
        try {
            if (TownyAPI.getInstance().isWarTime()) {
                if (TownySettings.isAllowWarBlockGriefing()) {
                    try {
                        if (!resident.getTown().getNation().isNeutral() && !town.getNation().isNeutral() && worldCoord.getTownyWorld().isWarAllowed()) {
                            return PlayerCache.TownBlockStatus.WARZONE;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {
                        // empty catch block
                    }
                }
                if (!TownySettings.isWarTimeTownsNeutral() && !town.hasNation() && worldCoord.getTownyWorld().isWarAllowed()) {
                    return PlayerCache.TownBlockStatus.WARZONE;
                }
            }
            try {
                if (townBlock.getTown().isMayor(resident)) {
                    return PlayerCache.TownBlockStatus.TOWN_OWNER;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
            try {
                Resident owner = townBlock.getResident();
                if (resident == owner) {
                    return PlayerCache.TownBlockStatus.PLOT_OWNER;
                }
                if (owner.hasFriend(resident)) {
                    return PlayerCache.TownBlockStatus.PLOT_FRIEND;
                }
                if (resident.hasTown() && CombatUtil.isSameTown(owner.getTown(), resident.getTown())) {
                    return PlayerCache.TownBlockStatus.PLOT_TOWN;
                }
                if (resident.hasTown() && CombatUtil.isAlly(owner.getTown(), resident.getTown())) {
                    return PlayerCache.TownBlockStatus.PLOT_ALLY;
                }
                throw new TownyException();
            }
            catch (TownyException owner) {
                if (!resident.hasTown()) {
                    if (TownyAPI.getInstance().isWarTime() && townBlock.isWarZone() && !TownySettings.isWarTimeTownsNeutral()) {
                        return PlayerCache.TownBlockStatus.WARZONE;
                    }
                    return PlayerCache.TownBlockStatus.OUTSIDER;
                }
                if (resident.getTown() != town) {
                    if (CombatUtil.isSameNation(town, resident.getTown())) {
                        return PlayerCache.TownBlockStatus.TOWN_NATION;
                    }
                    if (CombatUtil.isAlly(town, resident.getTown())) {
                        return PlayerCache.TownBlockStatus.TOWN_ALLY;
                    }
                    if (CombatUtil.isEnemy(resident.getTown(), town)) {
                        if (TownyAPI.getInstance().isWarTime() && townBlock.isWarZone() || War.isWarZone(townBlock.getWorldCoord())) {
                            return PlayerCache.TownBlockStatus.WARZONE;
                        }
                        return PlayerCache.TownBlockStatus.ENEMY;
                    }
                    return PlayerCache.TownBlockStatus.OUTSIDER;
                }
                if (resident.isMayor()) {
                    return PlayerCache.TownBlockStatus.TOWN_OWNER;
                }
                return PlayerCache.TownBlockStatus.TOWN_RESIDENT;
            }
        }
        catch (TownyException e) {
            return PlayerCache.TownBlockStatus.OUTSIDER;
        }
    }

    private static boolean getPermission(Player player, PlayerCache.TownBlockStatus status, WorldCoord pos, Material material, TownyPermission.ActionType action) {
        Town playersTown;
        Town targetTown;
        TownBlock townBlock;
        TownyUniverse townyUniverse;
        block114: {
            townyUniverse = TownyUniverse.getInstance();
            if (townyUniverse.getPermissionSource().isTownyAdmin(player)) {
                return true;
            }
            townBlock = null;
            targetTown = null;
            if (TownySettings.isTownBankruptcyEnabled() && action == TownyPermission.ActionType.BUILD) {
                try {
                    townBlock = pos.getTownBlock();
                    targetTown = townBlock.getTown();
                    if (targetTown.isBankrupt() && !targetTown.isRuined()) {
                        PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_err_bankrupt_town_cannot_build"));
                        return false;
                    }
                }
                catch (NotRegisteredException notRegisteredException) {
                    // empty catch block
                }
            }
            if (status == PlayerCache.TownBlockStatus.OFF_WORLD || status == PlayerCache.TownBlockStatus.PLOT_OWNER || status == PlayerCache.TownBlockStatus.TOWN_OWNER) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.WARZONE && TownySettings.isAllowWarBlockGriefing()) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.NOT_REGISTERED) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error"));
                return false;
            }
            if (status == PlayerCache.TownBlockStatus.LOCKED) {
                PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_locked"));
                return false;
            }
            playersTown = null;
            try {
                Resident res = townyUniverse.getResident(player.getUniqueId());
                if (res != null && res.hasTown()) {
                    playersTown = res.getTown();
                }
            }
            catch (NotRegisteredException res) {
                // empty catch block
            }
            try {
                if (townBlock == null) {
                    townBlock = pos.getTownBlock();
                }
                if (targetTown == null) {
                    targetTown = townBlock.getTown();
                }
            }
            catch (NotRegisteredException e) {
                try {
                    Nation playersNation;
                    if (status == PlayerCache.TownBlockStatus.UNCLAIMED_ZONE) {
                        if (townyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorld(), player, material, action)) {
                            return true;
                        }
                        PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_wild", Translation.of(action.toString())));
                        return false;
                    }
                    if (!TownySettings.getNationZonesEnabled() || status != PlayerCache.TownBlockStatus.NATION_ZONE) break block114;
                    if (townyUniverse.getPermissionSource().testPermission(player, PermissionNodes.TOWNY_ADMIN_NATION_ZONE.getNode()) && townyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorld(), player, material, action)) {
                        return true;
                    }
                    Town nearestTown = null;
                    nearestTown = pos.getTownyWorld().getClosestTownWithNationFromCoord(pos.getCoord(), nearestTown);
                    Nation nearestNation = nearestTown.getNation();
                    try {
                        playersNation = playersTown.getNation();
                    }
                    catch (Exception e1) {
                        PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("nation_zone_this_area_under_protection_of", pos.getTownyWorld().getUnclaimedZoneName(), nearestNation.getName()));
                        return false;
                    }
                    if (playersNation.equals(nearestNation)) {
                        if (townyUniverse.getPermissionSource().hasWildOverride(pos.getTownyWorld(), player, material, action)) {
                            return true;
                        }
                        PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_wild", Translation.of(action.toString())));
                        return false;
                    }
                    PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("nation_zone_this_area_under_protection_of", pos.getTownyWorld().getUnclaimedZoneName(), nearestNation.getName()));
                    return false;
                }
                catch (NotRegisteredException e2) {
                    TownyMessaging.sendErrorMsg((Object)player, "Error updating " + action.toString() + " permission.");
                    return false;
                }
            }
        }
        if (townBlock.hasResident()) {
            if (targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasOwnTownOverride(player, material, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
                return true;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_FRIEND) {
                if (townBlock.getPermissions().getResidentPerm(action)) {
                    if (townBlock.getType() == TownBlockType.WILDS) {
                        try {
                            if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                                return true;
                            }
                        }
                        catch (NotRegisteredException notRegisteredException) {}
                    } else if (townBlock.getType() == TownBlockType.FARM && (action.equals((Object)TownyPermission.ActionType.BUILD) || action.equals((Object)TownyPermission.ActionType.DESTROY))) {
                        if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_plot", Translation.of("msg_cache_block_error_plot_friends"), Translation.of(action.toString())));
                return false;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_TOWN) {
                if (townBlock.getPermissions().getNationPerm(action)) {
                    if (townBlock.getType() == TownBlockType.WILDS) {
                        try {
                            if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                                return true;
                            }
                        }
                        catch (NotRegisteredException notRegisteredException) {}
                    } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                        if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_plot", Translation.of("msg_cache_block_error_plot_town_members"), Translation.of(action.toString())));
                return false;
            }
            if (status == PlayerCache.TownBlockStatus.PLOT_ALLY) {
                if (townBlock.getPermissions().getAllyPerm(action)) {
                    if (townBlock.getType() == TownBlockType.WILDS) {
                        try {
                            if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                                return true;
                            }
                        }
                        catch (NotRegisteredException notRegisteredException) {}
                    } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                        if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                }
                PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_plot", Translation.of("msg_cache_block_error_plot_allies"), Translation.of(action.toString())));
                return false;
            }
            if (townBlock.getPermissions().getOutsiderPerm(action)) {
                if (townBlock.getType() == TownBlockType.WILDS) {
                    try {
                        if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                            return true;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                    if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_plot", Translation.of("msg_cache_block_error_plot_outsiders"), Translation.of(action.toString())));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_RESIDENT) {
            if (targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasTownOwnedOverride(player, material, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
                return true;
            }
            if (townBlock.getPermissions().getResidentPerm(action)) {
                if (townBlock.getType() == TownBlockType.WILDS) {
                    try {
                        if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                            return true;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                    if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_town_resident", Translation.of(action.toString())));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_NATION) {
            if (targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasOwnTownOverride(player, material, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
                return true;
            }
            if (townBlock.getPermissions().getNationPerm(action)) {
                if (townBlock.getType() == TownBlockType.WILDS) {
                    try {
                        if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                            return true;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                    if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_town_nation", Translation.of(action.toString())));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.TOWN_ALLY) {
            if (targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasOwnTownOverride(player, material, action)) {
                return true;
            }
            if (!targetTown.equals(playersTown) && townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
                return true;
            }
            if (townBlock.getPermissions().getAllyPerm(action)) {
                if (townBlock.getType() == TownBlockType.WILDS) {
                    try {
                        if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                            return true;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                    if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_town_allies", Translation.of(action.toString())));
            return false;
        }
        if (status == PlayerCache.TownBlockStatus.OUTSIDER || status == PlayerCache.TownBlockStatus.ENEMY) {
            if (townyUniverse.getPermissionSource().hasAllTownOverride(player, material, action)) {
                return true;
            }
            if (townBlock.getPermissions().getOutsiderPerm(action)) {
                if (townBlock.getType() == TownBlockType.WILDS) {
                    try {
                        if (townyUniverse.getPermissionSource().unclaimedZoneAction(pos.getTownyWorld(), material, action)) {
                            return true;
                        }
                    }
                    catch (NotRegisteredException notRegisteredException) {}
                } else if (townBlock.getType() == TownBlockType.FARM && (action == TownyPermission.ActionType.BUILD || action == TownyPermission.ActionType.DESTROY)) {
                    if (TownySettings.getFarmPlotBlocks().contains(material.toString())) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            PlayerCacheUtil.cacheBlockErrMsg(player, Translation.of("msg_cache_block_error_town_outsider", Translation.of(action.toString())));
            return false;
        }
        TownyMessaging.sendErrorMsg((Object)player, "Error updating " + action.toString() + " permission.");
        return false;
    }
}

