/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.ResidentList;
import com.palmergames.bukkit.towny.object.TownyInventory;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.util.BukkitTools;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class ResidentUtil {
    public static List<Resident> getOnlineResidentsViewable(Player viewer, ResidentList residentList) {
        ArrayList<Resident> onlineResidents = new ArrayList<Resident>();
        for (Player player : BukkitTools.getOnlinePlayers()) {
            if (player == null) continue;
            for (Resident resident : residentList.getResidents()) {
                if (!resident.getName().equalsIgnoreCase(player.getName()) || viewer != null && !viewer.canSee(BukkitTools.getPlayerExact(resident.getName()))) continue;
                onlineResidents.add(resident);
            }
        }
        return onlineResidents;
    }

    public static List<Resident> getValidatedResidents(Object sender, String[] names) {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Resident> residents = new ArrayList<Resident>();
        for (String name : names) {
            List<Player> matches = BukkitTools.matchPlayer(name);
            if (matches.size() > 1) {
                StringBuilder line = new StringBuilder("Multiple players selected: ");
                for (Player p : matches) {
                    line.append(", ").append(p.getName());
                }
                TownyMessaging.sendErrorMsg(sender, line.toString());
                continue;
            }
            String targetName = !matches.isEmpty() ? matches.get(0).getName() : name;
            Resident target = townyUniverse.getResident(targetName);
            if (target != null) {
                residents.add(target);
                continue;
            }
            TownyMessaging.sendErrorMsg(sender, Translation.of("msg_err_not_registered_1", targetName));
        }
        return residents;
    }

    public static void openGUIInventory(Resident resident, List<String> list, String name) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (String item : list) {
            Material mat = Material.getMaterial((String)item);
            if (mat == null) continue;
            items.add(new ItemStack(mat));
        }
        new TownyInventory(resident, items, name);
    }
}

