/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.utils;

import com.palmergames.bukkit.towny.TownyAPI;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.event.executors.TownyActionEventExecutor;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.TownBlockType;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class ShopPlotUtil {
    public static boolean doesPlayerOwnShopPlot(Player player, Location location) {
        boolean owner = false;
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident != null) {
                owner = TownyAPI.getInstance().getTownBlock(location).getResident().equals(resident);
            }
        }
        catch (NotRegisteredException | NullPointerException e) {
            return false;
        }
        return owner && ShopPlotUtil.isShopPlot(location);
    }

    public static boolean doesPlayerHaveAbilityToEditShopPlot(Player player, Location location) {
        return TownyActionEventExecutor.canBuild(player, location, Material.DIRT) && ShopPlotUtil.isShopPlot(location);
    }

    public static boolean isShopPlot(Location location) {
        if (!TownyAPI.getInstance().isWilderness(location)) {
            TownBlock townblock = TownyAPI.getInstance().getTownBlock(location);
            return ShopPlotUtil.isShopPlot(townblock);
        }
        return false;
    }

    public static boolean isShopPlot(TownBlock townblock) {
        if (townblock != null) {
            return townblock.getType().equals((Object)TownBlockType.COMMERCIAL);
        }
        return false;
    }
}

