/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.towny.war.common.townruin;

import com.palmergames.bukkit.towny.Towny;
import com.palmergames.bukkit.towny.TownyEconomyHandler;
import com.palmergames.bukkit.towny.TownyMessaging;
import com.palmergames.bukkit.towny.TownyUniverse;
import com.palmergames.bukkit.towny.command.TownyAdminCommand;
import com.palmergames.bukkit.towny.event.town.TownReclaimedEvent;
import com.palmergames.bukkit.towny.event.town.TownRuinedEvent;
import com.palmergames.bukkit.towny.exceptions.EconomyException;
import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.exceptions.TownyException;
import com.palmergames.bukkit.towny.object.Resident;
import com.palmergames.bukkit.towny.object.Town;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.Translation;
import com.palmergames.bukkit.towny.war.common.townruin.TownRuinSettings;
import com.palmergames.util.TimeTools;
import java.util.ArrayList;
import java.util.ListIterator;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TownRuinUtil {
    private TownRuinUtil() {
    }

    public static boolean isPlayersTownRuined(Player player) {
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident != null && resident.hasTown() && resident.getTown().isRuined()) {
                return true;
            }
        }
        catch (NotRegisteredException notRegisteredException) {
            // empty catch block
        }
        return false;
    }

    public static void putTownIntoRuinedState(Town town, Towny plugin) {
        if (town.isRuined()) {
            return;
        }
        if (town.hasNation()) {
            town.removeNation();
        }
        TownRuinUtil.setMayor(plugin, town, "npc");
        TownRuinedEvent event = new TownRuinedEvent(town);
        Bukkit.getPluginManager().callEvent((Event)event);
        town.setRuined(true);
        town.setRuinedTime(System.currentTimeMillis());
        town.setPublic(false);
        town.setOpen(false);
        town.getPermissions().setAll(true);
        for (TownBlock townBlock : town.getTownBlocks()) {
            townBlock.getPermissions().setAll(true);
            townBlock.setType(0);
            townBlock.setPlotPrice(-1.0);
            townBlock.setResident(null);
            townBlock.removePlotObjectGroup();
            townBlock.save();
        }
        town.save();
        plugin.resetCache();
    }

    public static void processRuinedTownReclaimRequest(Player player, Towny plugin) {
        try {
            Resident resident = TownyUniverse.getInstance().getResident(player.getUniqueId());
            if (resident == null || !resident.hasTown()) {
                throw new TownyException(Translation.of("msg_err_dont_belong_town"));
            }
            Town town = resident.getTown();
            if (!town.isRuined()) {
                throw new TownyException(Translation.of("msg_err_cannot_reclaim_town_unless_ruined"));
            }
            double townReclaimCost = TownRuinSettings.getEcoPriceReclaimTown();
            if (TownyEconomyHandler.isActive() && !resident.getAccount().canPayFromHoldings(townReclaimCost)) {
                throw new TownyException(Translation.of("msg_err_no_money"));
            }
            if (TownRuinSettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town) > 0) {
                throw new TownyException(Translation.of("msg_err_cannot_reclaim_town_yet", TownRuinSettings.getTownRuinsMinDurationHours() - TownRuinUtil.getTimeSinceRuining(town)));
            }
            resident.getAccount().withdraw(townReclaimCost, "Cost of town reclaim.");
            town.setRuined(false);
            town.setRuinedTime(0L);
            TownRuinUtil.setMayor(plugin, town, resident.getName());
            town.getPermissions().loadDefault(town);
            for (TownBlock townBlock : town.getTownBlocks()) {
                townBlock.getPermissions().loadDefault(town);
                townBlock.setChanged(false);
                townBlock.save();
            }
            town.save();
            plugin.resetCache();
            TownReclaimedEvent event = new TownReclaimedEvent(town, resident);
            Bukkit.getPluginManager().callEvent((Event)event);
            TownyMessaging.sendGlobalMessage(Translation.of("msg_town_reclaimed", resident.getName(), town.getName()));
        }
        catch (EconomyException | TownyException e) {
            TownyMessaging.sendErrorMsg((Object)player, e.getMessage());
        }
    }

    private static void setMayor(Towny plugin, Town town, String name) {
        try {
            TownyAdminCommand adminCommand = new TownyAdminCommand(plugin);
            adminCommand.adminSet(new String[]{"mayor", town.getName(), name});
        }
        catch (TownyException e) {
            e.printStackTrace();
        }
    }

    public static void evaluateRuinedTownRemovals() {
        TownyUniverse townyUniverse = TownyUniverse.getInstance();
        ArrayList<Town> towns = new ArrayList<Town>(townyUniverse.getDataSource().getTowns());
        ListIterator townItr = towns.listIterator();
        while (townItr.hasNext()) {
            Town town = (Town)townItr.next();
            if (!townyUniverse.getDataSource().hasTown(town.getName()) || !town.isRuined() || town.getRuinedTime() == 0L || TownRuinUtil.getTimeSinceRuining(town) <= TownRuinSettings.getTownRuinsMaxDurationHours()) continue;
            townyUniverse.getDataSource().removeTown(town, false);
        }
    }

    public static int getTimeSinceRuining(Town town) {
        return TimeTools.getHours(System.currentTimeMillis() - town.getRuinedTime());
    }
}

