/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import com.palmergames.bukkit.towny.exceptions.NotRegisteredException;
import com.palmergames.bukkit.towny.object.TownBlock;
import com.palmergames.bukkit.towny.object.WorldCoord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class BlockUtil {
    public static List<BlockFace> CARDINAL_BLOCKFACES = new ArrayList<BlockFace>(Arrays.asList(BlockFace.EAST, BlockFace.NORTH, BlockFace.SOUTH, BlockFace.WEST));

    public static boolean sameOwner(Block b1, Block b2) {
        WorldCoord wc = WorldCoord.parseWorldCoord(b1);
        WorldCoord wc2 = WorldCoord.parseWorldCoord(b2);
        if (wc.getCoord().equals(wc2.getCoord()) || !wc.hasTownBlock() && !wc2.hasTownBlock()) {
            return true;
        }
        if (wc.hasTownBlock() && wc2.hasTownBlock()) {
            TownBlock tb = null;
            TownBlock tb2 = null;
            try {
                tb = wc.getTownBlock();
                tb2 = wc2.getTownBlock();
                if (tb.hasResident() != tb2.hasResident()) {
                    return false;
                }
                if (!tb.hasResident() && !tb2.hasResident() && tb.getTown().getUUID().equals(tb2.getTown().getUUID())) {
                    return true;
                }
                if (tb.hasResident() && tb2.hasResident() && tb.getResident().getName().equals(tb2.getResident().getName())) {
                    return true;
                }
            }
            catch (NotRegisteredException notRegisteredException) {
                // empty catch block
            }
        }
        return false;
    }
}

