/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.bukkit.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ChatTools {
    public static List<String> listArr(String[] args, String prefix) {
        return ChatTools.list(Arrays.asList(args), prefix);
    }

    public static List<String> list(List<String> args) {
        return ChatTools.list(args, "");
    }

    public static List<String> list(List<String> args, String prefix) {
        if (args.size() > 0) {
            ArrayList<String> out = new ArrayList<String>();
            out.add(prefix + String.join((CharSequence)", ", args));
            return out;
        }
        return new ArrayList<String>();
    }

    public static String stripColour(String s) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            String c = s.substring(i, i + 1);
            if (c.equals("\u00a7")) {
                ++i;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String formatTitle(String title) {
        String line = ".oOo.__________________________________________________.oOo.";
        int pivot = line.length() / 2;
        String center = ".[ \u00a7e" + title + "\u00a76" + " ].";
        String out = "\u00a76" + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    public static String formatSubTitle(String title) {
        String line = " .]|[.                                                                     .]|[.";
        int pivot = line.length() / 2;
        String center = title + "\u00a76";
        String out = "\u00a76" + line.substring(0, Math.max(0, pivot - center.length() / 2));
        out = out + center + line.substring(pivot + center.length() / 2);
        return out;
    }

    public static String formatCommand(String command, String subCommand, String help) {
        return ChatTools.formatCommand("", command, subCommand, help);
    }

    public static String formatCommand(String requirement, String command, String subCommand, String help) {
        String out = "  ";
        if (requirement.length() > 0) {
            out = out + "\u00a7c" + requirement + ": ";
        }
        out = out + "\u00a73" + command;
        if (subCommand.length() > 0) {
            out = out + " \u00a7b" + subCommand;
        }
        if (help.length() > 0) {
            out = out + " \u00a77 : " + help;
        }
        return out;
    }

    public static String[] formatList(String title, String subject, List<String> list, String page) {
        ArrayList<String> output = new ArrayList<String>();
        output.add(0, ChatTools.formatTitle(title));
        output.add(1, subject);
        output.addAll(list);
        output.add(page);
        return output.toArray(new String[0]);
    }
}

