/*
 * Decompiled with CFR 0.152.
 */
package com.palmergames.util;

import com.palmergames.bukkit.towny.object.Translation;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;

public class TimeMgmt {
    public static final double ONE_SECOND_IN_MILLIS = 1000.0;
    public static final double ONE_MINUTE_IN_MILLIS = 60000.0;
    public static final double ONE_HOUR_IN_MILLIS = 3600000.0;
    public static final double ONE_DAY_IN_MILLIS = 8.64E7;
    public static final long[][] defaultCountdownDelays = new long[][]{{10L, 1L}, {30L, 5L}, {60L, 10L}, {300L, 60L}, {1800L, 300L}, {3600L, 600L}, {86400L, 3600L}, {Integer.MAX_VALUE, 86400L}};

    public static List<Long> getCountdownDelays(int start) {
        return TimeMgmt.getCountdownDelays(start, defaultCountdownDelays);
    }

    public static List<Long> getCountdownDelays(int start, long[][] delays) {
        ArrayList<Long> out = new ArrayList<Long>();
        for (long[] delay : delays) {
            if (delay.length == 2) continue;
            return null;
        }
        Integer lastDelayIndex = null;
        long nextWarningAt = Integer.MAX_VALUE;
        block1: for (long t = (long)start; t > 0L; --t) {
            for (int d = 0; d < delays.length; ++d) {
                if (t > delays[d][0] || lastDelayIndex != null && t > nextWarningAt && d >= lastDelayIndex) continue;
                lastDelayIndex = d;
                nextWarningAt = t - delays[d][1];
                out.add(t);
                continue block1;
            }
        }
        return out;
    }

    public static String formatCountdownTime(long l) {
        String out = "";
        if (l >= 3600L) {
            int h = (int)((double)l / 3600.0);
            out = h + Translation.of("msg_hours");
            l -= (long)(h * 3600);
        }
        if (l >= 60L) {
            int m = (int)((double)l / 60.0);
            out = out + (out.length() > 0 ? ", " : "") + m + Translation.of("msg_minutes");
            l -= (long)(m * 60);
        }
        if (out.length() == 0 || l > 0L) {
            out = out + (out.length() > 0 ? ", " : "") + l + Translation.of("msg_seconds");
        }
        return out;
    }

    public static String getFormattedTimeValue(double timeMillis) {
        if (timeMillis > 0.0) {
            double timeUtilCompletion;
            String timeUnit;
            NumberFormat numberFormat = NumberFormat.getInstance();
            if (timeMillis / 8.64E7 > 1.0) {
                numberFormat.setMaximumFractionDigits(1);
                timeUnit = Translation.of("msg_days");
                timeUtilCompletion = timeMillis / 8.64E7;
            } else if (timeMillis / 3600000.0 > 1.0) {
                numberFormat.setMaximumFractionDigits(1);
                timeUnit = Translation.of("msg_hours");
                timeUtilCompletion = timeMillis / 3600000.0;
            } else if (timeMillis / 60000.0 > 1.0) {
                numberFormat.setMaximumFractionDigits(1);
                timeUnit = Translation.of("msg_minutes");
                timeUtilCompletion = timeMillis / 60000.0;
            } else {
                numberFormat.setMaximumFractionDigits(0);
                timeUnit = Translation.of("msg_seconds");
                timeUtilCompletion = timeMillis / 1000.0;
            }
            double timeRoundedUp = Math.ceil(timeUtilCompletion * 10.0) / 10.0;
            return numberFormat.format(timeRoundedUp) + timeUnit;
        }
        return "0" + Translation.of("msg_seconds");
    }
}

