/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Challenges;

import com.github.Viduality.VSkyblock.Challenges.Challenge;
import com.github.Viduality.VSkyblock.Challenges.ChallengesManager;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.SpecialItemsConnector;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class ChallengesCreator {
    private final VSkyblock plugin;

    public ChallengesCreator(VSkyblock plugin) {
        this.plugin = plugin;
    }

    public boolean createAllChallenges() {
        return this.createChallenges(Challenge.Difficulty.EASY) && this.createChallenges(Challenge.Difficulty.MEDIUM) && this.createChallenges(Challenge.Difficulty.HARD);
    }

    public boolean createChallenges(Challenge.Difficulty diff) {
        String difficulty = this.getDifficulty(diff);
        int highestSlot = 0;
        if (difficulty != null) {
            Set challenges = ConfigShorts.getChallengesConfig().getConfigurationSection(difficulty).getKeys(false);
            HashMap<Integer, Challenge> slotsEasy = new HashMap<Integer, Challenge>();
            HashMap<Integer, Challenge> slotsMedium = new HashMap<Integer, Challenge>();
            HashMap<Integer, Challenge> slotsHard = new HashMap<Integer, Challenge>();
            for (String currentChallenge : challenges) {
                Challenge challenge = new Challenge();
                String challengeName = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".Name");
                String challengeType = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".Type");
                String shownItem = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".ShownItem");
                String description = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".Description");
                int slot = ConfigShorts.getChallengesConfig().getInt(difficulty + "." + currentChallenge + ".Slot");
                int radius = ConfigShorts.getChallengesConfig().getInt(difficulty + "." + currentChallenge + ".Radius");
                String neededText = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".NeededText");
                String rewardText = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".RewardText");
                String repeatRewardText = ConfigShorts.getChallengesConfig().getString(difficulty + "." + currentChallenge + ".RepeatRewardText");
                List neededItems = ConfigShorts.getChallengesConfig().getStringList(difficulty + "." + currentChallenge + ".Needed");
                int neededLevel = ConfigShorts.getChallengesConfig().getInt(difficulty + "." + currentChallenge + ".Needed");
                List rewards = ConfigShorts.getChallengesConfig().getStringList(difficulty + "." + currentChallenge + ".Reward");
                List repeatRewards = ConfigShorts.getChallengesConfig().getStringList(difficulty + "." + currentChallenge + ".RepeatReward");
                if (challengeType != null) {
                    challenge.setChallengeType(this.getChallengeType(challengeType));
                }
                if (shownItem != null && this.isMaterial(shownItem)) {
                    challenge.setShownItem(Material.getMaterial((String)shownItem.toUpperCase()));
                }
                challenge.setChallengeName(challengeName);
                challenge.setMySQLKey(currentChallenge);
                challenge.setDifficulty(diff);
                challenge.setDescription(description);
                challenge.setSlot(slot);
                challenge.setRadius(radius);
                challenge.setNeededText(neededText);
                challenge.setRewardText(rewardText);
                challenge.setRepeatRewardText(repeatRewardText);
                challenge.setNeededLevel(neededLevel);
                challenge.setNeededItems(this.createItems(neededItems));
                challenge.setRewards(this.createItems(rewards));
                challenge.setRepeatRewards(this.createItems(repeatRewards));
                if (this.isChallengeValid(challenge)) {
                    if (!ChallengesManager.challenges.containsKey(challenge.getMySQLKey())) {
                        ChallengesManager.challenges.put(challenge.getMySQLKey(), challenge);
                        switch (diff) {
                            case EASY: {
                                if (slotsEasy.get(challenge.getSlot()) != null) {
                                    while (slotsEasy.get(challenge.getSlot()) != null) {
                                        challenge.setSlot(challenge.getSlot() + 1);
                                    }
                                }
                                ChallengesManager.challengesEasy.put(challengeName, challenge);
                                slotsEasy.put(challenge.getSlot(), challenge);
                                if (challenge.getSlot() <= highestSlot) break;
                                highestSlot = challenge.getSlot();
                                break;
                            }
                            case MEDIUM: {
                                if (slotsMedium.get(challenge.getSlot()) != null) {
                                    while (slotsMedium.get(challenge.getSlot()) != null) {
                                        challenge.setSlot(challenge.getSlot() + 1);
                                    }
                                }
                                ChallengesManager.challengesMedium.put(challengeName, challenge);
                                slotsMedium.put(challenge.getSlot(), challenge);
                                if (challenge.getSlot() <= highestSlot) break;
                                highestSlot = challenge.getSlot();
                                break;
                            }
                            case HARD: {
                                if (slotsHard.get(challenge.getSlot()) != null) {
                                    while (slotsHard.get(challenge.getSlot()) != null) {
                                        challenge.setSlot(challenge.getSlot() + 1);
                                    }
                                }
                                ChallengesManager.challengesHard.put(challengeName, challenge);
                                slotsHard.put(challenge.getSlot(), challenge);
                                if (challenge.getSlot() <= highestSlot) break;
                                highestSlot = challenge.getSlot();
                            }
                        }
                        continue;
                    }
                    this.plugin.getLogger().severe("There is already a challenge with the name " + challengeName + " defined!");
                    continue;
                }
                this.plugin.getLogger().severe("Challenge not valid! Could not set challenge properly! Please check your Challenges file! Challenge: " + challengeName);
            }
        }
        return this.sortChallenges(diff, highestSlot);
    }

    private boolean sortChallenges(Challenge.Difficulty difficulty, int highestSlot) {
        boolean b;
        Map<String, Challenge> challengeHashMap;
        switch (difficulty) {
            case EASY: {
                challengeHashMap = ChallengesManager.challengesEasy;
                break;
            }
            case MEDIUM: {
                challengeHashMap = ChallengesManager.challengesMedium;
                break;
            }
            case HARD: {
                challengeHashMap = ChallengesManager.challengesHard;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + (Object)((Object)difficulty) + " while sorting challenges!");
            }
        }
        List<Challenge> sortedChallenges = Arrays.asList(new Challenge[highestSlot]);
        for (Challenge c : challengeHashMap.values()) {
            sortedChallenges.set(c.getSlot() - 1, c);
        }
        switch (difficulty) {
            case EASY: {
                ChallengesManager.sortedChallengesEasy = sortedChallenges;
                b = true;
                break;
            }
            case MEDIUM: {
                ChallengesManager.sortedChallengesMedium = sortedChallenges;
                b = true;
                break;
            }
            case HARD: {
                ChallengesManager.sortedChallengesHard = sortedChallenges;
                b = true;
                break;
            }
            default: {
                b = false;
            }
        }
        return b;
    }

    private String getDifficulty(Challenge.Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return "Easy";
            }
            case MEDIUM: {
                return "Medium";
            }
            case HARD: {
                return "Hard";
            }
        }
        return null;
    }

    private Challenge.ChallengeType getChallengeType(String challengeType) {
        switch (challengeType.toUpperCase()) {
            case "ONPLAYER": {
                return Challenge.ChallengeType.onPlayer;
            }
            case "ONISLAND": {
                return Challenge.ChallengeType.onIsland;
            }
            case "ISLANDLEVEL": {
                return Challenge.ChallengeType.islandLevel;
            }
        }
        return null;
    }

    private List<ItemStack> createItems(List<String> items) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        for (String currentItem : items) {
            if (currentItem.contains(";")) {
                String[] current = currentItem.split(";");
                if (current.length != 2) {
                    return null;
                }
                if (Material.matchMaterial((String)current[0].toUpperCase()) != null) {
                    if (this.isInt(current[1])) {
                        ItemStack itemStack = new ItemStack(Material.getMaterial((String)current[0].toUpperCase()), Integer.parseInt(current[1]));
                        itemStacks.add(itemStack);
                        continue;
                    }
                    return null;
                }
                if (current[0].contains("SpecialItem:")) {
                    if (this.plugin.getServer().getPluginManager().getPlugin("VSpecialItems") != null) {
                        String specialItem = current[0];
                        String[] specialItemString = specialItem.split(":");
                        if (SpecialItemsConnector.getItem(specialItemString[1]) != null) {
                            itemStacks.add(SpecialItemsConnector.getItem(specialItemString[1]));
                            continue;
                        }
                        return null;
                    }
                    System.out.println("Could not find VSpecialItems plugin! Please install it to use special items in challenges!");
                    return null;
                }
                return null;
            }
            if (Material.matchMaterial((String)currentItem.toUpperCase()) != null) {
                ItemStack itemStack = new ItemStack(Material.getMaterial((String)currentItem.toUpperCase()), 1);
                itemStacks.add(itemStack);
                continue;
            }
            if (currentItem.contains("SpecialItem:")) {
                if (this.plugin.getServer().getPluginManager().getPlugin("VSpecialItems") != null) {
                    String[] specialItemString = currentItem.split(":");
                    if (SpecialItemsConnector.getItem(specialItemString[1]) != null) {
                        itemStacks.add(SpecialItemsConnector.getItem(specialItemString[1]));
                        continue;
                    }
                    return null;
                }
                System.out.println("Could not find VSpecialItems plugin! Please install it to use special items in challenges!");
                return null;
            }
            return null;
        }
        return itemStacks;
    }

    private boolean isMaterial(String material) {
        return Material.matchMaterial((String)material.toUpperCase()) != null;
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private boolean isChallengeValid(Challenge challenge) {
        if (challenge.getChallengeName() != null && challenge.getMySQLKey() != null && challenge.getChallengeType() != null && challenge.getDescription() != null && challenge.getDifficulty() != null && challenge.getShownItem() != null && challenge.getNeededText() != null && challenge.getRewardText() != null && challenge.getSlot() != null && challenge.getRewards() != null) {
            switch (challenge.getChallengeType()) {
                case islandLevel: {
                    if (challenge.getNeededLevel() != null) {
                        return true;
                    }
                }
                case onIsland: {
                    if (challenge.getNeededItems() != null && challenge.getRadius() != null) {
                        return true;
                    }
                }
                case onPlayer: {
                    if (challenge.getNeededItems() == null || challenge.getRepeatRewards() == null || challenge.getRepeatRewardText() == null) break;
                    return true;
                }
            }
            return false;
        }
        return false;
    }
}

