/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Challenges;

import com.github.Viduality.VSkyblock.Challenges.Challenge;
import com.github.Viduality.VSkyblock.Challenges.ChallengesManager;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ChallengesInventoryCreator {
    public static final NamespacedKey CHALLENGE_KEY = new NamespacedKey((Plugin)VSkyblock.getInstance(), "challengeid");
    private final VSkyblock plugin;
    public static final String descriptioncolor = ConfigShorts.getChallengesConfig().getString("ItemOverlay.DescriptionColor");
    private final String challengeNameColor = ConfigShorts.getChallengesConfig().getString("ItemOverlay.ChallengeNameColor");
    private final String notRepeatable = ConfigShorts.getChallengesConfig().getString("ItemOverlay.NotRepeatable");
    private final String completed = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Completed");
    private final String track = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Track");
    private final String untrack = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Untrack");
    public static final String loreString = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Lore");
    public static final String neededonPlayer = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Needed.onPlayer");
    public static final String neededonIsland = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Needed.onIsland");
    public static final String neededislandlevel = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Needed.islandlevel");
    private final String reward = ConfigShorts.getChallengesConfig().getString("ItemOverlay.Reward");
    private final String mineasycomp = ConfigShorts.getChallengesConfig().getString("CompletedChallenges.MinEasyCompleted");
    private final String minmediumcomp = ConfigShorts.getChallengesConfig().getString("CompletedChallenges.MinMediumCompleted");

    public ChallengesInventoryCreator(VSkyblock plugin) {
        this.plugin = plugin;
    }

    public void createChallenges(Player player, Challenge.Difficulty difficulty, int site) {
        this.plugin.getDb().getReader().getislandidfromplayer(player.getUniqueId(), islandid -> this.plugin.getDb().getReader().getIslandChallenges(islandid, islandChallenges -> {
            Inventory cinv = Bukkit.createInventory(null, (int)27, (String)("Challenges " + ConfigShorts.getChallengesConfig().getString("Difficulty." + this.getDifficulty(difficulty))));
            if (this.getChallenges(difficulty) != null && !this.getChallenges(difficulty).isEmpty()) {
                int completedchallenges = 0;
                int slotrange = (site - 1) * 18 + 1;
                for (Challenge challenge : this.getChallenges(difficulty).values()) {
                    if (islandChallenges.getChallengeCount(challenge.getMySQLKey()) <= 0) continue;
                    ++completedchallenges;
                }
                for (int i = slotrange; i <= slotrange + 17; ++i) {
                    Challenge c = this.getChallenge(difficulty, i);
                    if (c == null) continue;
                    cinv.setItem(c.getInventorySlot().intValue(), this.createChallengeItem(c, islandChallenges.getChallengeCount(c.getMySQLKey()), islandChallenges.getTrackedChallenges().contains(c.getMySQLKey())));
                }
                int mineasycompleted = 5;
                int minmediumcompleted = 5;
                if (this.mineasycomp != null && this.isInt(this.mineasycomp)) {
                    mineasycompleted = Integer.parseInt(this.mineasycomp);
                }
                if (this.minmediumcomp != null && this.isInt(this.minmediumcomp)) {
                    minmediumcompleted = Integer.parseInt(this.minmediumcomp);
                }
                if (!difficulty.equals((Object)Challenge.Difficulty.HARD)) {
                    ItemStack nextDifficulty = new ItemStack(Material.LIME_WOOL, 1);
                    ItemMeta nextDifficultyMeta = nextDifficulty.getItemMeta();
                    if (difficulty.equals((Object)Challenge.Difficulty.EASY)) {
                        if (completedchallenges >= mineasycompleted) {
                            nextDifficultyMeta.setDisplayName(ChatColor.GREEN + ConfigShorts.getChallengesConfig().getString("Difficulty.Medium"));
                            nextDifficultyMeta.addEnchant(Enchantment.WATER_WORKER, 1, true);
                            nextDifficultyMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        } else {
                            nextDifficulty.setType(Material.BARRIER);
                            nextDifficultyMeta.setDisplayName(ChatColor.RED + ConfigShorts.getChallengesConfig().getString("CompletedChallenges.MinEasyCompleted"));
                        }
                    } else if (difficulty.equals((Object)Challenge.Difficulty.MEDIUM)) {
                        if (completedchallenges >= minmediumcompleted) {
                            nextDifficultyMeta.setDisplayName(ChatColor.GREEN + ConfigShorts.getChallengesConfig().getString("Difficulty.Hard"));
                            nextDifficultyMeta.addEnchant(Enchantment.WATER_WORKER, 1, true);
                            nextDifficultyMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                        } else {
                            nextDifficulty.setType(Material.BARRIER);
                            nextDifficultyMeta.setDisplayName(ChatColor.RED + ConfigShorts.getChallengesConfig().getString("CompletedChallenges.MinMediumCompleted"));
                        }
                    }
                    nextDifficulty.setItemMeta(nextDifficultyMeta);
                    cinv.setItem(26, nextDifficulty);
                }
                if (!difficulty.equals((Object)Challenge.Difficulty.EASY)) {
                    ItemStack previousDifficulty = new ItemStack(Material.RED_WOOL, 1);
                    ItemMeta previousDifficultyMeta = previousDifficulty.getItemMeta();
                    if (difficulty.equals((Object)Challenge.Difficulty.MEDIUM)) {
                        previousDifficultyMeta.setDisplayName(ChatColor.RED + ConfigShorts.getChallengesConfig().getString("Difficulty.Easy"));
                    } else if (difficulty.equals((Object)Challenge.Difficulty.HARD)) {
                        previousDifficultyMeta.setDisplayName(ChatColor.RED + ConfigShorts.getChallengesConfig().getString("Difficulty.Medium"));
                    }
                    previousDifficultyMeta.addEnchant(Enchantment.WATER_WORKER, 1, true);
                    previousDifficultyMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    previousDifficulty.setItemMeta(previousDifficultyMeta);
                    cinv.setItem(18, previousDifficulty);
                }
                ItemStack currentSite = new ItemStack(Material.PAPER, site);
                ItemMeta currentSiteMeta = currentSite.getItemMeta();
                currentSiteMeta.setDisplayName(ChatColor.GOLD + ConfigShorts.getChallengesConfig().getString("Sites.CurrentSite") + site);
                currentSite.setItemMeta(currentSiteMeta);
                cinv.setItem(22, currentSite);
                if (this.getChallengeListSize(difficulty) >= slotrange + 18) {
                    ItemStack nextSite = new ItemStack(Material.ARROW, 1);
                    ItemMeta nextSiteMeta = nextSite.getItemMeta();
                    nextSiteMeta.setDisplayName(ChatColor.GOLD + ConfigShorts.getChallengesConfig().getString("Sites.NextSite"));
                    nextSiteMeta.addEnchant(Enchantment.WATER_WORKER, 1, true);
                    nextSiteMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    nextSite.setItemMeta(nextSiteMeta);
                    cinv.setItem(23, nextSite);
                }
                if (site > 1) {
                    ItemStack previousSite = new ItemStack(Material.ARROW, 1);
                    ItemMeta previousSiteMeta = previousSite.getItemMeta();
                    previousSiteMeta.setDisplayName(ChatColor.GOLD + ConfigShorts.getChallengesConfig().getString("Sites.PreviousSite"));
                    previousSiteMeta.addEnchant(Enchantment.WATER_WORKER, 1, true);
                    previousSiteMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                    previousSite.setItemMeta(previousSiteMeta);
                    cinv.setItem(21, previousSite);
                }
                player.openInventory(cinv);
            }
        }));
    }

    private Challenge getChallenge(Challenge.Difficulty difficulty, int slot) {
        int slot1 = slot - 1;
        switch (difficulty) {
            case EASY: {
                if (ChallengesManager.sortedChallengesEasy.size() < slot) break;
                return ChallengesManager.sortedChallengesEasy.get(slot1);
            }
            case MEDIUM: {
                if (ChallengesManager.sortedChallengesMedium.size() < slot) break;
                return ChallengesManager.sortedChallengesMedium.get(slot1);
            }
            case HARD: {
                if (ChallengesManager.sortedChallengesHard.size() < slot) break;
                return ChallengesManager.sortedChallengesHard.get(slot1);
            }
        }
        return null;
    }

    public ItemStack createChallengeItem(Challenge challenge, int challengeCount, boolean isTracked) {
        String challengeName = this.challengeNameColor + challenge.getChallengeName();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(loreString);
        lore.addAll(this.splitString(challenge.getDescription(), descriptioncolor));
        switch (challenge.getChallengeType()) {
            case onPlayer: {
                lore.add(neededonPlayer);
                break;
            }
            case onIsland: {
                lore.add(neededonIsland);
                break;
            }
            case islandLevel: {
                lore.add(neededislandlevel);
            }
        }
        lore.addAll(this.splitString(challenge.getNeededText(), descriptioncolor));
        lore.add(this.reward);
        if (challenge.getChallengeType().equals((Object)Challenge.ChallengeType.onPlayer)) {
            if (challengeCount != 0) {
                lore.addAll(this.splitString(challenge.getRepeatRewardText(), descriptioncolor));
            } else {
                lore.addAll(this.splitString(challenge.getRewardText(), descriptioncolor));
            }
        } else {
            lore.addAll(this.splitString(challenge.getRewardText(), descriptioncolor));
        }
        if (challenge.getChallengeType().equals((Object)Challenge.ChallengeType.onIsland) || challenge.getChallengeType().equals((Object)Challenge.ChallengeType.islandLevel)) {
            if (challengeCount != 0) {
                lore.add("");
                lore.add(ChatColor.DARK_RED + this.notRepeatable);
            } else if (isTracked) {
                lore.add(this.untrack);
            } else {
                lore.add(this.track);
            }
        } else {
            lore.add("");
            lore.add(this.completed.replace("%amount%", ChatColor.GREEN + Integer.toString(challengeCount)));
            if (isTracked) {
                lore.add(this.untrack);
            } else {
                lore.add(this.track);
            }
        }
        ItemStack c = new ItemStack(challenge.getShownItem(), Math.min(Math.max(1, challengeCount), 64));
        ItemMeta challengemeta = c.getItemMeta();
        challengemeta.setDisplayName(challengeName);
        challengemeta.setLore(lore);
        if (challengeCount == 0 || challenge.getRepeatRewards() != null && !challenge.getRepeatRewards().isEmpty()) {
            challengemeta.addEnchant(Enchantment.DURABILITY, 1, true);
        }
        challengemeta.addItemFlags(ItemFlag.values());
        challengemeta.getPersistentDataContainer().set(CHALLENGE_KEY, PersistentDataType.STRING, (Object)challenge.getMySQLKey());
        c.setItemMeta(challengemeta);
        return c;
    }

    private Map<String, Challenge> getChallenges(Challenge.Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return ChallengesManager.challengesEasy;
            }
            case MEDIUM: {
                return ChallengesManager.challengesMedium;
            }
            case HARD: {
                return ChallengesManager.challengesHard;
            }
        }
        return null;
    }

    private String getDifficulty(Challenge.Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return "Easy";
            }
            case MEDIUM: {
                return "Medium";
            }
            case HARD: {
                return "Hard";
            }
        }
        return null;
    }

    private int getChallengeListSize(Challenge.Difficulty difficulty) {
        switch (difficulty) {
            case EASY: {
                return ChallengesManager.sortedChallengesEasy.size();
            }
            case MEDIUM: {
                return ChallengesManager.sortedChallengesMedium.size();
            }
            case HARD: {
                return ChallengesManager.sortedChallengesHard.size();
            }
        }
        return 0;
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private List<String> splitString(String string, String colorCode) {
        List<Object> wordbyword = new ArrayList<String>();
        if (string.length() < 30) {
            wordbyword.add(string);
        } else {
            wordbyword = Arrays.asList(string.split(" "));
        }
        ArrayList<String> splittedString = new ArrayList<String>();
        int i = 0;
        String currentLine = null;
        for (String string2 : wordbyword) {
            if ((i += string2.length()) > 30) {
                if (string2.length() >= 30) {
                    splittedString.add(currentLine);
                    splittedString.add(string2);
                    i = 0;
                    currentLine = null;
                } else {
                    splittedString.add(colorCode + currentLine);
                    currentLine = string2;
                    i = string2.length();
                }
            } else {
                currentLine = currentLine == null ? string2 : currentLine + " " + string2;
            }
            if (!((String)wordbyword.get(wordbyword.size() - 1)).equals(string2)) continue;
            splittedString.add(colorCode + currentLine);
        }
        return splittedString;
    }
}

