/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Challenges;

import com.github.Viduality.VSkyblock.Challenges.Challenge;
import com.github.Viduality.VSkyblock.Challenges.ChallengesInventoryCreator;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class ChallengesManager {
    public static final Map<String, Challenge> challenges = new HashMap<String, Challenge>();
    static final Map<String, Challenge> challengesEasy = new HashMap<String, Challenge>();
    static final Map<String, Challenge> challengesMedium = new HashMap<String, Challenge>();
    static final Map<String, Challenge> challengesHard = new HashMap<String, Challenge>();
    public static List<Challenge> sortedChallengesEasy = new ArrayList<Challenge>();
    public static List<Challenge> sortedChallengesMedium = new ArrayList<Challenge>();
    public static List<Challenge> sortedChallengesHard = new ArrayList<Challenge>();
    public static Cache<UUID, Integer> onIslandDelay = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    public static Cache<UUID, Integer> islandLevelDelay = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.SECONDS).build();
    private VSkyblock plugin;
    private final ChallengesInventoryCreator inventoryCreator;

    public ChallengesManager(VSkyblock plugin) {
        this.plugin = plugin;
        this.inventoryCreator = new ChallengesInventoryCreator(plugin);
    }

    public ChallengesInventoryCreator getInventoryCreator() {
        return this.inventoryCreator;
    }

    public void checkChallenge(Challenge challenge, Player player, Inventory inv, int challengeSlot) {
        this.plugin.getDb().getReader().getislandidfromplayer(player.getUniqueId(), islandid -> this.plugin.getDb().getReader().getIslandChallenges(islandid, islandChallenges -> {
            boolean repeat = false;
            if (islandChallenges.getChallengeCount(challenge.getMySQLKey()) != 0) {
                repeat = true;
            }
            if (challenge.getChallengeType().equals((Object)Challenge.ChallengeType.onPlayer)) {
                List<ItemStack> rewards = repeat ? challenge.getRepeatRewards() : challenge.getRewards();
                boolean enoughItems = true;
                for (ItemStack i : challenge.getNeededItems()) {
                    int neededamount = i.getAmount();
                    for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
                        if (player.getInventory().getItem(slot) == null || !player.getInventory().getItem(slot).getType().equals((Object)i.getType())) continue;
                        neededamount -= player.getInventory().getItem(slot).getAmount();
                    }
                    if (neededamount <= 0) continue;
                    enoughItems = false;
                }
                if (player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                    enoughItems = true;
                }
                if (enoughItems) {
                    List<Integer> emptySlots = this.getEmptySlots((Inventory)player.getInventory());
                    if (emptySlots.size() >= rewards.size()) {
                        Sound sound;
                        if (!player.getGameMode().equals((Object)GameMode.CREATIVE)) {
                            this.clearItems((Inventory)player.getInventory(), challenge.getNeededItems());
                        }
                        this.giveRewards((Inventory)player.getInventory(), rewards);
                        this.plugin.getDb().getWriter().updateChallengeCount(islandid, challenge.getMySQLKey(), islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1);
                        inv.setItem(challengeSlot, this.inventoryCreator.createChallengeItem(challenge, islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1, islandChallenges.getTrackedChallenges().contains(challenge.getMySQLKey())));
                        this.unTrack(challenge, player);
                        if (!repeat) {
                            ConfigShorts.broadcastChallengeCompleted("ChallengeComplete", player.getName(), challenge);
                            if (ConfigShorts.getDefConfig().isConfigurationSection("ChallengeCompleteFirst")) {
                                try {
                                    sound = Sound.valueOf((String)ConfigShorts.getDefConfig().getString("ChallengeCompleteFirst.Sound").toUpperCase());
                                    float pitch = (float)ConfigShorts.getDefConfig().getDouble("ChallengeCompleteFirst.Pitch");
                                    for (Player p : player.getWorld().getPlayers()) {
                                        p.playSound(p.getLocation(), sound, 1.0f, pitch);
                                    }
                                }
                                catch (IllegalArgumentException e) {
                                    VSkyblock.getInstance().getLogger().warning("ChallengeCompleteFirst sound is invalid! " + e.getMessage());
                                }
                            }
                        } else if (ConfigShorts.getDefConfig().isConfigurationSection("ChallengeComplete")) {
                            try {
                                sound = Sound.valueOf((String)ConfigShorts.getDefConfig().getString("ChallengeComplete.Sound").toUpperCase());
                                float pitch = (float)ConfigShorts.getDefConfig().getDouble("ChallengeComplete.Pitch");
                                player.playSound(player.getLocation(), sound, 1.0f, pitch);
                            }
                            catch (IllegalArgumentException e) {
                                VSkyblock.getInstance().getLogger().warning("ChallengeComplete sound is invalid! " + e.getMessage());
                            }
                        }
                    } else {
                        ConfigShorts.messagefromString("NotEnoughInventorySpace", (CommandSender)player);
                        player.closeInventory();
                    }
                } else {
                    ConfigShorts.messagefromString("NotEnoughItems", (CommandSender)player);
                    player.closeInventory();
                }
            } else if (challenge.getChallengeType().equals((Object)Challenge.ChallengeType.islandLevel)) {
                if (!repeat) {
                    if (!islandLevelDelay.asMap().containsKey(player.getUniqueId())) {
                        islandLevelDelay.put((Object)player.getUniqueId(), (Object)1);
                        this.plugin.getDb().getReader().getislandlevelfromuuid(player.getUniqueId(), islandLevel -> {
                            if (islandLevel >= challenge.getNeededLevel()) {
                                if (this.getEmptySlots((Inventory)player.getInventory()).size() >= challenge.getRewards().size()) {
                                    this.giveRewards((Inventory)player.getInventory(), challenge.getRewards());
                                    ConfigShorts.broadcastChallengeCompleted("ChallengeComplete", player.getName(), challenge);
                                    if (ConfigShorts.getDefConfig().isConfigurationSection("ChallengeCompleteFirst")) {
                                        try {
                                            Sound sound = Sound.valueOf((String)ConfigShorts.getDefConfig().getString("ChallengeCompleteFirst.Sound").toUpperCase());
                                            float pitch = (float)ConfigShorts.getDefConfig().getDouble("ChallengeCompleteFirst.Pitch");
                                            for (Player p : player.getWorld().getPlayers()) {
                                                p.playSound(p.getLocation(), sound, 1.0f, pitch);
                                            }
                                        }
                                        catch (IllegalArgumentException e) {
                                            VSkyblock.getInstance().getLogger().warning("ChallengeCompleteFirst sound is invalid! " + e.getMessage());
                                        }
                                    }
                                    this.plugin.getDb().getWriter().updateChallengeCount(islandid, challenge.getMySQLKey(), islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1);
                                    inv.setItem(challengeSlot, this.inventoryCreator.createChallengeItem(challenge, islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1, islandChallenges.getTrackedChallenges().contains(challenge.getMySQLKey())));
                                } else {
                                    ConfigShorts.messagefromString("NotEnoughInventorySpace", (CommandSender)player);
                                }
                            } else {
                                ConfigShorts.messagefromString("IslandLevelNotHighEnough", (CommandSender)player);
                            }
                        });
                    } else {
                        ConfigShorts.messagefromString("AlreadyCheckedIsland", (CommandSender)player);
                    }
                } else {
                    ConfigShorts.messagefromString("ChallengeNotRepeatable", (CommandSender)player);
                    inv.setItem(challengeSlot, this.inventoryCreator.createChallengeItem(challenge, islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1, islandChallenges.getTrackedChallenges().contains(challenge.getMySQLKey())));
                }
            } else if (challenge.getChallengeType().equals((Object)Challenge.ChallengeType.onIsland)) {
                if (!repeat) {
                    if (!onIslandDelay.asMap().containsKey(player.getUniqueId())) {
                        onIslandDelay.put((Object)player.getUniqueId(), (Object)1);
                        ConfigShorts.messagefromString("CheckingIslandForChallenge", (CommandSender)player);
                        HashMap<Material, Integer> result = this.getBlocks(player, challenge.getRadius());
                        boolean enoughItems = true;
                        for (ItemStack i : challenge.getNeededItems()) {
                            if (result.containsKey(i.getType())) {
                                if (result.get(i.getType()) >= i.getAmount()) continue;
                                enoughItems = false;
                                continue;
                            }
                            enoughItems = false;
                        }
                        if (enoughItems) {
                            if (this.getEmptySlots((Inventory)player.getInventory()).size() >= challenge.getRewards().size()) {
                                this.giveRewards((Inventory)player.getInventory(), challenge.getRewards());
                                ConfigShorts.broadcastChallengeCompleted("ChallengeComplete", player.getName(), challenge);
                                if (ConfigShorts.getDefConfig().isConfigurationSection("ChallengeCompleteFirst")) {
                                    try {
                                        Sound sound = Sound.valueOf((String)ConfigShorts.getDefConfig().getString("ChallengeCompleteFirst.Sound").toUpperCase());
                                        float pitch = (float)ConfigShorts.getDefConfig().getDouble("ChallengeCompleteFirst.Pitch");
                                        for (Player p : player.getWorld().getPlayers()) {
                                            p.playSound(p.getLocation(), sound, 1.0f, pitch);
                                        }
                                    }
                                    catch (IllegalArgumentException e) {
                                        VSkyblock.getInstance().getLogger().warning("ChallengeCompleteFirst sound is invalid! " + e.getMessage());
                                    }
                                }
                                this.plugin.getDb().getWriter().updateChallengeCount(islandid, challenge.getMySQLKey(), islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1);
                                inv.setItem(challengeSlot, this.inventoryCreator.createChallengeItem(challenge, islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1, islandChallenges.getTrackedChallenges().contains(challenge.getMySQLKey())));
                            } else {
                                ConfigShorts.messagefromString("NotEnoughInventorySpace", (CommandSender)player);
                            }
                        } else {
                            ConfigShorts.messagefromString("IslandDoesNotMatchRequirements", (CommandSender)player);
                        }
                    } else {
                        ConfigShorts.messagefromString("AlreadyCheckedIsland", (CommandSender)player);
                    }
                } else {
                    ConfigShorts.messagefromString("ChallengeNotRepeatable", (CommandSender)player);
                    inv.setItem(challengeSlot, this.inventoryCreator.createChallengeItem(challenge, islandChallenges.getChallengeCount(challenge.getMySQLKey()) + 1, islandChallenges.getTrackedChallenges().contains(challenge.getMySQLKey())));
                }
            }
        }));
    }

    private void clearItems(Inventory inv, List<ItemStack> items) {
        block0: for (ItemStack i : items) {
            int amount = i.getAmount();
            for (int slot = 0; slot < inv.getSize(); ++slot) {
                ItemStack is = inv.getItem(slot);
                if (is == null || !is.getType().equals((Object)i.getType())) continue;
                int newAmount = is.getAmount() - amount;
                if (newAmount > 0) {
                    is.setAmount(newAmount);
                    continue block0;
                }
                inv.clear(slot);
                if ((amount -= is.getAmount()) == 0) continue block0;
            }
        }
    }

    private void giveRewards(Inventory inv, List<ItemStack> items) {
        for (ItemStack current : items) {
            inv.addItem(new ItemStack[]{current.clone()});
        }
    }

    private List<Integer> getEmptySlots(Inventory inv) {
        ArrayList<Integer> emptySlots = new ArrayList<Integer>();
        for (int currentSlot = 0; currentSlot < 36; ++currentSlot) {
            if (inv.getItem(currentSlot) != null) continue;
            emptySlots.add(currentSlot);
        }
        return emptySlots;
    }

    private HashMap<Material, Integer> getBlocks(Player player, Integer radius) {
        HashMap<Material, Integer> blocks = new HashMap<Material, Integer>();
        Location loc = player.getLocation();
        int blockx = (int)loc.getX();
        int blocky = (int)loc.getY();
        int blockz = (int)loc.getZ();
        for (int x = blockx - radius; x < blockx + radius; ++x) {
            for (int z = blockz - radius; z < blockz + radius; ++z) {
                if (!player.getWorld().isChunkLoaded(x >> 4, z >> 4)) continue;
                for (int y = blocky - radius; y < blocky + radius; ++y) {
                    Material blockType = player.getWorld().getBlockAt(x, y, z).getType();
                    if (blockType.isAir()) continue;
                    blocks.put(blockType, blocks.getOrDefault(blockType, 0) + 1);
                }
            }
        }
        return blocks;
    }

    public void toggleTracked(Challenge challenge, Player player) {
        this.plugin.getDb().getReader().getislandidfromplayer(player.getUniqueId(), islandId -> this.plugin.getDb().getReader().getIslandChallenges(islandId, challenges -> {
            if (challenges.getTrackedChallenges().size() < 10 && challenges.getChallengeCount(challenge.getChallengeName()) == 0 || challenge.getRepeatRewards() != null) {
                if (challenges.getTrackedChallenges().contains(challenge.getMySQLKey())) {
                    challenges.removeTrackedChallenge(challenge.getMySQLKey());
                    this.plugin.getDb().getWriter().updateChallengeTracked(islandId, challenge.getMySQLKey(), false);
                } else {
                    challenges.addTrackedChallenge(challenge.getMySQLKey());
                    this.plugin.getDb().getWriter().updateChallengeTracked(islandId, challenge.getMySQLKey(), true);
                }
                VSkyblock.getInstance().getScoreboardManager().updateTracked(islandId, challenges);
            }
        }));
    }

    public void unTrack(Challenge challenge, Player player) {
        this.plugin.getDb().getReader().getislandidfromplayer(player.getUniqueId(), islandId -> this.plugin.getDb().getReader().getIslandChallenges(islandId, challenges -> {
            if (challenges.removeTrackedChallenge(challenge.getMySQLKey())) {
                this.plugin.getDb().getWriter().updateChallengeTracked(islandId, challenge.getMySQLKey(), false);
                VSkyblock.getInstance().getScoreboardManager().updateTracked(islandId, challenges);
            }
        }));
    }
}

