/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGenerator;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CobblestoneGeneratorUpgrade {
    private final VSkyblock plugin = VSkyblock.getInstance();

    public void checkForGeneratorUpgrade(String island, Player player) {
        int currentlevel = CobblestoneGenerator.islandGenLevel.get(island);
        int nextlevel = currentlevel + 1;
        Double requiredIslandLevel = this.getRequiredIslandLevel(nextlevel);
        int islandlevel = CobblestoneGenerator.islandlevels.get(Island.playerislands.get(player.getUniqueId()));
        if ((double)islandlevel >= requiredIslandLevel) {
            List<Material> neededItems = this.getneededItems(nextlevel);
            List<Integer> neededAmounts = this.getneededItemsAmount(nextlevel);
            boolean enoughItems = true;
            for (int i = 0; i < neededItems.size(); ++i) {
                int neededAmount = neededAmounts.get(i);
                int currentamount = 0;
                for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
                    if (player.getInventory().getItem(slot) == null || !player.getInventory().getItem(slot).getType().equals((Object)neededItems.get(i))) continue;
                    currentamount += player.getInventory().getItem(slot).getAmount();
                }
                if (currentamount >= neededAmount) continue;
                enoughItems = false;
            }
            if (enoughItems) {
                this.upgradeCobbleGenerator(island, nextlevel);
                this.removeItems(neededItems, neededAmounts, player);
                player.closeInventory();
                this.plugin.getDb().getReader().getislandid(Island.playerislands.get(player.getUniqueId()), islandId -> this.plugin.getDb().getReader().getIslandMembers(islandId, members -> {
                    for (String member : members) {
                        OfflinePlayer offlinePlayer = this.plugin.getServer().getOfflinePlayer(member);
                        if (!offlinePlayer.isOnline()) continue;
                        Player onlinePlayer = (Player)offlinePlayer;
                        ConfigShorts.custommessagefromString("UpgradedYourCobblestoneGenerator", (CommandSender)onlinePlayer, player.getName());
                    }
                }));
            } else {
                ConfigShorts.messagefromString("NotEnoughItemsGenerator", (CommandSender)player);
            }
        } else {
            ConfigShorts.messagefromString("IslandLevelNotHighEnough", (CommandSender)player);
        }
    }

    private List<Material> getneededItems(int nextLevel) {
        List neededItemsStringwithAmount = ConfigShorts.getOptionsConfig().getStringList("CobblestoneGenerator.Upgrade.Level_" + nextLevel + ".Needed");
        ArrayList<String> neededItemsString = new ArrayList<String>();
        for (String current : neededItemsStringwithAmount) {
            String[] String2 = current.split(";");
            neededItemsString.add(String2[0]);
        }
        ArrayList<Material> neededItems = new ArrayList<Material>();
        for (String current : neededItemsString) {
            if (Material.matchMaterial((String)current.toUpperCase()) == null) continue;
            neededItems.add(Material.getMaterial((String)current.toUpperCase()));
        }
        return neededItems;
    }

    private List<Integer> getneededItemsAmount(int nextLevel) {
        List neededAmountStringwithItems = ConfigShorts.getOptionsConfig().getStringList("CobblestoneGenerator.Upgrade.Level_" + nextLevel + ".Needed");
        ArrayList<Integer> neededAmount = new ArrayList<Integer>();
        for (String current : neededAmountStringwithItems) {
            String[] String2 = current.split(";");
            neededAmount.add(Integer.valueOf(String2[1]));
        }
        return neededAmount;
    }

    private void upgradeCobbleGenerator(String island, int nextLevel) {
        this.plugin.getDb().getWriter().updateCobblestoneGeneratorLevel(island, nextLevel);
        CobblestoneGenerator.islandGenLevel.put(island, nextLevel);
    }

    private void removeItems(List<Material> items, List<Integer> amounts, Player player) {
        for (int i = 0; i < items.size(); ++i) {
            int neededamount = amounts.get(i);
            Material currentItem = items.get(i);
            int x = 0;
            block1: while (x < neededamount) {
                for (int slot = 0; slot < player.getInventory().getSize(); ++slot) {
                    ItemStack currentItemSlot = player.getInventory().getItem(slot);
                    if (currentItemSlot == null || !currentItemSlot.getType().equals((Object)currentItem)) continue;
                    int newAmount = currentItemSlot.getAmount() - neededamount;
                    if (newAmount > 0) {
                        currentItemSlot.setAmount(newAmount);
                        x = neededamount;
                        continue block1;
                    }
                    player.getInventory().clear(slot);
                    if ((neededamount -= currentItemSlot.getAmount()) == 0) continue block1;
                }
            }
        }
    }

    private Double getRequiredIslandLevel(int nextGeneratorLevel) {
        switch (nextGeneratorLevel) {
            case 1: {
                return CobblestoneGenerator.generatorValues.get("CoalLevel");
            }
            case 2: {
                return CobblestoneGenerator.generatorValues.get("IronLevel");
            }
            case 3: {
                return CobblestoneGenerator.generatorValues.get("RedstoneLevel");
            }
            case 4: {
                return CobblestoneGenerator.generatorValues.get("LapisLevel");
            }
            case 5: {
                return CobblestoneGenerator.generatorValues.get("GoldLevel");
            }
            case 6: {
                return CobblestoneGenerator.generatorValues.get("EmeraldLevel");
            }
            case 7: {
                return CobblestoneGenerator.generatorValues.get("DiamondLevel");
            }
            case 8: {
                return CobblestoneGenerator.generatorValues.get("AncientDebrisLevel");
            }
        }
        return null;
    }
}

