/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Commands;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Commands.SubCommand;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseCache;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.github.Viduality.VSkyblock.WorldGenerator.IslandCreator;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class IslandCommand
implements SubCommand {
    private final VSkyblock plugin;

    public IslandCommand(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(DatabaseCache databaseCache) {
        Player player = databaseCache.getPlayer();
        if (databaseCache.getIslandId() != 0) {
            boolean teleport = true;
            if (!ConfigShorts.getDefConfig().getBoolean("SaveWithIslandCommand") && player.getFallDistance() > 2.0f) {
                teleport = false;
                ConfigShorts.messagefromString("PlayerFalling", (CommandSender)player);
            }
            if (!ConfigShorts.getDefConfig().getBoolean("SaveWithIslandCommandLava") && player.getLocation().getBlock().getType().equals((Object)Material.LAVA)) {
                teleport = false;
                ConfigShorts.messagefromString("PlayerInLava", (CommandSender)player);
            }
            if (teleport) {
                if (!this.plugin.getWorldManager().getLoadedWorlds().contains(databaseCache.getIslandname()) && !this.plugin.getWorldManager().loadWorld(databaseCache.getIslandname())) {
                    ConfigShorts.custommessagefromString("WorldFailedToLoad", (CommandSender)player, databaseCache.getIslandname());
                    return;
                }
                Location islandHome = Island.islandhomes.get(databaseCache.getIslandname());
                if (islandHome != null) {
                    islandHome.getWorld().getChunkAtAsync(islandHome).whenComplete((c, e) -> {
                        if (e != null) {
                            e.printStackTrace();
                        }
                        if (c != null) {
                            Block below = islandHome.getBlock().getRelative(BlockFace.DOWN);
                            if (below.getType() == Material.AIR) {
                                below.setType(Material.INFESTED_COBBLESTONE);
                            }
                            this.plugin.teleportToIsland(player, islandHome);
                        } else {
                            ConfigShorts.custommessagefromString("WorldFailedToLoad", (CommandSender)player, databaseCache.getIslandname());
                        }
                    });
                }
            }
        } else if (!Island.isgencooldown.asMap().containsValue(player.getUniqueId())) {
            ConfigShorts.messagefromString("GenerateNewIsland", (CommandSender)player);
            player.getEnderChest().clear();
            player.getInventory().clear();
            player.setTotalExperience(0);
            player.setExp(0.0f);
            player.setFoodLevel(20);
            new IslandCreator(this.plugin, databaseCache.getUuid()).createNewIsland();
            Island.isgencooldown.put((Object)player.getUniqueId(), (Object)player.getUniqueId());
        } else {
            ConfigShorts.custommessagefromString("GenerateCooldown", (CommandSender)player, String.valueOf(Island.getisgencooldown()));
        }
    }
}

