/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Commands;

import com.github.Viduality.VSkyblock.Commands.SubCommand;
import com.github.Viduality.VSkyblock.DefaultFiles;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGenerator;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseCache;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.Leaves;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class IslandLevel
implements SubCommand {
    private final VSkyblock plugin;
    private static Cache<UUID, Boolean> timebetweenreuse = CacheBuilder.newBuilder().expireAfterWrite((long)IslandLevel.gettimebetweencalc(), TimeUnit.MINUTES).build();

    public IslandLevel(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(DatabaseCache databaseCache) {
        if (databaseCache.getIslandId() != 0) {
            UUID uuid = null;
            if (databaseCache.getArg() != null) {
                OfflinePlayer target = this.plugin.getServer().getOfflinePlayer(databaseCache.getArg());
                uuid = target.getUniqueId();
            } else {
                uuid = databaseCache.getUuid();
            }
            Player player = databaseCache.getPlayer();
            this.plugin.getDb().getReader().getislandlevelfromuuid(uuid, islandlevel -> {
                if (databaseCache.getArg() != null) {
                    ConfigShorts.custommessagefromString("PlayersIslandLevel", player, String.valueOf(islandlevel), databaseCache.getArg());
                } else {
                    ConfigShorts.custommessagefromString("CurrentIslandLevel", (CommandSender)player, String.valueOf(islandlevel));
                    if (timebetweenreuse.getIfPresent((Object)player.getUniqueId()) == null) {
                        timebetweenreuse.put((Object)player.getUniqueId(), (Object)true);
                        ConfigShorts.messagefromString("CalculatingNewIslandLevel", (CommandSender)player);
                        World world = this.plugin.getServer().getWorld(databaseCache.getIslandname());
                        if (world == null) {
                            this.plugin.getLogger().log(Level.SEVERE, "World " + databaseCache.getIslandname() + " not found?");
                            return;
                        }
                        this.plugin.getDb().getReader().getIslandsChallengePoints(databaseCache.getIslandId(), challengePoints -> {
                            int z;
                            int x;
                            int valueriselevel = IslandLevel.getValueRiseLevel();
                            int valueincrease = IslandLevel.getValueIncrease();
                            double worldsize = world.getWorldBorder().getSize();
                            int x1 = (int)(-1.0 * worldsize / 2.0) >> 4;
                            int x2 = (int)worldsize / 2 >> 4;
                            int z1 = x1;
                            int z2 = x2;
                            double value = 0.0;
                            value = IslandLevel.isInt(ConfigShorts.getDefConfig().getString("IslandValueonStart")) ? (double)ConfigShorts.getDefConfig().getInt("IslandValueonStart") : 150.0;
                            int valueperlevel = IslandLevel.isInt(ConfigShorts.getDefConfig().getString("IslandValue")) ? ConfigShorts.getDefConfig().getInt("IslandValue") : 300;
                            IslandCounter counter = new IslandCounter(value += (double)challengePoints, 0, c -> {
                                double currentvalue = c.value;
                                int level = 0;
                                int increasedvaluefornextlevel = valueperlevel + valueincrease;
                                for (int i = 0; i < valueriselevel; ++i) {
                                    if (currentvalue - (double)valueperlevel >= 0.0) {
                                        ++level;
                                        currentvalue -= (double)valueperlevel;
                                        continue;
                                    }
                                    currentvalue = 0.0;
                                    break;
                                }
                                if (currentvalue - (double)increasedvaluefornextlevel >= 0.0) {
                                    while (currentvalue >= 0.0) {
                                        if (currentvalue - (double)increasedvaluefornextlevel >= 0.0) {
                                            ++level;
                                            currentvalue -= (double)increasedvaluefornextlevel;
                                            increasedvaluefornextlevel += valueincrease;
                                            continue;
                                        }
                                        currentvalue = 0.0;
                                        break;
                                    }
                                }
                                int roundlevel = (int)Math.floor(level);
                                this.plugin.getDb().getWriter().updateIslandLevel(databaseCache.getIslandId(), roundlevel, c.blocks, player.getUniqueId());
                                ConfigShorts.custommessagefromString("NewIslandLevel", (CommandSender)player, String.valueOf(roundlevel));
                                CobblestoneGenerator.islandlevels.put(databaseCache.getIslandname(), roundlevel);
                            });
                            for (x = x1; x <= x2; ++x) {
                                for (z = z1; z <= z2; ++z) {
                                    counter.toCount();
                                }
                            }
                            for (x = x1; x <= x2; ++x) {
                                for (z = z1; z <= z2; ++z) {
                                    world.getChunkAtAsync(x, z, false).whenComplete((c, ex) -> counter.count((Chunk)c));
                                }
                            }
                        });
                    }
                }
            });
        } else {
            ConfigShorts.messagefromString("NoIsland", (CommandSender)databaseCache.getPlayer());
        }
    }

    private static boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static int getValueRiseLevel() {
        String s = ConfigShorts.getDefConfig().getString("IslandValueRiseLevel");
        if (s != null) {
            if (IslandLevel.isInt(s)) {
                return Integer.parseInt(s);
            }
            return 150;
        }
        return 150;
    }

    private static int getValueIncrease() {
        String s = ConfigShorts.getDefConfig().getString("IslandValueIncreasePerLevel");
        if (s != null) {
            if (IslandLevel.isInt(s)) {
                return Integer.parseInt(s);
            }
            return 20;
        }
        return 20;
    }

    private static int gettimebetweencalc() {
        int timebetweencalc = 5;
        if (IslandLevel.isInt(ConfigShorts.getDefConfig().getString("IslandLevelReuse"))) {
            timebetweencalc = ConfigShorts.getDefConfig().getInt("IslandLevelReuse");
        }
        return timebetweencalc;
    }

    public static class IslandCounter {
        public double value;
        public int blocks;
        private int toCount = 0;
        private final Consumer<IslandCounter> onDone;

        public IslandCounter(double value, int blocks, Consumer<IslandCounter> onDone) {
            this.value = value;
            this.blocks = blocks;
            this.onDone = onDone;
        }

        public void add(IslandCounter counter) {
            this.value += counter.value;
            this.blocks += counter.blocks;
        }

        public void toCount() {
            ++this.toCount;
        }

        public void count(Chunk chunk) {
            if (chunk != null && chunk.getInhabitedTime() > 0L) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < 256; ++y) {
                            Block block = chunk.getBlock(x, y, z);
                            if (block.getType() == Material.AIR || block.getType() == Material.VOID_AIR || Tag.LEAVES.isTagged((Keyed)block.getType()) && !((Leaves)block.getBlockData()).isPersistent()) continue;
                            ++this.blocks;
                            this.value += DefaultFiles.blockvalues.getOrDefault(block.getType(), 0.0).doubleValue();
                        }
                    }
                }
            }
            if (--this.toCount == 0) {
                this.onDone.accept(this);
            }
        }
    }
}

