/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Commands;

import com.github.Viduality.VSkyblock.Commands.SubCommand;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseCache;
import com.github.Viduality.VSkyblock.Utilitys.IslandOptionsCache;
import com.github.Viduality.VSkyblock.VSkyblock;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class IslandOptions
implements SubCommand {
    private final VSkyblock plugin;

    public IslandOptions(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(DatabaseCache databaseCache) {
        if (databaseCache.getIslandId() != 0) {
            this.plugin.getDb().getReader().getIslandOptions(databaseCache.getIslandId(), isoptionsCache -> this.createOptionsInventory(isoptionsCache, databaseCache.getPlayer(), databaseCache.isIslandowner()));
        } else {
            ConfigShorts.messagefromString("NoIsland", (CommandSender)databaseCache.getPlayer());
        }
    }

    private void createOptionsInventory(IslandOptionsCache cache, Player player, boolean islandOwner) {
        Material difficultyBlock;
        String difficulty = cache.getDifficulty();
        boolean visit = cache.getVisit();
        boolean needRequest = cache.getNeedRequest();
        Inventory isOptions = Bukkit.createInventory(null, (int)18, (String)this.getInvName());
        Material visitBlock = visit ? (needRequest ? this.getMaterial(ConfigShorts.getOptionsConfig().getString("Visit.NeedsRequestItem")) : this.getMaterial(ConfigShorts.getOptionsConfig().getString("Visit.AllowedItem"))) : this.getMaterial(ConfigShorts.getOptionsConfig().getString("Visit.NotAllowedItem"));
        ItemStack visitSlot = new ItemStack(visitBlock, 1);
        ItemMeta visitSlotItemMeta = visitSlot.getItemMeta();
        if (visitSlotItemMeta != null) {
            if (visit) {
                if (needRequest) {
                    visitSlotItemMeta.setDisplayName(this.getDisplayNameVisit("NeedsRequest"));
                } else {
                    visitSlotItemMeta.setDisplayName(this.getDisplayNameVisit("Allowed"));
                }
            } else {
                visitSlotItemMeta.setDisplayName(this.getDisplayNameVisit("NotAllowed"));
            }
            visitSlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            visitSlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            visitSlotItemMeta.addItemFlags(ItemFlag.values());
        }
        visitSlot.setItemMeta(visitSlotItemMeta);
        isOptions.setItem(2, visitSlot);
        switch (difficulty) {
            case "EASY": {
                difficultyBlock = this.getMaterial(ConfigShorts.getOptionsConfig().getString("Difficulty.EasyItem"));
                break;
            }
            case "HARD": {
                difficultyBlock = this.getMaterial(ConfigShorts.getOptionsConfig().getString("Difficulty.HardItem"));
                break;
            }
            default: {
                difficultyBlock = this.getMaterial(ConfigShorts.getOptionsConfig().getString("Difficulty.NormalItem"));
            }
        }
        ItemStack difficultySlot = new ItemStack(difficultyBlock, 1);
        ItemMeta difficultySlotItemMeta = difficultySlot.getItemMeta();
        if (difficultySlotItemMeta != null) {
            switch (difficulty) {
                case "EASY": {
                    difficultySlotItemMeta.setDisplayName(this.getDisplayNameDifficulty("Easy"));
                    break;
                }
                case "HARD": {
                    difficultySlotItemMeta.setDisplayName(this.getDisplayNameDifficulty("Hard"));
                    break;
                }
                default: {
                    difficultySlotItemMeta.setDisplayName(this.getDisplayNameDifficulty("Normal"));
                }
            }
            difficultySlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            difficultySlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            difficultySlotItemMeta.addItemFlags(ItemFlag.values());
        }
        difficultySlot.setItemMeta(difficultySlotItemMeta);
        isOptions.setItem(6, difficultySlot);
        ItemStack generatorSlot = new ItemStack(Material.COBBLESTONE, 1);
        ItemMeta generatorSlotItemMeta = difficultySlot.getItemMeta();
        if (generatorSlotItemMeta != null) {
            generatorSlotItemMeta.setDisplayName(this.getDisplayNameGenerator());
            generatorSlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
            generatorSlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
            generatorSlotItemMeta.addItemFlags(ItemFlag.values());
        }
        generatorSlot.setItemMeta(generatorSlotItemMeta);
        isOptions.setItem(4, generatorSlot);
        if (islandOwner) {
            Material acceptBlock = Material.LIME_WOOL;
            ItemStack acceptBlockSlot = new ItemStack(acceptBlock, 1);
            ItemMeta acceptBlockSlotItemMeta = acceptBlockSlot.getItemMeta();
            if (acceptBlockSlotItemMeta != null) {
                acceptBlockSlotItemMeta.setDisplayName(this.getAccept());
                acceptBlockSlotItemMeta.addEnchant(Enchantment.DURABILITY, 1, true);
                acceptBlockSlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
                acceptBlockSlotItemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                acceptBlockSlotItemMeta.addItemFlags(ItemFlag.values());
            }
            acceptBlockSlot.setItemMeta(acceptBlockSlotItemMeta);
            isOptions.setItem(17, acceptBlockSlot);
        }
        player.openInventory(isOptions);
    }

    private Material getMaterial(String material) {
        if (Material.matchMaterial((String)material) != null) {
            return Material.getMaterial((String)material);
        }
        return Material.BARRIER;
    }

    private String getInvName() {
        if (ConfigShorts.getOptionsConfig().getString("InventoryName") != null) {
            return ConfigShorts.getOptionsConfig().getString("InventoryName");
        }
        return "Island options";
    }

    private String getDisplayNameDifficulty(String difficulty) {
        String displayname = ConfigShorts.getOptionsConfig().getString("Difficulty." + difficulty);
        if (displayname != null) {
            return displayname;
        }
        return difficulty;
    }

    private String getDisplayNameVisit(String allowed) {
        String displayname = ConfigShorts.getOptionsConfig().getString("Visit." + allowed);
        if (displayname != null) {
            return displayname;
        }
        return "Visitors allowed";
    }

    private String getDisplayNameGenerator() {
        String displayname = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.DisplayName");
        if (displayname != null) {
            return displayname;
        }
        return "Cobblestone-Generator";
    }

    private String getAccept() {
        String accept = ConfigShorts.getOptionsConfig().getString("Accept");
        if (accept != null) {
            return accept;
        }
        return "Accept";
    }
}

