/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Commands.WorldCommands;

import com.github.Viduality.VSkyblock.Commands.WorldCommands.AdminSubCommand;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.WorldCreator;
import org.bukkit.WorldType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class WorldCreate
implements AdminSubCommand {
    private final VSkyblock plugin;

    public WorldCreate(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(CommandSender sender, String args, String option1, String option2) {
        if (sender instanceof Player) {
            Player player = (Player)sender;
            if (sender.hasPermission("VSkyblock.CreateWorld")) {
                if (!this.plugin.getWorldManager().getAllWorlds().contains(args)) {
                    ConfigShorts.messagefromString("WorldCreate", (CommandSender)player);
                    String generator = option1;
                    String environment = option2;
                    if (environment == null) {
                        environment = "NORMAL";
                    }
                    if (this.checkEnvironment(environment.toUpperCase())) {
                        WorldCreator wc = new WorldCreator(args);
                        if (generator != null) {
                            wc.generator(generator);
                        } else {
                            generator = "default";
                        }
                        wc.environment(this.getEnvironment(environment.toUpperCase()));
                        wc.type(WorldType.NORMAL);
                        wc.generateStructures(true);
                        World loadedworld = wc.createWorld();
                        if (loadedworld != null) {
                            if (this.plugin.getWorldManager().addWorld(args, generator, environment.toUpperCase())) {
                                Location spawnlocation = loadedworld.getSpawnLocation();
                                if (this.plugin.getWorldManager().setSpawnLocation(spawnlocation)) {
                                    ConfigShorts.messagefromString("WorldCreated", (CommandSender)player);
                                    player.teleportAsync(this.plugin.getWorldManager().getSpawnLocation(args));
                                } else {
                                    ConfigShorts.messagefromString("WorldCreationFailed", (CommandSender)player);
                                    this.plugin.getWorldManager().deleteWorld(args);
                                }
                            } else {
                                ConfigShorts.messagefromString("WorldCreationFailed", (CommandSender)player);
                                this.plugin.getWorldManager().deleteWorld(args);
                            }
                        } else {
                            ConfigShorts.messagefromString("WorldCreationFailed", (CommandSender)player);
                        }
                    } else {
                        ConfigShorts.custommessagefromString("WorldEnvironmentNotFound", (CommandSender)player, option2);
                    }
                } else {
                    ConfigShorts.messagefromString("WorldAlreadyExisting", (CommandSender)player);
                }
            } else {
                ConfigShorts.messagefromString("PermissionLack", (CommandSender)player);
            }
        } else {
            ConfigShorts.messagefromString("NotAPlayer", sender);
        }
    }

    private boolean checkEnvironment(String environment) {
        switch (environment) {
            case "NORMAL": {
                return true;
            }
            case "NETHER": {
                return true;
            }
            case "THE_END": {
                return true;
            }
        }
        return false;
    }

    private World.Environment getEnvironment(String environment) {
        switch (environment) {
            case "NORMAL": {
                return World.Environment.NORMAL;
            }
            case "NETHER": {
                return World.Environment.NETHER;
            }
            case "THE_END": {
                return World.Environment.THE_END;
            }
        }
        return World.Environment.NORMAL;
    }
}

