/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Commands.WorldCommands;

import com.github.Viduality.VSkyblock.Commands.WorldCommands.AdminSubCommand;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class WorldList
implements AdminSubCommand {
    private final VSkyblock plugin;

    public WorldList(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @Override
    public void execute(CommandSender sender, String args, String option1, String option2) {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (sender.hasPermission("VSkyblock.List")) {
                Set<String> worlds = this.plugin.getWorldManager().getAllWorlds();
                int sites = Math.round(worlds.size() / 7 + 1);
                int site = 1;
                if (this.isInt(args) && Integer.parseInt(args) != 0 && Integer.parseInt(args) <= sites) {
                    site = Integer.parseInt(args);
                }
                String header = ConfigShorts.getCustomString("WorldListHeader");
                String sitesString = ConfigShorts.getCustomString("Site", String.valueOf(site), String.valueOf(sites));
                String worldsString = this.getWorlds(new ArrayList<String>(worlds), site);
                String message = header + '\n' + worldsString + '\n' + sitesString;
                sender.sendMessage(message);
            }
        });
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private String getWorlds(List<String> worlds, int site) {
        List<String> loadedWorlds = this.plugin.getWorldManager().getLoadedWorlds();
        String prefix = ConfigShorts.getMessageConfig().getString("Prefix") + " ";
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            if (worlds.size() > site * 6 - 6 + i) {
                String env;
                String currentWorld = worlds.get(site * 6 - 6 + i);
                str.append(prefix);
                str.append("\u00a7f");
                str.append(currentWorld);
                if (loadedWorlds.contains(currentWorld)) {
                    str.append(" - Loaded");
                } else {
                    str.append(" - \u00a78Unloaded");
                }
                switch (env = ConfigShorts.getWorldConfig().getString("Worlds." + currentWorld + ".environment").toUpperCase()) {
                    case "THE_END": {
                        str.append("\u00a7f - \u00a75THE_END");
                        str.append('\n');
                        break;
                    }
                    case "NETHER": {
                        str.append("\u00a7f - \u00a74NETHER");
                        str.append('\n');
                        break;
                    }
                    default: {
                        str.append("\u00a7f - NORMAL");
                        str.append('\n');
                        break;
                    }
                }
                continue;
            }
            i = 7;
        }
        return str.toString();
    }
}

