/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock;

import com.github.Viduality.VSkyblock.VSkyblock;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;

public class DefaultFiles {
    private static VSkyblock plugin = VSkyblock.getInstance();
    public static Map<Material, Double> blockvalues = new EnumMap<Material, Double>(Material.class);

    public static void init() {
        DefaultFiles.saveDefaultConfig("Worlds.yml");
        DefaultFiles.saveDefaultConfig("BlockValues.yml");
        DefaultFiles.reloadBlockValues();
    }

    private static void saveDefaultConfig(String configName) {
        File configFile = new File(plugin.getDataFolder(), configName);
        try {
            if (!configFile.exists()) {
                plugin.getDataFolder().mkdirs();
                DefaultFiles.copy(plugin.getResource(configName), configFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copy(InputStream in, File file) {
        try {
            int len;
            FileOutputStream out = new FileOutputStream(file);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((OutputStream)out).close();
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void reloadBlockValues() {
        File configFile = new File(plugin.getDataFolder(), "BlockValues.yml");
        if (!configFile.exists()) {
            System.out.println("BlockValues.yml does not exist!");
            return;
        }
        if (!blockvalues.isEmpty()) {
            blockvalues.clear();
        }
        YamlConfiguration blockValuesConfig = new YamlConfiguration();
        try {
            blockValuesConfig.load(configFile);
            for (String configString : blockValuesConfig.getKeys(false)) {
                String material = configString.toUpperCase();
                if (Material.getMaterial((String)material) != null) {
                    double value = blockValuesConfig.getDouble(configString, -1.0);
                    if (value > -1.0) {
                        blockvalues.put(Material.getMaterial((String)material), value);
                        continue;
                    }
                    System.out.println("Material: " + material + " has an invalid block value (" + blockValuesConfig.get(configString) + ")");
                    continue;
                }
                System.out.println("Material string " + configString + " is not a valid material!");
            }
        }
        catch (Exception e) {
            System.out.println("Problem reading block values file.");
            e.printStackTrace();
        }
    }
}

