/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Listener;

import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockFormEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.inventory.ItemStack;

public class CobblestoneGenerator
implements Listener {
    private final VSkyblock plugin;
    public static HashMap<String, Integer> islandGenLevel = new HashMap();
    public static HashMap<String, Double> generatorValues = new HashMap();
    public static HashMap<String, Integer> islandlevels = new HashMap();
    public static Cache<Location, Long> cobblegen = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterAccess(10L, TimeUnit.MINUTES).build();

    public CobblestoneGenerator(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void cobblestoneGeneratorBlocks(BlockFormEvent blockFormEvent) {
        Block block = blockFormEvent.getNewState().getBlock();
        Material newmaterial = blockFormEvent.getNewState().getType();
        Location location = blockFormEvent.getNewState().getLocation();
        if (newmaterial.equals((Object)Material.COBBLESTONE)) {
            blockFormEvent.getNewState().setType(this.getCobblestone(location));
            if (islandGenLevel.containsKey(block.getLocation().getWorld().getName())) {
                int level = islandGenLevel.get(block.getLocation().getWorld().getName());
                switch (level) {
                    case 1: {
                        blockFormEvent.getNewState().setType(this.rollCoalLevel(location));
                        break;
                    }
                    case 2: {
                        blockFormEvent.getNewState().setType(this.rollIronLevel(location));
                        break;
                    }
                    case 3: {
                        blockFormEvent.getNewState().setType(this.rollRedstoneLevel(location));
                        break;
                    }
                    case 4: {
                        blockFormEvent.getNewState().setType(this.rollLapisLevel(location));
                        break;
                    }
                    case 5: {
                        blockFormEvent.getNewState().setType(this.rollGoldLevel(location));
                        break;
                    }
                    case 6: {
                        blockFormEvent.getNewState().setType(this.rollEmeraldLevel(location));
                        break;
                    }
                    case 7: {
                        blockFormEvent.getNewState().setType(this.rollDiamondLevel(location));
                        break;
                    }
                    case 8: {
                        blockFormEvent.getNewState().setType(this.rollAncientDebrisLevel(location));
                    }
                }
            }
        }
    }

    @EventHandler
    public void cobblestoneGeneratorDrops(BlockBreakEvent blockBreakEvent) {
        int additionalDropsAmount;
        int level;
        if (blockBreakEvent.getBlock().getType().equals((Object)Material.COBBLESTONE) && ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.MultipleDrops") != null && ConfigShorts.getDefConfig().getString("CobblestoneGenerator.Cobblestone.MultipleDrops").equalsIgnoreCase("true") && (blockBreakEvent.getBlock().getRelative(BlockFace.NORTH).getType().equals((Object)Material.LAVA) || blockBreakEvent.getBlock().getRelative(BlockFace.EAST).getType().equals((Object)Material.LAVA) || blockBreakEvent.getBlock().getRelative(BlockFace.SOUTH).getType().equals((Object)Material.LAVA) || blockBreakEvent.getBlock().getRelative(BlockFace.WEST).getType().equals((Object)Material.LAVA)) && (blockBreakEvent.getBlock().getRelative(BlockFace.NORTH).getType().equals((Object)Material.WATER) || blockBreakEvent.getBlock().getRelative(BlockFace.EAST).getType().equals((Object)Material.WATER) || blockBreakEvent.getBlock().getRelative(BlockFace.SOUTH).getType().equals((Object)Material.WATER) || blockBreakEvent.getBlock().getRelative(BlockFace.WEST).getType().equals((Object)Material.WATER)) && islandlevels.containsKey(blockBreakEvent.getBlock().getLocation().getWorld().getName()) && (double)(level = islandlevels.get(blockBreakEvent.getBlock().getLocation().getWorld().getName()).intValue()) >= generatorValues.get("CobblestoneLevelIntervall") && (additionalDropsAmount = this.rollCobbleAmount(blockBreakEvent.getBlock().getLocation().getWorld().getName())) != 0) {
            blockBreakEvent.getBlock().getLocation().getWorld().dropItemNaturally(blockBreakEvent.getBlock().getLocation(), new ItemStack(Material.COBBLESTONE, additionalDropsAmount));
        }
    }

    @EventHandler
    public void pistonEvent(BlockPistonExtendEvent blockPistonExtendEvent) {
        if (!blockPistonExtendEvent.getBlocks().isEmpty() && ((Block)blockPistonExtendEvent.getBlocks().get(0)).getType().equals((Object)Material.INFESTED_COBBLESTONE)) {
            blockPistonExtendEvent.setCancelled(true);
            ((Block)blockPistonExtendEvent.getBlocks().get(0)).setType(Material.COBBLESTONE);
            cobblegen.put((Object)((Block)blockPistonExtendEvent.getBlocks().get(0)).getLocation(), (Object)System.currentTimeMillis());
        }
    }

    private Material rollCoalLevel(Location location) {
        double random = Math.random();
        double chance = generatorValues.get("CoalChance") / 100.0;
        if (chance >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollIronLevel(Location location) {
        double random = Math.random();
        double chanceIron = generatorValues.get("IronChance") / 100.0;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollRedstoneLevel(Location location) {
        double random = Math.random();
        double chanceRedstone = generatorValues.get("RedstoneChance") / 100.0;
        double chanceIron = generatorValues.get("IronChance") / 100.0 + chanceRedstone;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceRedstone >= random) {
            return Material.REDSTONE_ORE;
        }
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollLapisLevel(Location location) {
        double random = Math.random();
        double chanceLapis = generatorValues.get("LapisChance") / 100.0;
        double chanceRedstone = generatorValues.get("RedstoneChance") / 100.0 + chanceLapis;
        double chanceIron = generatorValues.get("IronChance") / 100.0 + chanceRedstone;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceLapis >= random) {
            return Material.LAPIS_ORE;
        }
        if (chanceRedstone >= random) {
            return Material.REDSTONE_ORE;
        }
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollGoldLevel(Location location) {
        double random = Math.random();
        double chanceGold = generatorValues.get("GoldChance") / 100.0;
        double chanceLapis = generatorValues.get("LapisChance") / 100.0 + chanceGold;
        double chanceRedstone = generatorValues.get("RedstoneChance") / 100.0 + chanceLapis;
        double chanceIron = generatorValues.get("IronChance") / 100.0 + chanceRedstone;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceGold >= random) {
            return Material.GOLD_ORE;
        }
        if (chanceLapis >= random) {
            return Material.LAPIS_ORE;
        }
        if (chanceRedstone >= random) {
            return Material.REDSTONE_ORE;
        }
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollEmeraldLevel(Location location) {
        double random = Math.random();
        double chanceEmerald = generatorValues.get("EmeraldChance") / 100.0;
        double chanceGold = generatorValues.get("GoldChance") / 100.0 + chanceEmerald;
        double chanceLapis = generatorValues.get("LapisChance") / 100.0 + chanceGold;
        double chanceRedstone = generatorValues.get("RedstoneChance") / 100.0 + chanceLapis;
        double chanceIron = generatorValues.get("IronChance") / 100.0 + chanceRedstone;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceEmerald >= random) {
            return Material.EMERALD_ORE;
        }
        if (chanceGold >= random) {
            return Material.GOLD_ORE;
        }
        if (chanceLapis >= random) {
            return Material.LAPIS_ORE;
        }
        if (chanceRedstone >= random) {
            return Material.REDSTONE_ORE;
        }
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollDiamondLevel(Location location) {
        double random = Math.random();
        double chanceDiamond = generatorValues.get("DiamondChance") / 100.0;
        double chanceEmerald = generatorValues.get("EmeraldChance") / 100.0 + chanceDiamond;
        double chanceGold = generatorValues.get("GoldChance") / 100.0 + chanceEmerald;
        double chanceLapis = generatorValues.get("LapisChance") / 100.0 + chanceGold;
        double chanceRedstone = generatorValues.get("RedstoneChance") / 100.0 + chanceLapis;
        double chanceIron = generatorValues.get("IronChance") / 100.0 + chanceRedstone;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceDiamond >= random) {
            return Material.DIAMOND_ORE;
        }
        if (chanceEmerald >= random) {
            return Material.EMERALD_ORE;
        }
        if (chanceGold >= random) {
            return Material.GOLD_ORE;
        }
        if (chanceLapis >= random) {
            return Material.LAPIS_ORE;
        }
        if (chanceRedstone >= random) {
            return Material.REDSTONE_ORE;
        }
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private Material rollAncientDebrisLevel(Location location) {
        double random = Math.random();
        double chanceAncientDebris = generatorValues.get("AncientDebrisChance") / 100.0;
        double chanceDiamond = generatorValues.get("DiamondChance") / 100.0;
        double chanceEmerald = generatorValues.get("EmeraldChance") / 100.0 + chanceDiamond;
        double chanceGold = generatorValues.get("GoldChance") / 100.0 + chanceEmerald;
        double chanceLapis = generatorValues.get("LapisChance") / 100.0 + chanceGold;
        double chanceRedstone = generatorValues.get("RedstoneChance") / 100.0 + chanceLapis;
        double chanceIron = generatorValues.get("IronChance") / 100.0 + chanceRedstone;
        double chanceCoal = generatorValues.get("CoalChance") / 100.0 + chanceIron;
        if (chanceAncientDebris >= random) {
            return Material.ANCIENT_DEBRIS;
        }
        if (chanceDiamond >= random) {
            return Material.DIAMOND_ORE;
        }
        if (chanceEmerald >= random) {
            return Material.EMERALD_ORE;
        }
        if (chanceGold >= random) {
            return Material.GOLD_ORE;
        }
        if (chanceLapis >= random) {
            return Material.LAPIS_ORE;
        }
        if (chanceRedstone >= random) {
            return Material.REDSTONE_ORE;
        }
        if (chanceIron >= random) {
            return Material.IRON_ORE;
        }
        if (chanceCoal >= random) {
            return Material.COAL_ORE;
        }
        return this.getCobblestone(location);
    }

    private int rollCobbleAmount(String island) {
        double chance = generatorValues.get("CobblestoneChance") / 100.0;
        int chances = (int)((double)islandlevels.get(island).intValue() / generatorValues.get("CobblestoneLevelIntervall"));
        int drops = 0;
        for (int i = 0; i < chances; ++i) {
            double random = Math.random();
            if (!(chance >= random)) continue;
            ++drops;
        }
        return drops;
    }

    private Material getCobblestone(Location loc) {
        if (cobblegen.getIfPresent((Object)loc) != null) {
            return Material.COBBLESTONE;
        }
        return Material.INFESTED_COBBLESTONE;
    }
}

