/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Listener;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.scheduler.BukkitTask;

public class EntityProtector
implements Listener {
    private final VSkyblock plugin;
    private static final Cache<LivingEntity, BukkitTask> nocollideentities = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.SECONDS).build();

    public EntityProtector(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPVP(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity player = entityDamageByEntityEvent.getDamager();
        Entity damagedplayer = entityDamageByEntityEvent.getEntity();
        boolean pvpisland = ConfigShorts.getDefConfig().getBoolean("PvPIslands");
        boolean pvpnether = ConfigShorts.getDefConfig().getBoolean("PvPNether");
        if (player.getType().equals((Object)EntityType.PLAYER) && damagedplayer.getType().equals((Object)EntityType.PLAYER)) {
            if (Island.playerislands.get(player.getUniqueId()) != null) {
                if (player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                    if (!pvpnether) {
                        entityDamageByEntityEvent.setCancelled(true);
                    }
                } else {
                    if (!Island.playerislands.get(player.getUniqueId()).equals(Island.playerislands.get(damagedplayer.getUniqueId()))) {
                        entityDamageByEntityEvent.setCancelled(true);
                    }
                    if (!pvpisland) {
                        entityDamageByEntityEvent.setCancelled(true);
                    }
                }
            } else {
                entityDamageByEntityEvent.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void islandVisitProtection(EntityDamageEvent entityDamageEvent) {
        Player player;
        Entity entity = entityDamageEvent.getEntity();
        if (entity instanceof Player && (player = (Player)entity).getWorld().getEnvironment() != World.Environment.NETHER && !player.getWorld().getName().equals(Island.playerislands.get(player.getUniqueId()))) {
            entityDamageEvent.setCancelled(true);
            if (entityDamageEvent.getCause() == EntityDamageEvent.DamageCause.VOID || player.getLocation().getY() < 0.0) {
                player.setFallDistance(0.0f);
                player.teleportAsync(this.plugin.getWorldManager().getSpawnLocation(ConfigShorts.getDefConfig().getString("SpawnWorld")));
            }
        }
    }

    @EventHandler
    public void entityprotector(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        Entity entity = entityDamageByEntityEvent.getDamager();
        Player player = null;
        if (entity instanceof Player) {
            player = (Player)entity;
        } else if (entity instanceof Projectile && ((Projectile)entity).getShooter() instanceof Player) {
            player = (Player)((Projectile)entity).getShooter();
        } else if (entity instanceof TNTPrimed) {
            player = this.getSource((TNTPrimed)entity);
        }
        if (player != null && !entity.getWorld().getName().equals(Island.playerislands.get(player.getUniqueId())) && entity.getWorld().getEnvironment() != World.Environment.NETHER && !player.hasPermission("VSkyblock.IgnoreProtected")) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    private Player getSource(TNTPrimed tnt) {
        if (tnt.getSource() != null && tnt.getSource().isValid()) {
            if (tnt.getSource() instanceof Player) {
                return (Player)tnt.getSource();
            }
            if (tnt.getSource() instanceof Projectile) {
                return this.getShooter((Projectile)tnt.getSource());
            }
            if (tnt.getSource() instanceof TNTPrimed) {
                return this.getSource(tnt);
            }
        }
        return null;
    }

    private Player getShooter(Projectile projectile) {
        if (projectile.getShooter() instanceof Player) {
            return (Player)projectile.getShooter();
        }
        return null;
    }

    @EventHandler
    public void targetPlayer(EntityTargetEvent entityTargetEvent) {
        Entity entity = entityTargetEvent.getTarget();
        if (entity instanceof Player && !entity.getWorld().getName().equals(Island.playerislands.get(entity.getUniqueId())) && !entity.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            entityTargetEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void inventoryListener(InventoryOpenEvent inventoryOpenEvent) {
        Player player = (Player)inventoryOpenEvent.getPlayer();
        if (!(player.hasPermission("VSkyblock.IgnoreProtected") || player.getWorld().getName().equals(Island.playerislands.get(player.getUniqueId())) || player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER))) {
            inventoryOpenEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onWorldChange(PlayerChangedWorldEvent playerChangedWorldEvent) {
        Player player = playerChangedWorldEvent.getPlayer();
        if (player.getWorld().getName().equals(Island.playerislands.get(player.getUniqueId())) || player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
            player.setCollidable(true);
            player.setSleepingIgnored(false);
        } else {
            player.setCollidable(false);
            player.setSleepingIgnored(true);
        }
    }
}

