/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Listener;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGenerator;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class IslandOptionsInventoryHandler
implements Listener {
    private final VSkyblock plugin;

    public IslandOptionsInventoryHandler(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void isOptionsHandler(InventoryClickEvent inventoryClickEvent) {
        Player player = (Player)inventoryClickEvent.getWhoClicked();
        if (inventoryClickEvent.getView().getTitle().equalsIgnoreCase(this.getInvName())) {
            inventoryClickEvent.setCancelled(true);
            int slot = inventoryClickEvent.getRawSlot();
            int visitslot = 2;
            int generatorslot = 4;
            int difficultyslot = 6;
            int confirmslot = 17;
            String visitalloweditem = ConfigShorts.getOptionsConfig().getString("Visit.AllowedItem");
            String visitnotalloweditem = ConfigShorts.getOptionsConfig().getString("Visit.NotAllowedItem");
            String visitneedrequestitem = ConfigShorts.getOptionsConfig().getString("Visit.NeedsRequestItem");
            String difficultynormalitem = ConfigShorts.getOptionsConfig().getString("Difficulty.NormalItem");
            String difficultyharditem = ConfigShorts.getOptionsConfig().getString("Difficulty.HardItem");
            String difficultyeasyitem = ConfigShorts.getOptionsConfig().getString("Difficulty.EasyItem");
            if (slot == visitslot) {
                if (inventoryClickEvent.getCurrentItem().getType().equals((Object)this.getMaterial(visitnotalloweditem))) {
                    inventoryClickEvent.getInventory().setItem(visitslot, this.getItemStack("visit", "Allowed"));
                } else if (inventoryClickEvent.getCurrentItem().getType().equals((Object)this.getMaterial(visitalloweditem))) {
                    inventoryClickEvent.getInventory().setItem(visitslot, this.getItemStack("visit", "NeedsRequest"));
                } else {
                    inventoryClickEvent.getInventory().setItem(visitslot, this.getItemStack("visit", "NotAllowed"));
                }
            } else if (slot == difficultyslot) {
                if (inventoryClickEvent.getCurrentItem().getType().equals((Object)this.getMaterial(difficultynormalitem))) {
                    inventoryClickEvent.getInventory().setItem(difficultyslot, this.getItemStack("difficulty", "Hard"));
                } else if (inventoryClickEvent.getCurrentItem().getType().equals((Object)this.getMaterial(difficultyharditem))) {
                    inventoryClickEvent.getInventory().setItem(difficultyslot, this.getItemStack("difficulty", "Easy"));
                } else if (inventoryClickEvent.getCurrentItem().getType().equals((Object)this.getMaterial(difficultyeasyitem))) {
                    inventoryClickEvent.getInventory().setItem(difficultyslot, this.getItemStack("difficulty", "Normal"));
                }
            } else if (slot == generatorslot) {
                if (inventoryClickEvent.getCurrentItem().getType().equals((Object)Material.COBBLESTONE)) {
                    inventoryClickEvent.getWhoClicked().closeInventory();
                    inventoryClickEvent.getWhoClicked().openInventory(this.getGeneratorMenu(inventoryClickEvent.getWhoClicked().getUniqueId()));
                }
            } else if (slot == confirmslot && inventoryClickEvent.getCurrentItem().getType().equals((Object)Material.LIME_WOOL)) {
                boolean visit = true;
                boolean needRequest = false;
                String difficulty = "NORMAL";
                if (inventoryClickEvent.getInventory().getItem(visitslot).getType().equals((Object)this.getMaterial(visitnotalloweditem))) {
                    visit = false;
                } else if (inventoryClickEvent.getInventory().getItem(visitslot).getType().equals((Object)this.getMaterial(visitneedrequestitem))) {
                    needRequest = true;
                }
                if (inventoryClickEvent.getInventory().getItem(difficultyslot).getType().equals((Object)this.getMaterial(difficultyharditem))) {
                    difficulty = "HARD";
                } else if (inventoryClickEvent.getInventory().getItem(difficultyslot).getType().equals((Object)this.getMaterial(difficultyeasyitem))) {
                    difficulty = "EASY";
                }
                player.closeInventory();
                ConfigShorts.messagefromString("UpdatedIslandOptions", (CommandSender)player);
                String finalDifficulty = difficulty;
                this.plugin.getDb().getWriter().updateIslandOptions(player, visit, needRequest, difficulty, done -> this.plugin.getDb().getReader().getislandnamefromplayer(player.getUniqueId(), result -> this.updateIsland(result, finalDifficulty)));
            }
        }
    }

    @EventHandler
    public void isOptionsHandler2(InventoryDragEvent inventoryDragEvent) {
        if (inventoryDragEvent.getView().getTitle().equalsIgnoreCase(this.getInvName())) {
            inventoryDragEvent.setCancelled(true);
        }
    }

    private ItemStack getItemStack(String item, String option) {
        Material mat;
        switch (item) {
            case "visit": {
                String visititem = ConfigShorts.getOptionsConfig().getString("Visit." + option + "Item");
                mat = this.getMaterial(visititem);
                break;
            }
            case "difficulty": {
                String difficultyitem = ConfigShorts.getOptionsConfig().getString("Difficulty." + option + "Item");
                mat = this.getMaterial(difficultyitem);
                break;
            }
            default: {
                mat = Material.BARRIER;
            }
        }
        ItemStack itemStack = new ItemStack(mat, 1);
        ItemMeta itemMeta = itemStack.getItemMeta();
        switch (item) {
            case "visit": {
                itemMeta.setDisplayName(this.getDisplayNameVisit(option));
                break;
            }
            case "difficulty": {
                itemMeta.setDisplayName(this.getDisplayNameDifficulty(option));
                break;
            }
        }
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
        itemMeta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ENCHANTS});
        itemMeta.addItemFlags(ItemFlag.values());
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    private void updateIsland(String islandname, String difficulty) {
        if (this.plugin.getServer().getWorld(islandname) != null) {
            this.plugin.getServer().getWorld(islandname).setDifficulty(Difficulty.valueOf((String)difficulty.toUpperCase()));
        }
    }

    private Material getMaterial(String material) {
        if (Material.getMaterial((String)material) != null) {
            return Material.getMaterial((String)material);
        }
        return Material.BARRIER;
    }

    private String getInvName() {
        if (ConfigShorts.getOptionsConfig().getString("InventoryName") != null) {
            String invname = ConfigShorts.getOptionsConfig().getString("InventoryName");
            return invname;
        }
        return "Island options";
    }

    private String getDisplayNameDifficulty(String difficulty) {
        String displayname = ConfigShorts.getOptionsConfig().getString("Difficulty." + difficulty);
        if (displayname != null) {
            return displayname;
        }
        return difficulty;
    }

    private String getDisplayNameVisit(String allowed) {
        String displayname = ConfigShorts.getOptionsConfig().getString("Visit." + allowed);
        if (displayname != null) {
            return displayname;
        }
        return allowed;
    }

    private Inventory getGeneratorMenu(UUID playerUUID) {
        Inventory genInv = Bukkit.createInventory(null, (int)27, (String)this.getDisplayNameGenerator());
        int slotCobbleDropChance = 10;
        int slotChancesOverview = 13;
        int slotUpgradeButton = 16;
        ItemStack frames = new ItemStack(Material.BLACK_STAINED_GLASS_PANE, 1);
        ItemMeta framesMeta = frames.getItemMeta();
        framesMeta.setDisplayName(" ");
        frames.setItemMeta(framesMeta);
        for (int i = 0; i < 27; ++i) {
            if (i == slotCobbleDropChance || i == slotChancesOverview || i == slotUpgradeButton) continue;
            genInv.setItem(i, frames);
        }
        ItemStack upgradeButton = this.getUpgradeButton(playerUUID);
        genInv.setItem(slotUpgradeButton, upgradeButton);
        ItemStack cobbleDropChance = this.getCobbleDropChanceInfo(playerUUID);
        genInv.setItem(slotCobbleDropChance, cobbleDropChance);
        ItemStack chancesOverview = this.getChancesOverview(playerUUID);
        genInv.setItem(slotChancesOverview, chancesOverview);
        return genInv;
    }

    private ItemStack getUpgradeButton(UUID playerUUID) {
        String island = Island.playerislands.get(playerUUID);
        Integer currentGeneratorLevel = CobblestoneGenerator.islandGenLevel.get(island);
        Integer nextGeneratorLevel = currentGeneratorLevel + 1;
        boolean canUpgrade = nextGeneratorLevel <= 8;
        String upgradeButtonItem = !canUpgrade ? ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Max_Level.Item") : ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Level_" + nextGeneratorLevel + ".Item");
        Material mat = this.getMaterial(upgradeButtonItem);
        ItemStack upgradeButton = new ItemStack(mat, 1);
        ItemMeta upgradeButtonMeta = upgradeButton.getItemMeta();
        upgradeButtonMeta.setDisplayName(this.getDisplayNameGeneratorUpgradeButton(nextGeneratorLevel));
        upgradeButtonMeta.setLore(this.getDescriptionGeneratorUpgradeButton(nextGeneratorLevel));
        if (canUpgrade) {
            upgradeButtonMeta.addEnchant(Enchantment.DURABILITY, 1, true);
        }
        upgradeButtonMeta.addItemFlags(ItemFlag.values());
        upgradeButton.setItemMeta(upgradeButtonMeta);
        return upgradeButton;
    }

    private ItemStack getCobbleDropChanceInfo(UUID playerUUID) {
        String island = Island.playerislands.get(playerUUID);
        Integer currentIslandLevel = CobblestoneGenerator.islandlevels.get(island);
        Double levelIntervall = CobblestoneGenerator.generatorValues.get("CobblestoneLevelIntervall");
        int maxDrops = (int)((double)currentIslandLevel.intValue() / levelIntervall + 1.0);
        Material mat = Material.COBBLESTONE;
        ItemStack cobbleDropChanceInfo = new ItemStack(mat, 1);
        ItemMeta cobbleDropChanceInfoMeta = cobbleDropChanceInfo.getItemMeta();
        cobbleDropChanceInfoMeta.setDisplayName(this.getDisplayNameCobbleDropChance());
        cobbleDropChanceInfoMeta.setLore(this.getDescriptionCobblestoneDropChance(maxDrops));
        cobbleDropChanceInfoMeta.addItemFlags(ItemFlag.values());
        cobbleDropChanceInfo.setItemMeta(cobbleDropChanceInfoMeta);
        return cobbleDropChanceInfo;
    }

    private ItemStack getChancesOverview(UUID playerUUID) {
        String island = Island.playerislands.get(playerUUID);
        Integer currentgeneratorLevel = CobblestoneGenerator.islandGenLevel.get(island);
        String chancesOverviewItem = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.Level_" + currentgeneratorLevel + "_Item");
        Material mat = this.getMaterial(chancesOverviewItem);
        ItemStack chancesOverview = new ItemStack(mat, 1);
        ItemMeta chancesOverviewMeta = chancesOverview.getItemMeta();
        chancesOverviewMeta.setDisplayName(this.getDisplayNameChancesOverview());
        chancesOverviewMeta.setLore(this.getDescriptionChancesOverview(currentgeneratorLevel));
        chancesOverviewMeta.addItemFlags(ItemFlag.values());
        chancesOverview.setItemMeta(chancesOverviewMeta);
        return chancesOverview;
    }

    private String getDisplayNameGenerator() {
        String displayname = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.DisplayName");
        if (displayname != null) {
            return displayname;
        }
        return "Cobblestone-Generator";
    }

    private String getDisplayNameGeneratorUpgradeButton(Integer nextGeneratorLevel) {
        String displayname = nextGeneratorLevel > 8 ? ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.DisplayNameMaxLevel") : ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.DisplayName");
        if (displayname != null) {
            return displayname;
        }
        return "Upgrade";
    }

    private String getDisplayNameCobbleDropChance() {
        String displayname = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.CobbleDropChance");
        if (displayname != null) {
            return displayname;
        }
        return "Cobblestone Drops";
    }

    private String getDisplayNameChancesOverview() {
        String displayname = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.Overview");
        if (displayname != null) {
            return displayname;
        }
        return "Cobblestone-Generator Drops";
    }

    private List<String> getDescriptionGeneratorUpgradeButton(Integer nextGeneratorLevel) {
        ArrayList<String> descriptionList = new ArrayList<String>();
        if (nextGeneratorLevel > 8) {
            String description = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Max_Level.Description");
            descriptionList.addAll(this.splitString(description));
        } else {
            String overlay = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Adds");
            String description = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Level_" + nextGeneratorLevel + ".AddsFeature");
            if (overlay != null) {
                descriptionList.addAll(this.splitString(overlay));
            }
            if (description != null) {
                descriptionList.addAll(this.splitString(description));
            }
            String neededItemsColorCode = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.NeededColor");
            String neededLevel = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.NeededLevel");
            String neededLevelNumber = neededItemsColorCode + this.getRequiredIslandLevel(nextGeneratorLevel);
            neededLevel = neededLevel.replace("%number%", neededLevelNumber);
            String neededItemsStart = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Needed");
            String neededItems = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Upgrade.Level_" + nextGeneratorLevel + ".NeededText");
            if (neededItemsColorCode != null) {
                neededItems = neededItemsColorCode + neededItems;
            }
            descriptionList.add("");
            descriptionList.add(neededLevel);
            descriptionList.addAll(this.splitString(neededItemsStart));
            descriptionList.addAll(this.splitString(neededItems));
        }
        return descriptionList;
    }

    private List<String> getDescriptionCobblestoneDropChance(Integer maxDrops) {
        String maxDropsLine = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.CobbleDropChanceMax");
        maxDropsLine = maxDropsLine != null ? (maxDropsLine.contains("%number%") ? maxDropsLine.replace("%number%", String.valueOf(maxDrops)) : maxDropsLine + " " + maxDrops) : "Max Drops: " + maxDrops;
        String description = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.CobbleDropChanceDescription");
        ArrayList<String> descriptionList = new ArrayList<String>();
        descriptionList.addAll(this.splitString(maxDropsLine));
        if (description != null) {
            descriptionList.addAll(this.splitString(description));
        }
        return descriptionList;
    }

    private List<String> getDescriptionChancesOverview(Integer currentGeneratorLevel) {
        if (currentGeneratorLevel == 0) {
            if (ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.Level_0_Info") != null) {
                return this.splitString(ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.Level_0_Info"));
            }
            return this.splitString("No additional items, only cobblestone");
        }
        boolean showPercentagePerItem = true;
        if (ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.ShowPercentagePerItem").equalsIgnoreCase("false")) {
            showPercentagePerItem = false;
        }
        ArrayList<String> descriptionList = new ArrayList<String>();
        for (int i = 1; i <= currentGeneratorLevel; ++i) {
            String chanceInfoText = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.Level_" + i + "_Info");
            String chanceInfo = ConfigShorts.getOptionsConfig().getString("CobblestoneGenerator.Chances.ChanceInfo");
            if (chanceInfo.contains("%number%")) {
                switch (i) {
                    case 1: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("CoalChance")));
                        break;
                    }
                    case 2: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("IronChance")));
                        break;
                    }
                    case 3: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("RedstoneChance")));
                        break;
                    }
                    case 4: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("LapisChance")));
                        break;
                    }
                    case 5: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("GoldChance")));
                        break;
                    }
                    case 6: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("EmeraldChance")));
                        break;
                    }
                    case 7: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("DiamondChance")));
                        break;
                    }
                    case 8: {
                        chanceInfo = chanceInfo.replace("%number%", String.valueOf(CobblestoneGenerator.generatorValues.get("AncientDebrisChance")));
                    }
                }
            }
            descriptionList.addAll(this.splitString(chanceInfoText));
            if (!showPercentagePerItem) continue;
            descriptionList.addAll(this.splitString(chanceInfo));
        }
        return descriptionList;
    }

    private List<String> splitString(String string) {
        StringBuilder colorCode = new StringBuilder();
        String withoutcolorCode = string;
        for (int i = 1; i > 0; ++i) {
            if (withoutcolorCode.contains("\u00a7")) {
                colorCode.append(withoutcolorCode, 0, 2);
                withoutcolorCode = withoutcolorCode.substring(2);
                continue;
            }
            i = -1;
        }
        List<Object> wordbyword = new ArrayList<String>();
        if (string.length() < 35) {
            wordbyword.add(string);
        } else {
            wordbyword = Arrays.asList(string.split(" "));
        }
        ArrayList<String> splittedString = new ArrayList<String>();
        int i = 0;
        String currentLine = null;
        for (String string2 : wordbyword) {
            if ((i += string2.length()) > 35) {
                if (string2.length() >= 35) {
                    splittedString.add(colorCode + currentLine);
                    splittedString.add(string2);
                    i = 0;
                    currentLine = null;
                } else {
                    splittedString.add(colorCode + currentLine);
                    currentLine = string2;
                    i = string2.length();
                }
            } else {
                currentLine = currentLine == null ? string2 : currentLine + " " + string2;
            }
            if (!((String)wordbyword.get(wordbyword.size() - 1)).equals(string2)) continue;
            splittedString.add(colorCode + currentLine);
        }
        return splittedString;
    }

    private Double getRequiredIslandLevel(int nextGeneratorLevel) {
        switch (nextGeneratorLevel) {
            case 1: {
                return CobblestoneGenerator.generatorValues.get("CoalLevel");
            }
            case 2: {
                return CobblestoneGenerator.generatorValues.get("IronLevel");
            }
            case 3: {
                return CobblestoneGenerator.generatorValues.get("RedstoneLevel");
            }
            case 4: {
                return CobblestoneGenerator.generatorValues.get("LapisLevel");
            }
            case 5: {
                return CobblestoneGenerator.generatorValues.get("GoldLevel");
            }
            case 6: {
                return CobblestoneGenerator.generatorValues.get("EmeraldLevel");
            }
            case 7: {
                return CobblestoneGenerator.generatorValues.get("DiamondLevel");
            }
            case 8: {
                return CobblestoneGenerator.generatorValues.get("AncientDebrisLevel");
            }
        }
        return null;
    }
}

