/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Listener;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerTeleportEvent;

public class NetherPortalListener
implements Listener {
    private final VSkyblock plugin;
    public static Cache<UUID, Location> setNetherHome = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();
    public static Cache<UUID, Location> teleportToNetherHome = CacheBuilder.newBuilder().expireAfterWrite(20L, TimeUnit.SECONDS).build();

    public NetherPortalListener(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onNetherPortalUse(PlayerPortalEvent playerPortalEvent) {
        Player player = playerPortalEvent.getPlayer();
        playerPortalEvent.setCancelled(true);
        Location location = playerPortalEvent.getFrom();
        if (playerPortalEvent.getCause().equals((Object)PlayerTeleportEvent.TeleportCause.NETHER_PORTAL)) {
            this.plugin.getDb().getReader().getPlayerData(player.getUniqueId().toString(), result -> {
                if (player.getWorld().getName().equals(result.getIslandname())) {
                    player.teleportAsync(this.plugin.getWorldManager().getSpawnLocation(ConfigShorts.getDefConfig().getString("NetherWorld"))).whenComplete((b, e) -> {
                        ConfigShorts.messagefromString("NetherJoin1", (CommandSender)player);
                        ConfigShorts.messagefromString("NetherJoin2", (CommandSender)player);
                        this.plugin.getDb().getReader().getNetherHome(result.getUuid(), netherhome -> {
                            if (netherhome != null) {
                                teleportToNetherHome.put((Object)result.getUuid(), (Object)netherhome);
                                ConfigShorts.messagefromString("TeleportToNetherHome", (CommandSender)player);
                            }
                        });
                        if (e != null) {
                            e.printStackTrace();
                        }
                    });
                } else if (player.getWorld().getEnvironment().equals((Object)World.Environment.NETHER)) {
                    if (result.getIslandname() != null) {
                        player.teleportAsync(Island.islandhomes.get(result.getIslandname()));
                        this.plugin.getDb().getReader().getNetherHome(result.getUuid(), netherhome -> {
                            if (netherhome != null) {
                                if (result.isIslandowner() && netherhome.distance(location) > 10.0) {
                                    setNetherHome.put((Object)result.getUuid(), (Object)location);
                                    ConfigShorts.messagefromString("SetNewNetherHome", (CommandSender)player);
                                }
                            } else {
                                this.plugin.getDb().getWriter().saveNetherHome(result.getIslandId(), location);
                            }
                        });
                    } else {
                        player.teleportAsync(this.plugin.getWorldManager().getSpawnLocation(ConfigShorts.getDefConfig().getString("SpawnWorld")));
                    }
                }
            });
        }
    }
}

