/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Listener;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseCache;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.github.Viduality.VSkyblock.WorldGenerator.MasterIslandGenerator;
import java.util.ArrayDeque;
import java.util.Deque;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitTask;

public class PlayerJoinListener
implements Listener {
    private final VSkyblock plugin;
    private final Deque<DatabaseCache> toLoad = new ArrayDeque<DatabaseCache>();

    public PlayerJoinListener(VSkyblock plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onPlayerJoinEvent(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (this.plugin.getWorldManager().getUnloadedWorlds().contains(ConfigShorts.getDefConfig().getString("SpawnWorld"))) {
            this.plugin.getWorldManager().loadWorld(ConfigShorts.getDefConfig().getString("SpawnWorld"));
        }
        if (this.plugin.getWorldManager().getUnloadedWorlds().contains(ConfigShorts.getDefConfig().getString("NetherWorld"))) {
            this.plugin.getWorldManager().loadWorld(ConfigShorts.getDefConfig().getString("NetherWorld"));
        }
        this.plugin.getDb().getReader().getPlayerData(player.getUniqueId().toString(), result -> {
            if (result.getUuid() == null) {
                this.plugin.getDb().getWriter().addPlayer(player.getUniqueId(), player.getName());
            } else if (player.isOnline()) {
                if (!result.getName().equals(player.getName())) {
                    this.plugin.getDb().getWriter().updatePlayerName(player.getUniqueId(), player.getName());
                }
                if (this.plugin.scoreboardmanager.doesobjectiveexist("deaths") && this.plugin.scoreboardmanager.addPlayerToObjective(player, "deaths")) {
                    this.plugin.scoreboardmanager.updatePlayerScore(player.getName(), "deaths", result.getDeathCount());
                }
                if (result.getIslandname() != null) {
                    PotionEffect potionEffectBlindness = new PotionEffect(PotionEffectType.BLINDNESS, 600, 1);
                    PotionEffect potionEffectNightVision = new PotionEffect(PotionEffectType.NIGHT_VISION, 600, 1);
                    player.addPotionEffect(potionEffectBlindness);
                    player.addPotionEffect(potionEffectNightVision);
                    Location location = player.getLocation();
                    location.setPitch(-90.0f);
                    player.teleport(location);
                    BukkitTask task = Island.emptyloadedislands.remove(result.getIslandname());
                    if (task != null) {
                        task.cancel();
                    }
                    this.plugin.getDb().getReader().getIslandChallenges(result.getIslandId(), challenges -> {
                        if (player.isOnline()) {
                            this.plugin.getScoreboardManager().updateTracked(player, challenges);
                        }
                    });
                    this.toLoad.add(result);
                    if (this.toLoad.size() == 1) {
                        this.loadWorld(result);
                    }
                } else {
                    player.teleportAsync(this.plugin.getWorldManager().getSpawnLocation(ConfigShorts.getDefConfig().getString("SpawnWorld"))).whenComplete((b, e) -> {
                        player.removePotionEffect(PotionEffectType.BLINDNESS);
                        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                    });
                    if (result.isKicked()) {
                        ConfigShorts.messagefromString("KickedFromIslandOffline", (CommandSender)player);
                        player.setTotalExperience(0);
                        player.setExp(0.0f);
                        player.getEnderChest().clear();
                        player.getInventory().clear();
                        this.plugin.getDb().getWriter().removeKicked(result.getUuid());
                    }
                }
            }
        });
        if (this.plugin.getServer().getWorld("VSkyblockMasterIsland") == null && !this.plugin.getWorldManager().getUnloadedWorlds().contains("VSkyblockMasterIsland")) {
            ConfigShorts.broadcastfromString("MasterIsland");
            new MasterIslandGenerator(this.plugin).create(result -> {
                this.plugin.getWorldManager().unloadWorld(result);
                ConfigShorts.broadcastfromString("MasterIslandReady");
            });
        }
    }

    private void loadWorld(DatabaseCache result) {
        if (!Island.playerislands.containsValue(result.getIslandname())) {
            this.plugin.getDb().getReader().addToCobbleStoneGenerators(result.getIslandname());
        }
        if (!this.plugin.getWorldManager().loadWorld(result.getIslandname())) {
            ConfigShorts.custommessagefromString("WorldFailedToLoad", (CommandSender)result.getPlayer(), result.getIslandname());
            this.toLoad.remove(result);
            DatabaseCache nextResult = this.toLoad.peekFirst();
            if (nextResult != null) {
                this.loadWorld(nextResult);
            }
            return;
        }
        Island.playerislands.put(result.getUuid(), result.getIslandname());
        this.plugin.getDb().getReader().getIslandSpawn(result.getIslandname(), islandspawn -> {
            if (!Island.islandhomes.containsKey(result.getIslandname())) {
                Island.islandhomes.put(result.getIslandname(), islandspawn);
            }
            this.plugin.getDb().getReader().getlastLocation(result.getUuid(), loc -> {
                Player player = result.getPlayer();
                if (player != null) {
                    if (loc == null) {
                        loc = islandspawn;
                    }
                    Location finalLoc = loc;
                    loc.getWorld().getChunkAtAsync(loc).whenComplete((c, e) -> {
                        if (e != null) {
                            e.printStackTrace();
                        }
                        player.removePotionEffect(PotionEffectType.BLINDNESS);
                        player.removePotionEffect(PotionEffectType.NIGHT_VISION);
                        if (c != null) {
                            Block below = finalLoc.getBlock().getRelative(BlockFace.DOWN);
                            if (below.getType() == Material.AIR) {
                                below.setType(Material.INFESTED_COBBLESTONE);
                            }
                            player.teleport(finalLoc);
                        } else {
                            ConfigShorts.custommessagefromString("WorldFailedToLoad", (CommandSender)player, result.getIslandname());
                        }
                    });
                } else {
                    Island.emptyloadedislands.put(result.getIslandname(), this.plugin.getServer().getScheduler().runTaskLater((Plugin)this.plugin, () -> {
                        this.plugin.getWorldManager().unloadWorld(result.getIslandname());
                        Island.islandhomes.remove(result.getIslandname());
                    }, 1200L));
                }
                this.toLoad.remove(result);
                DatabaseCache nextResult = this.toLoad.peekFirst();
                if (nextResult != null) {
                    this.loadWorld(nextResult);
                }
            });
        });
    }
}

