/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock;

import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseReader;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseWriter;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.github.Viduality.shaded.hikari.HikariConfig;
import com.github.Viduality.shaded.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;

public class SQLConnector {
    private final HikariDataSource ds;
    private final DatabaseReader databaseReader;
    private final DatabaseWriter databaseWriter;

    public SQLConnector(VSkyblock plugin) {
        this.databaseReader = new DatabaseReader(plugin, this);
        this.databaseWriter = new DatabaseWriter(plugin, this);
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl("jdbc:mysql://" + this.getDbUrl() + "/" + this.getDatabase());
        config.setUsername(this.getDbUser());
        config.setPassword(this.getDbPassword());
        config.addDataSourceProperty("cachePrepStmts", "true");
        config.addDataSourceProperty("prepStmtCacheSize", "250");
        config.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        this.ds = new HikariDataSource(config);
    }

    public String getDbUser() {
        return ConfigShorts.getDefConfig().getString("database.user");
    }

    public String getDbPassword() {
        return ConfigShorts.getDefConfig().getString("database.password");
    }

    public String getDatabase() {
        return ConfigShorts.getDefConfig().getString("database.database");
    }

    public String getDbUrl() {
        return ConfigShorts.getDefConfig().getString("database.url");
    }

    public String getDbUrlParameters() {
        return ConfigShorts.getDefConfig().getString("database.url-parameters");
    }

    public void initConnection() {
        if (this.getDatabase() != null && !this.getDatabase().isEmpty()) {
            this.initTables();
        }
    }

    public DatabaseReader getReader() {
        return this.databaseReader;
    }

    public DatabaseWriter getWriter() {
        return this.databaseWriter;
    }

    public Connection getConnection() {
        try {
            return this.ds.getConnection();
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void initTables() {
        try {
            Connection connection = this.getConnection();
            connection.createStatement().execute("CREATE DATABASE IF NOT EXISTS " + this.getDatabase());
            connection.createStatement().execute("CREATE TABLE IF NOT EXISTS VSkyblock_Player(playername VARCHAR(16) NOT NULL,uuid CHAR(64) UNIQUE NOT NULL,islandid BIGINT,islandowner BOOLEAN NOT NULL DEFAULT false,owneruuid CHAR(32),kicked BOOLEAN NOT NULL DEFAULT false,deaths BIGINT DEFAULT 0,lastX DOUBLE,lastY DOUBLE,lastZ DOUBLE,lastPitch DOUBLE,lastYaw DOUBLE,lastWorld CHAR(128),highestreachedlevel VARCHAR(100) DEFAULT 0,PRIMARY KEY (playername));");
            connection.createStatement().execute("CREATE TABLE IF NOT EXISTS VSkyblock_Island(islandid BIGINT AUTO_INCREMENT NOT NULL,island VARCHAR(100) NOT NULL,islandlevel VARCHAR(100) DEFAULT 0,difficulty VARCHAR(100) NOT NULL DEFAULT 'NORMAL',visit BOOLEAN NOT NULL DEFAULT TRUE,visitneedsrequest BOOLEAN NOT NULL DEFAULT FALSE,cobblestonelevel BIGINT DEFAULT 0,totalblocks BIGINT DEFAULT 140,PRIMARY KEY (islandid))");
            connection.createStatement().execute("CREATE TABLE IF NOT EXISTS VSkyblock_IslandLocations(islandid BIGINT NOT NULL,spawnX DOUBLE NOT NULL DEFAULT 0,spawnY DOUBLE NOT NULL DEFAULT 67,spawnZ DOUBLE NOT NULL DEFAULT 0,spawnYaw FLOAT NOT NULL DEFAULT 0,spawnPitch FLOAT NOT NULL DEFAULT 0,netherX DOUBLE,netherY DOUBLE,netherZ DOUBLE,netherYaw FLOAT,netherWorld CHAR(128),PRIMARY KEY (islandid));");
            connection.createStatement().execute("CREATE TABLE IF NOT EXISTS VSkyblock_Challenges(islandid BIGINT NOT NULL,challenge VARCHAR(100) NOT NULL,count BIGINT DEFAULT 0,tracked BOOLEAN DEFAULT false,INDEX (islandid), UNIQUE (challenge, islandid));");
            connection.createStatement().execute("ALTER TABLE VSkyblock_Player ADD COLUMN IF NOT EXISTS(deaths BIGINT DEFAULT 0,lastX DOUBLE,lastY DOUBLE,lastZ DOUBLE,lastPitch DOUBLE,lastYaw DOUBLE,lastWorld CHAR(128),highestreachedlevel VARCHAR(100) DEFAULT 0);");
            connection.createStatement().execute("ALTER TABLE VSkyblock_Island ADD COLUMN IF NOT EXISTS(visitneedsrequest BOOLEAN NOT NULL DEFAULT FALSE,totalblocks BIGINT DEFAULT 140);");
            connection.createStatement().execute("ALTER TABLE VSkyblock_IslandLocations ADD COLUMN IF NOT EXISTS(spawnX DOUBLE,spawnY DOUBLE,spawnZ DOUBLE,spawnYaw FLOAT,spawnPitch FLOAT);");
            connection.createStatement().execute("ALTER TABLE VSkyblock_Challenges ADD COLUMN IF NOT EXISTS(tracked BOOLEAN DEFAULT false);");
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.ds.close();
    }
}

