/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Utilitys;

import com.github.Viduality.VSkyblock.Challenges.Challenge;
import com.github.Viduality.VSkyblock.Challenges.ChallengesInventoryCreator;
import com.github.Viduality.VSkyblock.Utilitys.StoredConfiguration;
import com.github.Viduality.VSkyblock.VSkyblock;
import com.github.Viduality.shaded.minedown.MineDown;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.api.chat.BaseComponent;
import org.apache.commons.lang.WordUtils;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class ConfigShorts {
    private static VSkyblock plugin = VSkyblock.getInstance();
    private static StoredConfiguration messagesConfig;
    private static StoredConfiguration challengesConfig;
    private static StoredConfiguration helpConfig;
    private static StoredConfiguration worldsConfig;
    private static StoredConfiguration optionsConfig;

    public static void messagefromString(String string, CommandSender sender) {
        if (sender == null) {
            return;
        }
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        sender.sendMessage(message);
    }

    public static void broadcastfromString(String string) {
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        plugin.getServer().broadcastMessage(message);
    }

    public static void broadcastChallengeCompleted(String string, String playername, Challenge challenge) {
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        String hover = ConfigShorts.createHover(challenge);
        String hoverableChallenge = "[&6" + challenge.getChallengeName() + "](hover=" + hover + ")";
        BaseComponent[] message1 = MineDown.parse(message, "Player", playername, "Challenge", hoverableChallenge);
        plugin.getServer().broadcast(new MineDown(MineDown.stringify(message1)).toComponent());
    }

    private static String createHover(Challenge challenge) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(ChallengesInventoryCreator.loreString);
        lore.addAll(ConfigShorts.splitString(challenge.getDescription(), ChallengesInventoryCreator.descriptioncolor));
        switch (challenge.getChallengeType()) {
            case onPlayer: {
                lore.add(ChallengesInventoryCreator.neededonPlayer);
                break;
            }
            case onIsland: {
                lore.add(ChallengesInventoryCreator.neededonIsland);
                break;
            }
            case islandLevel: {
                lore.add(ChallengesInventoryCreator.neededislandlevel);
            }
        }
        lore.addAll(ConfigShorts.splitString(challenge.getNeededText(), ChallengesInventoryCreator.descriptioncolor));
        StringBuilder hover = new StringBuilder();
        for (String loreLine : lore) {
            hover.append(loreLine);
            if (loreLine.equals(lore.get(lore.size() - 1))) continue;
            hover.append("\n");
        }
        return String.valueOf(hover);
    }

    private static List<String> splitString(String string, String colorCode) {
        List<Object> wordbyword = new ArrayList<String>();
        if (string.length() < 30) {
            wordbyword.add(string);
        } else {
            wordbyword = Arrays.asList(string.split(" "));
        }
        ArrayList<String> splittedString = new ArrayList<String>();
        int i = 0;
        String currentLine = null;
        for (String string2 : wordbyword) {
            if ((i += string2.length()) > 30) {
                if (string2.length() >= 30) {
                    splittedString.add(currentLine);
                    splittedString.add(string2);
                    i = 0;
                    currentLine = null;
                } else {
                    splittedString.add(colorCode + currentLine);
                    currentLine = string2;
                    i = string2.length();
                }
            } else {
                currentLine = currentLine == null ? string2 : currentLine + " " + string2;
            }
            if (!((String)wordbyword.get(wordbyword.size() - 1)).equals(string2)) continue;
            splittedString.add(colorCode + currentLine);
        }
        return splittedString;
    }

    public static void custommessagefromString(String string, Player player, String playername, String targetname) {
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        if (message.contains("%Player") && (message = message.replace("%Player%", playername)).contains("%SecondPlayer%")) {
            message = message.replace("%SecondPlayer%", targetname);
        }
        if (message.contains("%SecondPlayer%")) {
            message = message.replace("%SecondPlayer%", targetname);
        }
        player.sendMessage(message);
    }

    public static void custommessagefromString(String string, CommandSender sender, String replacement) {
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        if (message.contains("%replacement%")) {
            message = message.replace("%replacement%", replacement);
        }
        sender.sendMessage(message);
    }

    public static String getCustomString(String string, String replacement, String replacement2) {
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        if (message.contains("%replacement%")) {
            message = message.replace("%replacement%", replacement);
        }
        if (message.contains("%replacement2%")) {
            message = message.replace("%replacement2%", replacement2);
        }
        return message;
    }

    public static String getCustomString(String string) {
        String prefix = messagesConfig.getString("Prefix");
        String message = prefix + " " + messagesConfig.getString(string);
        return message;
    }

    private static String getLanguage() {
        return plugin.getConfig().getString("Language", "eng").toLowerCase();
    }

    private static void loadConfig() {
        plugin.saveDefaultConfig();
        plugin.reloadConfig();
    }

    static void reloadWorldConfig() throws IOException, InvalidConfigurationException {
        File worldsFile = new File(plugin.getDataFolder(), "Worlds.yml");
        worldsConfig = new StoredConfiguration(worldsFile);
        worldsConfig.load(worldsFile);
    }

    private static StoredConfiguration loadConfig(String name) {
        return ConfigShorts.loadConfig(name, name);
    }

    private static StoredConfiguration loadConfig(String folderName, String configName) {
        File folder = new File(plugin.getDataFolder(), folderName);
        File file = new File(folder, (configName.isEmpty() ? ConfigShorts.getLanguage() : configName + WordUtils.capitalize((String)ConfigShorts.getLanguage())) + ".yml");
        YamlConfiguration defaultConfig = new YamlConfiguration();
        try (InputStream stream = plugin.getResource(file.getName());){
            if (stream != null) {
                defaultConfig.load((Reader)new InputStreamReader(stream));
                if (!file.exists()) {
                    defaultConfig.save(file);
                }
            } else {
                System.out.println("Default config " + file.getName() + " does not exist in the plugin");
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            System.out.println("Error while ssving default config " + file.getName());
            e.printStackTrace();
        }
        if (!file.exists()) {
            file = new File(folder, configName.isEmpty() ? "eng" : configName + "Eng.yml");
        }
        StoredConfiguration config = new StoredConfiguration(file);
        if (file.exists()) {
            try {
                config.load(file);
            }
            catch (IOException | InvalidConfigurationException e) {
                System.out.println("Encountered an error while loading " + folderName + " config from " + file.getPath());
                e.printStackTrace();
            }
        } else {
            System.out.println("No possible file for the " + folderName + " config exists? Checked for " + ConfigShorts.getLanguage() + " and eng versions.");
        }
        config.setDefaults((Configuration)defaultConfig);
        return config;
    }

    public static void reloadAllConfigs() {
        try {
            ConfigShorts.loadConfig();
            messagesConfig = ConfigShorts.loadConfig("Languages", "");
            challengesConfig = ConfigShorts.loadConfig("Challenges");
            helpConfig = ConfigShorts.loadConfig("Help");
            optionsConfig = ConfigShorts.loadConfig("Options");
            ConfigShorts.reloadWorldConfig();
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }

    public static StoredConfiguration getWorldConfig() {
        return worldsConfig;
    }

    public static FileConfiguration getDefConfig() {
        return plugin.getConfig();
    }

    public static FileConfiguration getMessageConfig() {
        return messagesConfig;
    }

    public static FileConfiguration getOptionsConfig() {
        return optionsConfig;
    }

    public static FileConfiguration getHelpConfig() {
        return helpConfig;
    }

    public static FileConfiguration getChallengesConfig() {
        return challengesConfig;
    }
}

