/*
 * Decompiled with CFR 0.152.
 */
package com.github.Viduality.VSkyblock.Utilitys;

import com.github.Viduality.VSkyblock.Commands.Island;
import com.github.Viduality.VSkyblock.Listener.CobblestoneGenerator;
import com.github.Viduality.VSkyblock.SQLConnector;
import com.github.Viduality.VSkyblock.Utilitys.ChallengesCache;
import com.github.Viduality.VSkyblock.Utilitys.ConfigShorts;
import com.github.Viduality.VSkyblock.Utilitys.DatabaseCache;
import com.github.Viduality.VSkyblock.Utilitys.IslandOptionsCache;
import com.github.Viduality.VSkyblock.VSkyblock;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;

public class DatabaseReader {
    private final VSkyblock plugin;
    private final SQLConnector connector;

    public DatabaseReader(VSkyblock plugin, SQLConnector sqlConnector) {
        this.plugin = plugin;
        this.connector = sqlConnector;
    }

    public void getPlayerData(String uuid, Callback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            DatabaseCache databaseCache1 = new DatabaseCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Player WHERE uuid = ?");
                preparedStatement.setString(1, uuid);
                ResultSet r = preparedStatement.executeQuery();
                while (r.next()) {
                    databaseCache1.setUuid(r.getString("uuid"));
                    databaseCache1.setName(r.getString("playername"));
                    databaseCache1.setKicked(r.getBoolean("kicked"));
                    databaseCache1.setIslandowner(r.getBoolean("islandowner"));
                    databaseCache1.setIslandId(r.getInt("islandid"));
                    databaseCache1.setIslandowneruuid(r.getString("owneruuid"));
                    databaseCache1.setDeathCount(r.getInt("deaths"));
                }
                preparedStatement.close();
                if (databaseCache1.getIslandId() != 0) {
                    preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Island WHERE islandid = ?");
                    preparedStatement.setInt(1, databaseCache1.getIslandId());
                    ResultSet r1 = preparedStatement.executeQuery();
                    while (r1.next()) {
                        databaseCache1.setIslandname(r1.getString("island"));
                        databaseCache1.setIslandLevel(r1.getInt("islandlevel"));
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            DatabaseCache databaseCache = databaseCache1;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(databaseCache));
        });
    }

    public void getLatestIsland(CallbackStrings callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            int latestIsland = 0;
            try (Connection connection = this.connector.getConnection();){
                String database = this.connector.getDatabase();
                String preparedStatement1 = "SELECT AUTO_INCREMENT FROM information_schema.TABLES WHERE TABLE_SCHEMA = \"" + database + "\" AND TABLE_NAME = \"VSkyblock_Island\"";
                PreparedStatement preparedStatement = connection.prepareStatement(preparedStatement1);
                ResultSet r = preparedStatement.executeQuery();
                while (r.next()) {
                    latestIsland = r.getInt("AUTO_INCREMENT");
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (latestIsland == 0) {
                latestIsland = 1;
            }
            String islandname = "VSkyblockIsland_" + latestIsland;
            boolean a = true;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(islandname, true));
        });
    }

    public void getislandid(String island, CallbackINT callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            DatabaseCache databaseCache = new DatabaseCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT islandid FROM VSkyblock_Island WHERE island = ?");
                preparedStatement.setString(1, island);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    databaseCache.setIslandId(resultSet.getInt("islandid"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            int islandid = databaseCache.getIslandId();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(islandid));
        });
    }

    public void hasislandmembers(int islandid, CallbackBoolean callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            DatabaseCache databaseCache = new DatabaseCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Player WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    databaseCache.addIslandMember(resultSet.getString("playername"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            boolean hasmembers = databaseCache.getislandmembers().size() > 1;
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(hasmembers));
        });
    }

    public void getislandidfromplayer(UUID uuid, CallbackINT callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            DatabaseCache databaseCache = new DatabaseCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT islandid FROM VSkyblock_Player WHERE uuid = ?");
                preparedStatement.setString(1, uuid.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    databaseCache.setIslandId(resultSet.getInt("islandid"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            int islandid = databaseCache.getIslandId();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(islandid));
        });
    }

    public void getislandnamefromplayer(UUID uuid, CallbackString callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            DatabaseCache databaseCache = new DatabaseCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT islandid FROM VSkyblock_Player WHERE uuid = ?");
                preparedStatement.setString(1, uuid.toString());
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    databaseCache.setIslandId(resultSet.getInt("islandid"));
                }
                preparedStatement.close();
                PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT island FROM VSkyblock_Island WHERE islandid = ?");
                preparedStatement1.setInt(1, databaseCache.getIslandId());
                ResultSet resultSet1 = preparedStatement1.executeQuery();
                while (resultSet1.next()) {
                    databaseCache.setIslandname(resultSet1.getString("island"));
                }
                preparedStatement1.close();
                resultSet1.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            String island = databaseCache.getIslandname();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(island));
        });
    }

    public void getIslandMembers(Integer islandid, CallbackList callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ArrayList<String> islandmembers = new ArrayList<String>();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT playername FROM VSkyblock_Player WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    islandmembers.add(resultSet.getString("playername"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ArrayList<String> result = islandmembers;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(result));
        });
    }

    public void getemptyIslands(CallbackList callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ArrayList<Integer> islandids = new ArrayList<Integer>();
            ArrayList<String> emptyislands = new ArrayList<String>();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT islandid FROM VSkyblock_Island");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    islandids.add(resultSet.getInt("islandid"));
                }
                preparedStatement.close();
                for (Integer currentid : islandids) {
                    PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT * FROM VSkyblock_Player WHERE islandid = ?");
                    preparedStatement1.setInt(1, currentid);
                    ResultSet resultSet1 = preparedStatement1.executeQuery();
                    boolean hasmembers = false;
                    while (resultSet1.next()) {
                        hasmembers = true;
                    }
                    if (!hasmembers) {
                        emptyislands.add("VSkyblockIsland_" + currentid);
                    }
                    preparedStatement1.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ArrayList<String> result = emptyislands;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(result));
        });
    }

    public void getislandlevelfromuuid(UUID uuid, CallbackINT callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            DatabaseCache databaseCache = new DatabaseCache();
            try (Connection connection = this.connector.getConnection();){
                int islandid = 0;
                PreparedStatement prep = connection.prepareStatement("SELECT islandid FROM VSkyblock_Player WHERE uuid = ?");
                prep.setString(1, uuid.toString());
                ResultSet rs = prep.executeQuery();
                while (rs.next()) {
                    islandid = rs.getInt("islandid");
                }
                prep.close();
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT islandlevel FROM VSkyblock_Island WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    databaseCache.setIslandLevel(resultSet.getInt("islandlevel"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            int islandlevel = databaseCache.getIslandLevel();
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(islandlevel));
        });
    }

    public void getIslandChallenges(int islandid, cCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ChallengesCache cache = new ChallengesCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Challenges WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet r = preparedStatement.executeQuery();
                while (r.next()) {
                    cache.setChallengeCount(r.getString("challenge"), r.getInt("count"));
                    if (!r.getBoolean("tracked")) continue;
                    cache.addTrackedChallenge(r.getString("challenge"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ChallengesCache cache1 = cache;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(cache1));
        });
    }

    public void refreshIslands(List<Player> onlineplayers) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Connection connection = this.connector.getConnection();
            Location loc = null;
            String islandname = null;
            int islandid = 0;
            int cobblestonelevel = 0;
            int islandlevel = 0;
            ArrayList<Player> playerList = new ArrayList<Player>();
            try {
                for (Player player : onlineplayers) {
                    playerList.add(player);
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT islandid FROM VSkyblock_Player WHERE uuid = ?");
                    preparedStatement.setString(1, player.getUniqueId().toString());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        islandid = resultSet.getInt("islandid");
                    }
                    if (islandid != 0) {
                        PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT island FROM VSkyblock_Island WHERE islandid = ?");
                        preparedStatement1.setInt(1, islandid);
                        ResultSet resultSet1 = preparedStatement1.executeQuery();
                        while (resultSet1.next()) {
                            islandname = resultSet1.getString("island");
                        }
                        preparedStatement1.close();
                        PreparedStatement preparedStatementGetGeneratorLevel = connection.prepareStatement("SELECT cobblestonelevel FROM VSkyblock_Island WHERE islandid = ?");
                        preparedStatementGetGeneratorLevel.setInt(1, islandid);
                        ResultSet resultSet2 = preparedStatementGetGeneratorLevel.executeQuery();
                        while (resultSet2.next()) {
                            cobblestonelevel = resultSet2.getInt("cobblestonelevel");
                        }
                        preparedStatementGetGeneratorLevel.close();
                        PreparedStatement preparedStatementGetIslandLevel = connection.prepareStatement("SELECT islandlevel FROM VSkyblock_Island WHERE islandid = ?");
                        preparedStatementGetIslandLevel.setInt(1, islandid);
                        ResultSet resultSet3 = preparedStatementGetIslandLevel.executeQuery();
                        while (resultSet3.next()) {
                            islandlevel = resultSet3.getInt("islandlevel");
                        }
                        preparedStatementGetIslandLevel.close();
                        if (islandname != null) {
                            World w = this.plugin.getServer().getWorld(islandname);
                            PreparedStatement getIslandhome = connection.prepareStatement("SELECT * FROM VSkyblock_IslandLocations WHERE islandid = ?");
                            getIslandhome.setInt(1, islandid);
                            ResultSet r = getIslandhome.executeQuery();
                            while (r.next()) {
                                loc = new Location(w, r.getDouble("spawnX"), r.getDouble("spawnY"), r.getDouble("spawnZ"), r.getFloat("spawnYaw"), r.getFloat("spawnPitch"));
                            }
                        }
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Location finalLoc = loc;
            String finalIslandname = islandname;
            int finalIslandlevel = islandlevel;
            int finalCobblestonelevel = cobblestonelevel;
            this.plugin.getServer().getScheduler().runTask((Plugin)this.plugin, () -> {
                for (Player player : playerList) {
                    if (finalLoc != null) {
                        Island.islandhomes.put(finalIslandname, finalLoc);
                    }
                    if (finalIslandname == null || finalIslandname.equals("NULL")) continue;
                    Island.playerislands.put(player.getUniqueId(), finalIslandname);
                    CobblestoneGenerator.islandGenLevel.put(finalIslandname, finalCobblestonelevel);
                    CobblestoneGenerator.islandlevels.put(finalIslandname, finalIslandlevel);
                }
            });
        });
    }

    public void addToCobbleStoneGenerators(String islandname) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                int islandgeneratorLVL = 0;
                int islandlevel = 0;
                PreparedStatement preparedStatementGetGeneratorLevel = connection.prepareStatement("SELECT cobblestonelevel FROM VSkyblock_Island WHERE island = ?");
                preparedStatementGetGeneratorLevel.setString(1, islandname);
                ResultSet resultSet = preparedStatementGetGeneratorLevel.executeQuery();
                while (resultSet.next()) {
                    islandgeneratorLVL = resultSet.getInt("cobblestonelevel");
                }
                CobblestoneGenerator.islandGenLevel.put(islandname, islandgeneratorLVL);
                preparedStatementGetGeneratorLevel.close();
                PreparedStatement preparedStatementGetIslandLevel = connection.prepareStatement("SELECT islandlevel FROM VSkyblock_Island WHERE island = ?");
                preparedStatementGetIslandLevel.setString(1, islandname);
                ResultSet resultSet1 = preparedStatementGetIslandLevel.executeQuery();
                while (resultSet1.next()) {
                    islandlevel = resultSet1.getInt("islandlevel");
                }
                CobblestoneGenerator.islandlevels.put(islandname, islandlevel);
                preparedStatementGetIslandLevel.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void getHighestIslands(CallbackList callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            ArrayList<Integer> islandids = new ArrayList<Integer>();
            ArrayList<Integer> islandlevels = new ArrayList<Integer>();
            ArrayList<String> playersperisland = new ArrayList<String>();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Island ORDER BY CAST(islandlevel as unsigned) desc limit 5");
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    islandids.add(resultSet.getInt("islandid"));
                    islandlevels.add(resultSet.getInt("islandlevel"));
                }
                preparedStatement.close();
                for (int i = 0; i < islandids.size(); ++i) {
                    PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT * FROM VSkyblock_Player WHERE islandid = ?");
                    preparedStatement1.setInt(1, (Integer)islandids.get(i));
                    ResultSet resultSet1 = preparedStatement1.executeQuery();
                    StringBuilder memberList = null;
                    boolean hasmembers = false;
                    while (resultSet1.next()) {
                        hasmembers = true;
                        if (memberList == null) {
                            memberList = new StringBuilder(resultSet1.getString("playername"));
                            continue;
                        }
                        memberList.append(", ").append(resultSet1.getString("playername"));
                    }
                    if (!hasmembers) {
                        memberList = new StringBuilder("-");
                    }
                    memberList.append(" - ").append(islandlevels.get(i));
                    playersperisland.add(String.valueOf(memberList));
                    preparedStatement1.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            ArrayList<String> result = playersperisland;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(result));
        });
    }

    public void isislandvisitable(int islandid, CallbackBoolean callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean visitable = false;
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Island WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    visitable = resultSet.getBoolean("visit");
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            boolean finalvisitable = visitable;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(finalvisitable));
        });
    }

    public void islandneedsrequestforvisit(int islandid, CallbackBoolean callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            boolean needsrequest = false;
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Island WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet resultSet = preparedStatement.executeQuery();
                while (resultSet.next()) {
                    needsrequest = resultSet.getBoolean("visitneedsrequest");
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            boolean finalneedsrequest = needsrequest;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(finalneedsrequest));
        });
    }

    public void getIslandOptions(int islandid, isoptionsCallback callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            IslandOptionsCache islandOptionsCache = new IslandOptionsCache();
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Island WHERE islandid = ?");
                preparedStatement.setInt(1, islandid);
                ResultSet r = preparedStatement.executeQuery();
                while (r.next()) {
                    islandOptionsCache.setVisit(r.getBoolean("visit"));
                    islandOptionsCache.setDifficulty(r.getString("difficulty"));
                    islandOptionsCache.setNeedRequest(r.getBoolean("visitneedsrequest"));
                }
                preparedStatement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            IslandOptionsCache cache = islandOptionsCache;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(cache));
        });
    }

    public void refreshDeathCounts(List<Player> onlineplayers) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try (Connection connection = this.connector.getConnection();){
                for (Player player : onlineplayers) {
                    int deathcount = 0;
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT deaths FROM VSkyblock_Player WHERE uuid = ?");
                    preparedStatement.setString(1, player.getUniqueId().toString());
                    ResultSet resultSet = preparedStatement.executeQuery();
                    while (resultSet.next()) {
                        deathcount = resultSet.getInt("deaths");
                    }
                    if (deathcount != 0) {
                        Objective objective;
                        if (this.plugin.scoreboardmanager.doesobjectiveexist("deaths") && this.plugin.scoreboardmanager.hasPlayerScore(player.getName(), "deaths")) {
                            this.plugin.scoreboardmanager.updatePlayerScore(player.getName(), "deaths", deathcount);
                        }
                        if (this.plugin.getServer().getScoreboardManager().getMainScoreboard().getObjective("deaths") != null && (objective = this.plugin.getServer().getScoreboardManager().getMainScoreboard().getObjective("deaths")) != null) {
                            objective.getScore(player.getName()).setScore(deathcount);
                        }
                    }
                    preparedStatement.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    public void getlastLocation(UUID uuid, CallbackLocation callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Location location = null;
            double x = 0.0;
            double y = 67.0;
            double z = 0.0;
            double pitch = 0.0;
            double yaw = 0.0;
            String lastWorld = null;
            int islandid = 0;
            String island = null;
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement preparedStatement = connection.prepareStatement("SELECT * FROM VSkyblock_Player WHERE uuid = ?");
                preparedStatement.setString(1, uuid.toString());
                ResultSet r = preparedStatement.executeQuery();
                if (r.next()) {
                    islandid = r.getInt("islandid");
                    x = r.getDouble("lastX");
                    y = r.getDouble("lastY");
                    z = r.getDouble("lastZ");
                    pitch = r.getDouble("lastPitch");
                    yaw = r.getDouble("lastYaw");
                    lastWorld = r.getString("lastWorld");
                } else {
                    this.plugin.getServer().getLogger().log(Level.WARNING, "Could not find last location for uuid: " + uuid + "!");
                }
                preparedStatement.close();
                if (islandid != 0) {
                    PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT * FROM VSkyblock_Island WHERE islandid = ?");
                    preparedStatement1.setInt(1, islandid);
                    ResultSet r1 = preparedStatement1.executeQuery();
                    while (r1.next()) {
                        island = r1.getString("island");
                    }
                    preparedStatement1.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            if (lastWorld != null && y != 0.0 && this.plugin.getWorldManager().getLoadedWorlds().contains(lastWorld) && (this.plugin.getServer().getWorld(lastWorld).getEnvironment().equals((Object)World.Environment.NETHER) || lastWorld.equals(island))) {
                World world = this.plugin.getServer().getWorld(lastWorld);
                location = new Location(world, x, y, z, (float)yaw, (float)pitch);
            }
            Location finalLocation = location;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(finalLocation));
        });
    }

    public void getIslandsChallengePoints(int islandid, CallbackINT callback) {
        this.getIslandChallenges(islandid, cache -> {
            int challengeValueFirstComplete = this.getChallengeValueFirstComplete();
            int challengeValueAfterFirstComplete = this.getChallengeValueAfterFirstComplete();
            int challengeValueRepeats = this.getChallengeValueRepeats();
            int totalChallengePoints = 0;
            for (int currentc : cache.getAllChallengeCounts().values()) {
                if (currentc > challengeValueRepeats) {
                    currentc = challengeValueRepeats;
                }
                if (currentc <= 0) continue;
                int repeatedPoints = (currentc - 1) * challengeValueAfterFirstComplete;
                totalChallengePoints = totalChallengePoints + challengeValueFirstComplete + repeatedPoints;
            }
            callback.onQueryDone(totalChallengePoints);
        });
    }

    private int getChallengeValueFirstComplete() {
        if (ConfigShorts.getDefConfig().getString("ChallengeValueFirstComplete") != null) {
            String challengeValueFirstComplete = ConfigShorts.getDefConfig().getString("ChallengeValueFirstComplete");
            if (challengeValueFirstComplete != null) {
                if (this.isInt(challengeValueFirstComplete)) {
                    return Integer.parseInt(challengeValueFirstComplete);
                }
                return 150;
            }
            return 150;
        }
        return 150;
    }

    private int getChallengeValueAfterFirstComplete() {
        if (ConfigShorts.getDefConfig().getString("ChallengeValueAfterFirstComplete") != null) {
            String challengeValueAfterFirstComplete = ConfigShorts.getDefConfig().getString("ChallengeValueAfterFirstComplete");
            if (challengeValueAfterFirstComplete != null) {
                if (this.isInt(challengeValueAfterFirstComplete)) {
                    return Integer.parseInt(challengeValueAfterFirstComplete);
                }
                return 10;
            }
            return 10;
        }
        return 10;
    }

    private int getChallengeValueRepeats() {
        if (ConfigShorts.getDefConfig().getString("ChallengeValueRepeats") != null) {
            String challengeValueRepeats = ConfigShorts.getDefConfig().getString("ChallengeValueRepeats");
            if (challengeValueRepeats != null) {
                if (this.isInt(challengeValueRepeats)) {
                    return Integer.parseInt(challengeValueRepeats);
                }
                return 15;
            }
            return 15;
        }
        return 15;
    }

    private boolean isInt(String s) {
        try {
            Integer.parseInt(s);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public void getNetherHome(UUID uuid, CallbackLocation callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Location location = null;
            double x = 0.0;
            double y = 0.0;
            double z = 0.0;
            double yaw = 0.0;
            String world = null;
            int islandid = 0;
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement getislandid = connection.prepareStatement("SELECT islandid FROM VSkyblock_Player WHERE uuid = ?");
                getislandid.setString(1, uuid.toString());
                ResultSet r = getislandid.executeQuery();
                while (r.next()) {
                    islandid = r.getInt("islandid");
                }
                getislandid.close();
                if (islandid != 0) {
                    PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT * FROM VSkyblock_IslandLocations WHERE islandid = ?");
                    preparedStatement1.setInt(1, islandid);
                    ResultSet getLoc = preparedStatement1.executeQuery();
                    while (getLoc.next()) {
                        x = getLoc.getDouble("netherX");
                        y = getLoc.getDouble("netherY");
                        z = getLoc.getDouble("netherZ");
                        yaw = getLoc.getFloat("netherYaw");
                        world = getLoc.getString("netherWorld");
                    }
                    preparedStatement1.close();
                    if (world != null && this.plugin.getWorldManager().getLoadedWorlds().contains(world)) {
                        World w = this.plugin.getServer().getWorld(world);
                        location = new Location(w, x, y, z, (float)yaw, 0.0f);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Location finalLocation = location;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(finalLocation));
        });
    }

    public void getIslandSpawn(String world, CallbackLocation callback) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Location location = null;
            double x = 0.0;
            double y = 67.0;
            double z = 0.0;
            float yaw = 0.0f;
            float pitch = 0.0f;
            int islandid = 0;
            try (Connection connection = this.connector.getConnection();){
                PreparedStatement getislandid = connection.prepareStatement("SELECT islandid FROM VSkyblock_Island WHERE island = ?");
                getislandid.setString(1, world);
                ResultSet r = getislandid.executeQuery();
                while (r.next()) {
                    islandid = r.getInt("islandid");
                }
                getislandid.close();
                if (islandid != 0) {
                    PreparedStatement preparedStatement1 = connection.prepareStatement("SELECT * FROM VSkyblock_IslandLocations WHERE islandid = ?");
                    preparedStatement1.setInt(1, islandid);
                    ResultSet getLoc = preparedStatement1.executeQuery();
                    if (getLoc.next()) {
                        x = getLoc.getDouble("spawnX");
                        y = getLoc.getDouble("spawnY");
                        z = getLoc.getDouble("spawnZ");
                        yaw = getLoc.getFloat("spawnYaw");
                        pitch = getLoc.getFloat("spawnPitch");
                    } else {
                        this.plugin.getServer().getLogger().log(Level.WARNING, "Could not find island spawn location for island " + world + "!");
                    }
                    preparedStatement1.close();
                    if (world != null && this.plugin.getWorldManager().getLoadedWorlds().contains(world)) {
                        World w = this.plugin.getServer().getWorld(world);
                        location = new Location(w, x, y, z, yaw, pitch);
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            Location finalLocation = location;
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> callback.onQueryDone(finalLocation));
        });
    }

    public static interface Callback {
        public void onQueryDone(DatabaseCache var1);
    }

    public static interface CallbackStrings {
        public void onQueryDone(String var1, boolean var2);
    }

    public static interface CallbackINT {
        public void onQueryDone(int var1);
    }

    public static interface CallbackBoolean {
        public void onQueryDone(boolean var1);
    }

    public static interface CallbackString {
        public void onQueryDone(String var1);
    }

    public static interface CallbackList {
        public void onQueryDone(List<String> var1);
    }

    public static interface cCallback {
        public void onQueryDone(ChallengesCache var1);
    }

    public static interface isoptionsCallback {
        public void onQueryDone(IslandOptionsCache var1);
    }

    public static interface CallbackLocation {
        public void onQueryDone(Location var1);
    }
}

